/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.taxprovider1;

import com.ssa.ta.taxprovider1.Currency;
import com.ssa.ta.taxprovider1.CurrencyType;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.Manager1;
import com.ssa.ta.taxprovider1.OriginalCurrency;
import com.ssa.ta.taxprovider1.SellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.SellerDestination;
import com.ssa.ta.taxprovider1.SellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.TaxOnlyAdjustmentSaleRetObj1;

public class TaxOnlyAdjustmentSaleClient {
    private static final String EMPTY_STRING;
    private static final String SYSPROP_BUS_COMPONENT = "bc";
    private static final String DEFAULT_BUS_COMPONENT = "vertex";
    private static final String SYSPROP_DOCUMENT_NR = "documentNr";
    private static final String DEFAULT_DOCUMENT_NR;
    private static final String SYSPROP_DOCUMENT_DATE = "documentDate";
    private static final String DEFAULT_DOCUMENT_DATE = "2005-08-07";
    private static final String SYSPROP_CURRENCY = "orderCurrency";
    private static final String DEFAULT_CURRENCY = "USD";
    private static final String SYSPROP_ORIGINAL_CURRENCY = "originalOrderCurrency";
    private static final String DEFAULT_ORIGINAL_CURRENCY = "USD";
    private static final String SYSPROP_SELLER_COMPANY = "sellerCompany";
    private static final String DEFAULT_SELLER_COMPANY = "sellID1";
    private static final String SYSPROP_SELLER_PO_GEOCODE = "sellerPoGeocode";
    private static final String DEFAULT_SELLER_PO_GEOCODE;
    private static final String SYSPROP_SELLER_PO_STREET = "sellerPoStreet";
    private static final String DEFAULT_SELLER_PO_STREET;
    private static final String SYSPROP_SELLER_PO_CITY = "sellerPoCity";
    private static final String DEFAULT_SELLER_PO_CITY = "Montgomery";
    private static final String SYSPROP_SELLER_PO_STATE = "sellerPoState";
    private static final String DEFAULT_SELLER_PO_STATE = "AL";
    private static final String SYSPROP_SELLER_PO_COUNTY = "sellerPoCounty";
    private static final String DEFAULT_SELLER_PO_COUNTY = "Montgomery";
    private static final String SYSPROP_SELLER_PO_ZIP_CODE = "sellerPoZipCode";
    private static final String DEFAULT_SELLER_PO_ZIP_CODE = "36104";
    private static final String SYSPROP_SELLER_PO_COUNTRY = "sellerPoCountry";
    private static final String DEFAULT_SELLER_PO_COUNTRY = "USA";
    private static final String SYSPROP_SELLER_AO_GEOCODE = "sellerAoGeocode";
    private static final String DEFAULT_SELLER_AO_GEOCODE;
    private static final String SYSPROP_SELLER_AO_STREET = "sellerAoStreet";
    private static final String DEFAULT_SELLER_AO_STREET;
    private static final String SYSPROP_SELLER_AO_CITY = "sellerAoCity";
    private static final String DEFAULT_SELLER_AO_CITY;
    private static final String SYSPROP_SELLER_AO_STATE = "sellerAoState";
    private static final String DEFAULT_SELLER_AO_STATE;
    private static final String SYSPROP_SELLER_AO_COUNTY = "sellerAoCounty";
    private static final String DEFAULT_SELLER_AO_COUNTY;
    private static final String SYSPROP_SELLER_AO_ZIP_CODE = "sellerAoZipCode";
    private static final String DEFAULT_SELLER_AO_ZIP_CODE;
    private static final String SYSPROP_SELLER_AO_COUNTRY = "sellerAoCountry";
    private static final String DEFAULT_SELLER_AO_COUNTRY;
    private static final String SYSPROP_SELLER_DEST_GEOCODE = "sellerDestGeocode";
    private static final String DEFAULT_SELLER_DEST_GEOCODE;
    private static final String SYSPROP_SELLER_DEST_STREET = "sellerDestStreet";
    private static final String DEFAULT_SELLER_DEST_STREET;
    private static final String SYSPROP_SELLER_DEST_CITY = "sellerDestCity";
    private static final String DEFAULT_SELLER_DEST_CITY = "Montgomery";
    private static final String SYSPROP_SELLER_DEST_STATE = "sellerDestState";
    private static final String DEFAULT_SELLER_DEST_STATE = "AL";
    private static final String SYSPROP_SELLER_DEST_COUNTY = "sellerDestCounty";
    private static final String DEFAULT_SELLER_DEST_COUNTY = "Montgomery";
    private static final String SYSPROP_SELLER_DEST_ZIP_CODE = "sellerDestZipCode";
    private static final String DEFAULT_SELLER_DEST_ZIP_CODE = "36104";
    private static final String SYSPROP_SELLER_DEST_COUNTRY = "sellerDestCountry";
    private static final String DEFAULT_SELLER_DEST_COUNTRY = "USA";
    private static final String SYSPROP_INPUT_TOTAL_TAX = "inputTotalTax";
    private static final String DEFAULT_INPUT_TOTAL_TAX = "20000";

    private TaxOnlyAdjustmentSaleClient() {
    }

    public static void main(String[] p_args) {
        try {
            SellerDestination sellerDestinationReturn;
            SellerAdministrativeOrigin sellerAdministrativeOriginReturn;
            SellerPhysicalOrigin sellerPhysicalOriginReturn;
            String inputTotalTaxString;
            double inputTotalTax;
            TaxOnlyAdjustmentSaleRetObj1 returnObject;
            TaxOnlyAdjustmentSaleClient.log("Starting taxOnlyAdjustmentSale client...");
            String busComponent = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_BUS_COMPONENT, DEFAULT_BUS_COMPONENT);
            String documentNr = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_DOCUMENT_NR, DEFAULT_DOCUMENT_NR);
            String documentDate = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_DOCUMENT_DATE, DEFAULT_DOCUMENT_DATE);
            String orderCurrency = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_CURRENCY, "USD");
            String originalOrderCurrency = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_ORIGINAL_CURRENCY, "USD");
            String sellerCompany = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_COMPANY, DEFAULT_SELLER_COMPANY);
            String sellerPoGeocode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_GEOCODE, DEFAULT_SELLER_PO_GEOCODE);
            String sellerPoStreet = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_STREET, DEFAULT_SELLER_PO_STREET);
            String sellerPoCity = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_CITY, "Montgomery");
            String sellerPoState = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_STATE, "AL");
            String sellerPoCounty = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_COUNTY, "Montgomery");
            String sellerPoZipCode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_ZIP_CODE, "36104");
            String sellerPoCountry = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_PO_COUNTRY, "USA");
            String sellerAoGeocode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_GEOCODE, DEFAULT_SELLER_AO_GEOCODE);
            String sellerAoStreet = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_STREET, DEFAULT_SELLER_AO_STREET);
            String sellerAoCity = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_CITY, DEFAULT_SELLER_AO_CITY);
            String sellerAoState = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_STATE, DEFAULT_SELLER_AO_STATE);
            String sellerAoCounty = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_COUNTY, DEFAULT_SELLER_AO_COUNTY);
            String sellerAoZipCode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_ZIP_CODE, DEFAULT_SELLER_AO_ZIP_CODE);
            String sellerAoCountry = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_AO_COUNTRY, DEFAULT_SELLER_AO_COUNTRY);
            String sellerDestGeocode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_GEOCODE, DEFAULT_SELLER_DEST_GEOCODE);
            String sellerDestStreet = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_STREET, DEFAULT_SELLER_DEST_STREET);
            String sellerDestCity = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_CITY, "Montgomery");
            String sellerDestState = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_STATE, "AL");
            String sellerDestCounty = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_COUNTY, "Montgomery");
            String sellerDestZipCode = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_ZIP_CODE, "36104");
            String sellerDestCountry = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_SELLER_DEST_COUNTRY, "USA");
            TaxOnlyAdjustmentSaleClient.log("");
            TaxOnlyAdjustmentSaleClient.log("Connecting to bridge...");
            Manager1 taxProvider = new Manager1();
            taxProvider.initialize(busComponent);
            Currency currency = new Currency();
            CurrencyType currencyType = TaxOnlyAdjustmentSaleClient.newCurrencyType(orderCurrency);
            if (currencyType != null) {
                currency.setCurrencyType(currencyType);
            }
            OriginalCurrency originalCurrency = new OriginalCurrency();
            CurrencyType originalCurrencyType = TaxOnlyAdjustmentSaleClient.newCurrencyType(originalOrderCurrency);
            if (originalCurrencyType != null) {
                originalCurrency.setCurrencyType(originalCurrencyType);
            }
            SellerPhysicalOrigin sellerPhysicalOrigin = new SellerPhysicalOrigin();
            Location sellerPhysicalOriginLocation = TaxOnlyAdjustmentSaleClient.newLocation(sellerPoGeocode, sellerPoStreet, sellerPoCity, sellerPoZipCode, sellerPoCounty, sellerPoState, sellerPoCountry);
            if (sellerPhysicalOriginLocation != null) {
                sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
            }
            SellerAdministrativeOrigin sellerAdministrativeOrigin = new SellerAdministrativeOrigin();
            Location sellerAdministrativeOriginLocation = TaxOnlyAdjustmentSaleClient.newLocation(sellerAoGeocode, sellerAoStreet, sellerAoCity, sellerAoZipCode, sellerAoCounty, sellerAoState, sellerAoCountry);
            if (sellerAdministrativeOriginLocation != null) {
                sellerAdministrativeOrigin.setLocation(sellerAdministrativeOriginLocation);
            }
            SellerDestination sellerDestination = new SellerDestination();
            Location sellerDestinationLocation = TaxOnlyAdjustmentSaleClient.newLocation(sellerDestGeocode, sellerDestStreet, sellerDestCity, sellerDestZipCode, sellerDestCounty, sellerDestState, sellerDestCountry);
            if (sellerDestinationLocation != null) {
                sellerDestination.setLocation(sellerDestinationLocation);
            }
            if ((returnObject = taxProvider.taxOnlyAdjustmentSale(documentNr, documentDate, currency, originalCurrency, sellerCompany, sellerPhysicalOrigin, sellerAdministrativeOrigin, sellerDestination, inputTotalTax = (inputTotalTaxString = TaxOnlyAdjustmentSaleClient.getProperty(SYSPROP_INPUT_TOTAL_TAX, DEFAULT_INPUT_TOTAL_TAX)) != null ? Double.parseDouble(inputTotalTaxString) : -1.0)).hasDocumentNumber()) {
                String documentNrReturn = returnObject.getDocumentNumber();
                TaxOnlyAdjustmentSaleClient.log("\tDocumentNr: " + documentNrReturn);
            }
            if (returnObject.hasDocumentDate()) {
                String documentDateReturn = returnObject.getDocumentDate();
                TaxOnlyAdjustmentSaleClient.log("\tDocumentDate: " + documentDateReturn);
            }
            if (returnObject.hasSellerPhysicalOrigin() && (sellerPhysicalOriginReturn = returnObject.getSellerPhysicalOrigin()).hasLocation()) {
                TaxOnlyAdjustmentSaleClient.logLocation(sellerPhysicalOriginReturn.getLocation(), "\tSellerPhysicalOrigin");
            }
            if (returnObject.hasSellerAdministrativeOrigin() && (sellerAdministrativeOriginReturn = returnObject.getSellerAdministrativeOrigin()).hasLocation()) {
                TaxOnlyAdjustmentSaleClient.logLocation(sellerAdministrativeOriginReturn.getLocation(), "\tSellerAdministrativeOrigin");
            }
            if (returnObject.hasSellerDestination() && (sellerDestinationReturn = returnObject.getSellerDestination()).hasLocation()) {
                TaxOnlyAdjustmentSaleClient.logLocation(sellerDestinationReturn.getLocation(), "\tSellerDestination");
            }
            if (returnObject.hasTaxArray()) {
                TaxArray taxArrayReturn = returnObject.getTaxArray();
                int nrTaxes = taxArrayReturn.sizeTax();
                for (int i = 0; i < nrTaxes; ++i) {
                    Tax tax = taxArrayReturn.getTaxAt(i);
                    TaxOnlyAdjustmentSaleClient.log("\tTax[" + i + "]:");
                    if (tax.hasCalculatedTax()) {
                        double calculatedTax = tax.getCalculatedTax();
                        TaxOnlyAdjustmentSaleClient.log("\t\tCalculatedTax: " + calculatedTax);
                    }
                    if (tax.hasEffectiveRate()) {
                        double effectiveRate = tax.getEffectiveRate();
                        TaxOnlyAdjustmentSaleClient.log("\t\tEffectiveRate: " + effectiveRate);
                    }
                    if (tax.hasJurisdiction()) {
                        Jurisdiction jurisdiction = tax.getJurisdiction();
                        String jurisdictionName = "UNDEFINED";
                        String jurisdictionLevel = "UNDEFINED";
                        if (jurisdiction.hasJurisdictionName()) {
                            jurisdictionName = jurisdiction.getJurisdictionName();
                        }
                        if (jurisdiction.hasJurisdictionLevel()) {
                            jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                        }
                        TaxOnlyAdjustmentSaleClient.log("\t\tJurisdiction: " + jurisdictionName + " (" + jurisdictionLevel + ')');
                    }
                    if (!tax.hasTaxResult()) continue;
                    String taxResult = tax.getTaxResult();
                    TaxOnlyAdjustmentSaleClient.log("\t\tTaxResult: " + taxResult);
                }
            }
            if (returnObject.hasItemTotalTax()) {
                double itemTotalTaxReturn = returnObject.getItemTotalTax();
                TaxOnlyAdjustmentSaleClient.log("\tItemTotalTax: " + itemTotalTaxReturn);
            }
            TaxOnlyAdjustmentSaleClient.log("");
            taxProvider.close();
        }
        catch (Exception ex) {
            TaxOnlyAdjustmentSaleClient.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static void logLocation(Location p_location, String p_prefix) {
        if (p_location.hasGeocode()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "Geocode: " + p_location.getGeocode());
        }
        if (p_location.hasStreet()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "Street: " + p_location.getStreet());
        }
        if (p_location.hasCity()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "City: " + p_location.getCity());
        }
        if (p_location.hasZipCode()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "ZipCode: " + p_location.getZipCode());
        }
        if (p_location.hasCounty()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "County: " + p_location.getCounty());
        }
        if (p_location.hasState()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "State: " + p_location.getState());
        }
        if (p_location.hasCountry()) {
            TaxOnlyAdjustmentSaleClient.log(p_prefix + "Country: " + p_location.getCountry());
        }
    }

    private static Location newLocation(String p_geocode, String p_street, String p_city, String p_zipCode, String p_county, String p_state, String p_country) {
        if (p_geocode == null && p_street == null && p_city == null && p_zipCode == null && p_county == null && p_state == null && p_country == null) {
            return null;
        }
        Location location = new Location();
        if (p_geocode != null) {
            int geocode = Integer.parseInt(p_geocode);
            location.setGeocode(geocode);
        }
        if (p_street != null) {
            location.setStreet(p_street);
        }
        if (p_city != null) {
            location.setCity(p_city);
        }
        if (p_zipCode != null) {
            location.setZipCode(p_zipCode);
        }
        if (p_county != null) {
            location.setCounty(p_county);
        }
        if (p_state != null) {
            location.setState(p_state);
        }
        if (p_country != null) {
            location.setCountry(p_country);
        }
        return location;
    }

    private static CurrencyType newCurrencyType(String p_currency) {
        if (p_currency == null) {
            return null;
        }
        CurrencyType currencyType = new CurrencyType();
        if (p_currency != null) {
            currencyType.setIsoCurrencyCodeAlpha(p_currency);
        }
        return currencyType;
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        String displayValue = '\"' + value + '\"';
        if (value == null) {
            displayValue = "NOT SET";
        }
        TaxOnlyAdjustmentSaleClient.log("Using argument -D" + p_key + '=' + displayValue);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }

    static {
        DEFAULT_DOCUMENT_NR = EMPTY_STRING = new String().intern();
        DEFAULT_SELLER_PO_GEOCODE = null;
        DEFAULT_SELLER_PO_STREET = null;
        DEFAULT_SELLER_AO_GEOCODE = null;
        DEFAULT_SELLER_AO_STREET = null;
        DEFAULT_SELLER_AO_CITY = null;
        DEFAULT_SELLER_AO_STATE = null;
        DEFAULT_SELLER_AO_COUNTY = null;
        DEFAULT_SELLER_AO_ZIP_CODE = null;
        DEFAULT_SELLER_AO_COUNTRY = null;
        DEFAULT_SELLER_DEST_GEOCODE = null;
        DEFAULT_SELLER_DEST_STREET = null;
    }
}

