/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.taxprovider1;

import com.ssa.ta.taxprovider1.Currency;
import com.ssa.ta.taxprovider1.CurrencyType;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.Manager1;
import com.ssa.ta.taxprovider1.OriginalCurrency;
import com.ssa.ta.taxprovider1.QuotationSaleCustomerDestination;
import com.ssa.ta.taxprovider1.QuotationSaleSellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.QuotationSaleSellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.QuoteTaxForSale40RetObj1;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;

public class QuoteTax40Client {
    private static final String EMPTY_STRING;
    private static final String SYSPROP_BUS_COMPONENT = "bc";
    private static final String DEFAULT_BUS_COMPONENT = "vertex";
    private static final String SYSPROP_DOCUMENT_NR = "documentNr";
    private static final String DEFAULT_DOCUMENT_NR;
    private static final String SYSPROP_DOCUMENT_DATE = "documentDate";
    private static final String DEFAULT_DOCUMENT_DATE = "2006-12-07";
    private static final String SYSPROP_CURRENCY = "orderCurrency";
    private static final String DEFAULT_CURRENCY = "USD";
    private static final String SYSPROP_ORIGINAL_CURRENCY = "originalOrderCurrency";
    private static final String DEFAULT_ORIGINAL_CURRENCY = "USD";
    private static final String SYSPROP_SELLER_COMPANY = "sellerCompany";
    private static final String DEFAULT_SELLER_COMPANY = "custID1";
    private static final String SYSPROP_SELLER_PO_GEOCODE = "sellerPoGeocode";
    private static final String DEFAULT_SELLER_PO_GEOCODE;
    private static final String SYSPROP_SELLER_PO_STREET = "sellerPoStreet";
    private static final String DEFAULT_SELLER_PO_STREET;
    private static final String SYSPROP_SELLER_PO_CITY = "sellerPoCity";
    private static final String DEFAULT_SELLER_PO_CITY = "Montgomery";
    private static final String SYSPROP_SELLER_PO_STATE = "sellerPoState";
    private static final String DEFAULT_SELLER_PO_STATE = "AL";
    private static final String SYSPROP_SELLER_PO_COUNTY = "sellerPoCounty";
    private static final String DEFAULT_SELLER_PO_COUNTY = "Montgomery";
    private static final String SYSPROP_SELLER_PO_ZIP_CODE = "sellerPoZipCode";
    private static final String DEFAULT_SELLER_PO_ZIP_CODE = "36104";
    private static final String SYSPROP_SELLER_PO_COUNTRY = "sellerPoCountry";
    private static final String DEFAULT_SELLER_PO_COUNTRY = "USA";
    private static final String SYSPROP_SELLER_AO_GEOCODE = "sellerAoGeocode";
    private static final String DEFAULT_SELLER_AO_GEOCODE;
    private static final String SYSPROP_SELLER_AO_STREET = "sellerAoStreet";
    private static final String DEFAULT_SELLER_AO_STREET;
    private static final String SYSPROP_SELLER_AO_CITY = "sellerAoCity";
    private static final String DEFAULT_SELLER_AO_CITY;
    private static final String SYSPROP_SELLER_AO_STATE = "sellerAoState";
    private static final String DEFAULT_SELLER_AO_STATE;
    private static final String SYSPROP_SELLER_AO_COUNTY = "sellerAoCounty";
    private static final String DEFAULT_SELLER_AO_COUNTY;
    private static final String SYSPROP_SELLER_AO_ZIP_CODE = "sellerAoZipCode";
    private static final String DEFAULT_SELLER_AO_ZIP_CODE;
    private static final String SYSPROP_SELLER_AO_COUNTRY = "sellerAoCountry";
    private static final String DEFAULT_SELLER_AO_COUNTRY;
    private static final String SYSPROP_CUSTOMER_CODE = "customerCode";
    private static final String DEFAULT_CUSTOMER_CODE;
    private static final String SYSPROP_CUSTOMER_CLASS_CODE = "customerClassCode";
    private static final String DEFAULT_CUSTOMER_CLASS_CODE;
    private static final String SYSPROP_CUSTOMER_IS_TAX_EXEMPT = "customerIsTaxExempt";
    private static final String DEFAULT_CUSTOMER_IS_TAX_EXEMPT;
    private static final String SYSPROP_CUSTOMER_EXEMPT_REASON_CODE = "customerExemptReasonCode";
    private static final String DEFAULT_CUSTOMER_EXEMPT_REASON_CODE;
    private static final String SYSPROP_CUSTOMER_EXEMPT_CERT_NO = "customerExemptCertNo";
    private static final String DEFAULT_CUSTOMER_EXEMPT_CERT_NO;
    private static final String SYSPROP_CUSTOMER_COMPANY = "customerCompany";
    private static final String DEFAULT_CUSTOMER_COMPANY = "custID2";
    private static final String SYSPROP_CUSTOMER_DEST_GEOCODE = "customerDestGeocode";
    private static final String DEFAULT_CUSTOMER_DEST_GEOCODE;
    private static final String SYSPROP_CUSTOMER_DEST_STREET = "customerDestStreet";
    private static final String DEFAULT_CUSTOMER_DEST_STREET;
    private static final String SYSPROP_CUSTOMER_DEST_CITY = "customerDestCity";
    private static final String DEFAULT_CUSTOMER_DEST_CITY = "Montgomery";
    private static final String SYSPROP_CUSTOMER_DEST_STATE = "customerDestState";
    private static final String DEFAULT_CUSTOMER_DEST_STATE = "AL";
    private static final String SYSPROP_CUSTOMER_DEST_COUNTY = "customerDestCounty";
    private static final String DEFAULT_CUSTOMER_DEST_COUNTY = "Montgomery";
    private static final String SYSPROP_CUSTOMER_DEST_ZIP_CODE = "customerDestZipCode";
    private static final String DEFAULT_CUSTOMER_DEST_ZIP_CODE = "36104";
    private static final String SYSPROP_CUSTOMER_DEST_COUNTRY = "customerDestCountry";
    private static final String DEFAULT_CUSTOMER_DEST_COUNTRY = "USA";
    private static final String SYSPROP_ITEM_NUMBER = "itemNumber";
    private static final String DEFAULT_ITEM_NUMBER;
    private static final String SYSPROP_ITEM_PRODUCT = "itemProduct";
    private static final String DEFAULT_ITEM_PRODUCT;
    private static final String SYSPROP_ITEM_PRODUCT_CLASS = "itemProductClass";
    private static final String DEFAULT_ITEM_PRODUCT_CLASS;
    private static final String SYSPROP_ITEM_QUANTITY = "itemQuantity";
    private static final String DEFAULT_ITEM_QUANTITY = "100";
    private static final String SYSPROP_ITEM_EXTENDED_PRICE = "itemExtendedPrice";
    private static final String DEFAULT_ITEM_EXTENDED_PRICE = "1200";

    private QuoteTax40Client() {
    }

    public static void main(String[] p_args) {
        try {
            QuotationSaleCustomerDestination customerDestinationReturn;
            QuotationSaleSellerAdministrativeOrigin sellerAdministrativeOriginReturn;
            QuotationSaleSellerPhysicalOrigin sellerPhysicalOriginReturn;
            QuoteTax40Client.log("Starting calculateTax client...");
            String busComponent = QuoteTax40Client.getProperty(SYSPROP_BUS_COMPONENT, DEFAULT_BUS_COMPONENT);
            String documentNr = QuoteTax40Client.getProperty(SYSPROP_DOCUMENT_NR, DEFAULT_DOCUMENT_NR);
            String documentDate = QuoteTax40Client.getProperty(SYSPROP_DOCUMENT_DATE, DEFAULT_DOCUMENT_DATE);
            String sellerCompany = QuoteTax40Client.getProperty(SYSPROP_SELLER_COMPANY, DEFAULT_SELLER_COMPANY);
            String orderCurrency = QuoteTax40Client.getProperty(SYSPROP_CURRENCY, "USD");
            String originalOrderCurrency = QuoteTax40Client.getProperty(SYSPROP_ORIGINAL_CURRENCY, "USD");
            String sellerPoGeocode = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_GEOCODE, DEFAULT_SELLER_PO_GEOCODE);
            String sellerPoStreet = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_STREET, DEFAULT_SELLER_PO_STREET);
            String sellerPoCity = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_CITY, "Montgomery");
            String sellerPoState = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_STATE, "AL");
            String sellerPoCounty = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_COUNTY, "Montgomery");
            String sellerPoZipCode = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_ZIP_CODE, "36104");
            String sellerPoCountry = QuoteTax40Client.getProperty(SYSPROP_SELLER_PO_COUNTRY, "USA");
            String sellerAoGeocode = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_GEOCODE, DEFAULT_SELLER_AO_GEOCODE);
            String sellerAoStreet = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_STREET, DEFAULT_SELLER_AO_STREET);
            String sellerAoCity = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_CITY, DEFAULT_SELLER_AO_CITY);
            String sellerAoState = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_STATE, DEFAULT_SELLER_AO_STATE);
            String sellerAoCounty = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_COUNTY, DEFAULT_SELLER_AO_COUNTY);
            String sellerAoZipCode = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_ZIP_CODE, DEFAULT_SELLER_AO_ZIP_CODE);
            String sellerAoCountry = QuoteTax40Client.getProperty(SYSPROP_SELLER_AO_COUNTRY, DEFAULT_SELLER_AO_COUNTRY);
            String customerCode = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_CODE, DEFAULT_CUSTOMER_CODE);
            String customerClassCode = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_CLASS_CODE, DEFAULT_CUSTOMER_CLASS_CODE);
            String customerIsTaxExemptString = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_IS_TAX_EXEMPT, DEFAULT_CUSTOMER_IS_TAX_EXEMPT);
            boolean customerIsTaxExempt = "true".equals(customerIsTaxExemptString);
            String customerExemptReasonCode = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_EXEMPT_REASON_CODE, DEFAULT_CUSTOMER_EXEMPT_REASON_CODE);
            String customerExemptCertNo = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_EXEMPT_CERT_NO, DEFAULT_CUSTOMER_EXEMPT_CERT_NO);
            String customerCompany = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_COMPANY, DEFAULT_CUSTOMER_COMPANY);
            String customerDestGeocode = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_GEOCODE, DEFAULT_CUSTOMER_DEST_GEOCODE);
            String customerDestStreet = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_STREET, DEFAULT_CUSTOMER_DEST_STREET);
            String customerDestCity = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_CITY, "Montgomery");
            String customerDestState = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_STATE, "AL");
            String customerDestCounty = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_COUNTY, "Montgomery");
            String customerDestZipCode = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_ZIP_CODE, "36104");
            String customerDestCountry = QuoteTax40Client.getProperty(SYSPROP_CUSTOMER_DEST_COUNTRY, "USA");
            String itemNumberString = QuoteTax40Client.getProperty(SYSPROP_ITEM_NUMBER, DEFAULT_ITEM_NUMBER);
            int itemNumber = itemNumberString != null ? Integer.parseInt(itemNumberString) : -1;
            String itemProduct = QuoteTax40Client.getProperty(SYSPROP_ITEM_PRODUCT, DEFAULT_ITEM_PRODUCT);
            String itemProductClass = QuoteTax40Client.getProperty(SYSPROP_ITEM_PRODUCT_CLASS, DEFAULT_ITEM_PRODUCT_CLASS);
            String itemQuantityString = QuoteTax40Client.getProperty(SYSPROP_ITEM_QUANTITY, DEFAULT_ITEM_QUANTITY);
            double itemQuantity = itemQuantityString != null ? Double.parseDouble(itemQuantityString) : -1.0;
            String itemExtendedPriceString = QuoteTax40Client.getProperty(SYSPROP_ITEM_EXTENDED_PRICE, DEFAULT_ITEM_EXTENDED_PRICE);
            double itemExtendedPrice = itemExtendedPriceString != null ? Double.parseDouble(itemExtendedPriceString) : -1.0;
            QuoteTax40Client.log("");
            QuoteTax40Client.log("Connecting to bridge...");
            Manager1 taxProvider = new Manager1();
            taxProvider.initialize(busComponent);
            Currency currency = new Currency();
            CurrencyType currencyType = QuoteTax40Client.newCurrencyType(orderCurrency);
            if (currencyType != null) {
                currency.setCurrencyType(currencyType);
            }
            OriginalCurrency originalCurrency = new OriginalCurrency();
            CurrencyType originalCurrencyType = QuoteTax40Client.newCurrencyType(originalOrderCurrency);
            if (originalCurrencyType != null) {
                originalCurrency.setCurrencyType(originalCurrencyType);
            }
            QuotationSaleSellerPhysicalOrigin sellerPhysicalOrigin = new QuotationSaleSellerPhysicalOrigin();
            Location sellerPhysicalOriginLocation = QuoteTax40Client.newLocation(sellerPoGeocode, sellerPoStreet, sellerPoCity, sellerPoZipCode, sellerPoCounty, sellerPoState, sellerPoCountry);
            if (sellerPhysicalOriginLocation != null) {
                sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
            }
            QuotationSaleSellerAdministrativeOrigin sellerAdministrativeOrigin = new QuotationSaleSellerAdministrativeOrigin();
            Location sellerAdministrativeOriginLocation = QuoteTax40Client.newLocation(sellerAoGeocode, sellerAoStreet, sellerAoCity, sellerAoZipCode, sellerAoCounty, sellerAoState, sellerAoCountry);
            if (sellerAdministrativeOriginLocation != null) {
                sellerAdministrativeOrigin.setLocation(sellerAdministrativeOriginLocation);
            }
            QuotationSaleCustomerDestination customerDestination = new QuotationSaleCustomerDestination();
            Location customerDestinationLocation = QuoteTax40Client.newLocation(customerDestGeocode, customerDestStreet, customerDestCity, customerDestZipCode, customerDestCounty, customerDestState, customerDestCountry);
            if (customerDestinationLocation != null) {
                customerDestination.setLocation(customerDestinationLocation);
            }
            QuoteTaxForSale40RetObj1 returnObject = taxProvider.quoteTaxForSale40(documentNr, documentDate, currency, originalCurrency, sellerCompany, sellerPhysicalOrigin, sellerAdministrativeOrigin, customerCode, customerClassCode, customerIsTaxExempt, customerExemptReasonCode, customerExemptCertNo, customerCompany, customerDestination, itemNumber, itemProduct, itemProductClass, itemQuantity, itemExtendedPrice);
            QuoteTax40Client.log("Response:");
            if (returnObject.hasDocumentNumber()) {
                String documentNrReturn = returnObject.getDocumentNumber();
                QuoteTax40Client.log("\tDocumentNr: " + documentNrReturn);
            }
            if (returnObject.hasDocumentDate()) {
                String documentDateReturn = returnObject.getDocumentDate();
                QuoteTax40Client.log("\tDocumentDate: " + documentDateReturn);
            }
            if (returnObject.hasQuotationSaleSellerPhysicalOrigin() && (sellerPhysicalOriginReturn = returnObject.getQuotationSaleSellerPhysicalOrigin()).hasLocation()) {
                QuoteTax40Client.logLocation(sellerPhysicalOriginReturn.getLocation(), "\tSellerPhysicalOrigin");
            }
            if (returnObject.hasQuotationSaleSellerAdministrativeOrigin() && (sellerAdministrativeOriginReturn = returnObject.getQuotationSaleSellerAdministrativeOrigin()).hasLocation()) {
                QuoteTax40Client.logLocation(sellerAdministrativeOriginReturn.getLocation(), "\tSellerAdministrativeOrigin");
            }
            if (returnObject.hasQuotationSaleCustomerDestination() && (customerDestinationReturn = returnObject.getQuotationSaleCustomerDestination()).hasLocation()) {
                QuoteTax40Client.logLocation(customerDestinationReturn.getLocation(), "\tCustomerDestination");
            }
            if (returnObject.hasItemNumber()) {
                int itemNumberReturn = returnObject.getItemNumber();
                QuoteTax40Client.log("\tItemNumber: " + itemNumberReturn);
            }
            if (returnObject.hasItemProduct()) {
                String itemProductReturn = returnObject.getItemProduct();
                QuoteTax40Client.log("\tItemProduct: " + itemProductReturn);
            }
            if (returnObject.hasItemProductClass()) {
                String itemProductClassReturn = returnObject.getItemProductClass();
                QuoteTax40Client.log("\tItemProductClass: " + itemProductClassReturn);
            }
            if (returnObject.hasItemQuantity()) {
                double itemQuantityReturn = returnObject.getItemQuantity();
                QuoteTax40Client.log("\tItemQuantity: " + itemQuantityReturn);
            }
            if (returnObject.hasItemExtendedPrice()) {
                double itemExtendedPriceReturn = returnObject.getItemExtendedPrice();
                QuoteTax40Client.log("\tItemExtendedPrice: " + itemExtendedPriceReturn);
            }
            if (returnObject.hasTaxArray()) {
                TaxArray taxArrayReturn = returnObject.getTaxArray();
                int nrTaxes = taxArrayReturn.sizeTax();
                for (int i = 0; i < nrTaxes; ++i) {
                    Tax tax = taxArrayReturn.getTaxAt(i);
                    QuoteTax40Client.log("\tTax[" + i + "]:");
                    if (tax.hasCalculatedTax()) {
                        double calculatedTax = tax.getCalculatedTax();
                        QuoteTax40Client.log("\t\tCalculatedTax: " + calculatedTax);
                    }
                    if (tax.hasEffectiveRate()) {
                        double effectiveRate = tax.getEffectiveRate();
                        QuoteTax40Client.log("\t\tEffectiveRate: " + effectiveRate);
                    }
                    if (tax.hasJurisdiction()) {
                        Jurisdiction jurisdiction = tax.getJurisdiction();
                        String jurisdictionName = "UNDEFINED";
                        String jurisdictionLevel = "UNDEFINED";
                        if (jurisdiction.hasJurisdictionName()) {
                            jurisdictionName = jurisdiction.getJurisdictionName();
                        }
                        if (jurisdiction.hasJurisdictionLevel()) {
                            jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                        }
                        QuoteTax40Client.log("\t\tJurisdiction: " + jurisdictionName + " (" + jurisdictionLevel + ')');
                    }
                    if (!tax.hasTaxResult()) continue;
                    String taxResult = tax.getTaxResult();
                    QuoteTax40Client.log("\t\tTaxResult: " + taxResult);
                }
            }
            if (returnObject.hasItemTotalTax()) {
                double itemTotalTaxReturn = returnObject.getItemTotalTax();
                QuoteTax40Client.log("\tItemTotalTax: " + itemTotalTaxReturn);
            }
            QuoteTax40Client.log("");
            taxProvider.close();
        }
        catch (Exception ex) {
            QuoteTax40Client.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static void logLocation(Location p_location, String p_prefix) {
        if (p_location.hasGeocode()) {
            QuoteTax40Client.log(p_prefix + "Geocode: " + p_location.getGeocode());
        }
        if (p_location.hasStreet()) {
            QuoteTax40Client.log(p_prefix + "Street: " + p_location.getStreet());
        }
        if (p_location.hasCity()) {
            QuoteTax40Client.log(p_prefix + "City: " + p_location.getCity());
        }
        if (p_location.hasZipCode()) {
            QuoteTax40Client.log(p_prefix + "ZipCode: " + p_location.getZipCode());
        }
        if (p_location.hasCounty()) {
            QuoteTax40Client.log(p_prefix + "County: " + p_location.getCounty());
        }
        if (p_location.hasState()) {
            QuoteTax40Client.log(p_prefix + "State: " + p_location.getState());
        }
        if (p_location.hasCountry()) {
            QuoteTax40Client.log(p_prefix + "Country: " + p_location.getCountry());
        }
    }

    private static Location newLocation(String p_geocode, String p_street, String p_city, String p_zipCode, String p_county, String p_state, String p_country) {
        if (p_geocode == null && p_street == null && p_city == null && p_zipCode == null && p_county == null && p_state == null && p_country == null) {
            return null;
        }
        Location location = new Location();
        if (p_geocode != null) {
            int geocode = Integer.parseInt(p_geocode);
            location.setGeocode(geocode);
        }
        if (p_street != null) {
            location.setStreet(p_street);
        }
        if (p_city != null) {
            location.setCity(p_city);
        }
        if (p_zipCode != null) {
            location.setZipCode(p_zipCode);
        }
        if (p_county != null) {
            location.setCounty(p_county);
        }
        if (p_state != null) {
            location.setState(p_state);
        }
        if (p_country != null) {
            location.setCountry(p_country);
        }
        return location;
    }

    private static CurrencyType newCurrencyType(String p_currency) {
        if (p_currency == null) {
            return null;
        }
        CurrencyType currencyType = new CurrencyType();
        if (p_currency != null) {
            currencyType.setIsoCurrencyCodeAlpha(p_currency);
        }
        return currencyType;
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        String displayValue = '\"' + value + '\"';
        if (value == null) {
            displayValue = "NOT SET";
        }
        QuoteTax40Client.log("Using argument -D" + p_key + '=' + displayValue);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }

    static {
        DEFAULT_DOCUMENT_NR = EMPTY_STRING = new String().intern();
        DEFAULT_SELLER_PO_GEOCODE = null;
        DEFAULT_SELLER_PO_STREET = null;
        DEFAULT_SELLER_AO_GEOCODE = null;
        DEFAULT_SELLER_AO_STREET = null;
        DEFAULT_SELLER_AO_CITY = null;
        DEFAULT_SELLER_AO_STATE = null;
        DEFAULT_SELLER_AO_COUNTY = null;
        DEFAULT_SELLER_AO_ZIP_CODE = null;
        DEFAULT_SELLER_AO_COUNTRY = null;
        DEFAULT_CUSTOMER_CODE = EMPTY_STRING;
        DEFAULT_CUSTOMER_CLASS_CODE = EMPTY_STRING;
        DEFAULT_CUSTOMER_IS_TAX_EXEMPT = null;
        DEFAULT_CUSTOMER_EXEMPT_REASON_CODE = EMPTY_STRING;
        DEFAULT_CUSTOMER_EXEMPT_CERT_NO = null;
        DEFAULT_CUSTOMER_DEST_GEOCODE = null;
        DEFAULT_CUSTOMER_DEST_STREET = null;
        DEFAULT_ITEM_NUMBER = null;
        DEFAULT_ITEM_PRODUCT = EMPTY_STRING;
        DEFAULT_ITEM_PRODUCT_CLASS = EMPTY_STRING;
    }
}

