/*
 * Decompiled with CFR 0.152.
 */
package soapical.util;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;
import soapical.likeoldsax.FriendlyNamespaceSupport;
import soapical.likeoldsax.NamespaceIron;
import soapical.util.Soapkit;
import soapical.util.SoapkitConstants;
import soapical.util.XMLArgCheck;
import unannoy.util.ArgCheck;

public class SAXToSOAPElement
extends DefaultHandler
implements SoapkitConstants {
    protected static SOAPFactory _factory = null;
    private FriendlyNamespaceSupport _namespaces;
    private SOAPElement _lastParse;
    private Stack _elements;
    private boolean _hasRoot;
    private SOAPBody _body;
    private SOAPHeader _header;
    private static final String CLASSNAME = SAXToSOAPElement.class.getName();
    static Logger _logger = Logger.getLogger(CLASSNAME);
    static final String UCLASSNAME = "SAXToSOAPElement";

    public SAXToSOAPElement() throws SOAPException {
        _factory = Soapkit.getSOAPFactory();
        this._elements = new Stack();
        this._lastParse = null;
        this._namespaces = new FriendlyNamespaceSupport();
    }

    public SAXToSOAPElement(SOAPBody body) throws SOAPException {
        this();
        this._body = body;
    }

    public SAXToSOAPElement(SOAPHeader header) throws SOAPException {
        this();
        this._header = header;
    }

    public SOAPElement getLastParse() {
        return this._lastParse;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        _logger.entering(CLASSNAME, "startElement", new Object[]{uri, localName, qName, atts});
        super.startElement(uri, localName, qName, atts);
        this._namespaces.pushContext();
        this._namespaces.declareNamespaces(uri, localName, qName);
        this._namespaces.declareNamespaces(atts);
        try {
            String ncName = NamespaceIron.toNcName(localName, qName);
            Name name = SAXToSOAPElement.getName(uri, ncName, this._namespaces);
            SOAPElement se = this._elements.isEmpty() ? this.getRootElement(name) : _factory.createElement(name);
            int noOfAttributes = atts.getLength();
            for (int i = 0; i < noOfAttributes; ++i) {
                String attrURI = atts.getURI(i);
                String attrLocalName = atts.getLocalName(i);
                String attrPrefix = this._namespaces.getPrefix(attrURI);
                String attrValue = atts.getValue(i);
                if (!"xmlns".equals(attrPrefix) && !"xmlns".equals(attrLocalName)) {
                    Name attrName = SAXToSOAPElement.getName(attrURI, attrLocalName, this._namespaces);
                    se.addAttribute(attrName, attrValue);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("ignoring attribute " + attrPrefix + " " + attrLocalName + "=" + attrValue);
            }
            this._elements.push(se);
        }
        catch (SOAPException sx) {
            throw new SAXException((Exception)((Object)sx));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._elements.isEmpty()) {
            _logger.severe("should not get here (endElement + empty stack)");
            super.endElement(uri, localName, qName);
            return;
        }
        SOAPElement se = (SOAPElement)this._elements.pop();
        boolean isRootElement = this._elements.isEmpty();
        if (!isRootElement) {
            SOAPElement parent = (SOAPElement)this._elements.peek();
            try {
                parent.addChildElement(se);
            }
            catch (SOAPException sx) {
                throw new SAXException((Exception)((Object)sx));
            }
        } else {
            this._lastParse = se;
        }
        this._namespaces.popContext();
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        super.characters(ch, start, len);
        try {
            if (!this._elements.isEmpty()) {
                SOAPElement se = (SOAPElement)this._elements.peek();
                se.addTextNode(new String(ch, start, len));
            }
        }
        catch (SOAPException sx) {
            throw new SAXException((Exception)((Object)sx));
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this._namespaces.popContext();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._namespaces.pushContext();
        this._namespaces.declarePrefix(prefix, uri);
    }

    protected SOAPElement getRootElement(Name name) throws SOAPException {
        if (this._body != null) {
            return this._body.addBodyElement(name);
        }
        if (this._header != null) {
            return this._header.addHeaderElement(name);
        }
        return _factory.createElement(name);
    }

    protected static Name getName(String uri, String ncName, NamespaceSupport namespaces) throws SOAPException {
        String here = "SAXToSOAPElement#getName";
        XMLArgCheck.notQName(here, "ncName", ncName);
        ArgCheck.notNull(here, "namespaces", namespaces);
        String prefix = namespaces.getPrefix(uri);
        if (prefix == null) {
            prefix = "";
        }
        return _factory.createName(ncName, prefix, uri);
    }
}

