/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1.vertex1;

import com.ssa.ta.vertex1.ws.bindings.InvoiceResponseType;
import com.ssa.ta.vertex1.ws.bindings.LoginType;
import com.ssa.ta.vertex1.ws.bindings.ObjectFactory;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderResponseType;
import com.ssa.ta.vertex1.ws.bindings.QuotationResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentResponseType;
import com.ssa.ta.vertex1.ws.bindings.VersionResponseType;
import com.ssa.ta.vertex1.ws.bindings.VertexEnvelope;
import com.ssa.taimpl.taxprovider1.vertex1.JaxbValidationHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import soapical.util.SAXToSOAPElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util
extends com.ssa.taimpl.taxprovider1.Util {
    private static final String C_NAME = Util.class.getName();
    private static final String TAX_PROVIDER_ID = "vertex";
    private static final String PROP_CALCULATE_TAX_END_POINT_ADDR = "address.calculate.tax";
    private static final String PROP_LOOKUP_TAX_AREAS_END_POINT_ADDR = "address.lookup.tax.areas";
    private static final String PROP_VERSION_REQUEST_END_POINT_ADDR = "address.version.request";
    private static final String PROP_USER_NAME = "user.name";
    private static final String PROP_PASSWORD = "password";
    private static final String PROBLEMATIC_NAMESPACE_XSI = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final Util INSTANCE = new Util();
    private static final Logger s_logger = INSTANCE.getLogger();
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final JaxbValidationHandler SERIALISATION_VALIDATION_EVENT_HANDLER = new JaxbValidationHandler("While serialising XML: ");
    private static final JaxbValidationHandler PARSE_VALIDATION_EVENT_HANDLER = new JaxbValidationHandler("While parsing XML: ");
    private static String s_calculateTaxEndPointAddress = null;
    private static String s_lookupTaxAreasEndPointAddress = null;
    private static String s_lookupVersionRequestEndPointAddress = null;
    private static String s_userName = null;
    private static String s_password = null;
    private static JAXBContext s_bindContext = null;

    static Util getInstance() {
        return INSTANCE;
    }

    Object doCalculateTaxRequest(Object p_request, Class<InvoiceResponseType> p_responseType) {
        return this.doVertexRequest(this.getCalculateTaxEndPointAddress(), p_request, p_responseType);
    }

    Object doQuoteForSaleRequest(Object p_request, Class<QuotationResponseType> p_responseType) {
        return this.doVertexRequest(this.getCalculateTaxEndPointAddress(), p_request, p_responseType);
    }

    Object doPurchaseOrderTPPRequest(Object p_request, Class<PurchaseOrderResponseType> p_responseType) {
        return this.doVertexRequest(this.getCalculateTaxEndPointAddress(), p_request, p_responseType);
    }

    Object doTaxOnlyAdjustmentRequest(Object p_request, Class<TaxOnlyAdjustmentResponseType> p_responseType) {
        return this.doVertexRequest(this.getCalculateTaxEndPointAddress(), p_request, p_responseType);
    }

    Object doLookupTaxAreasRequest(Object p_request, Class<TaxAreaResponseType> p_responseType) {
        return this.doVertexRequest(this.getLookupTaxAreasEndPointAddress(), p_request, p_responseType);
    }

    Object doVersionRequest(Object p_request, Class<VersionResponseType> p_responseType) {
        return this.doVertexRequest(this.getLookupVersionRequestEndPointAddress(), p_request, p_responseType);
    }

    private Object doVertexRequest(String p_endPointAddress, Object p_request, Class p_responseType) {
        String M_NAME = "doVertexRequest";
        s_logger.entering(C_NAME, "doVertexRequest");
        SOAPElement requestElement = null;
        try {
            VertexEnvelope envelope = OBJECT_FACTORY.createVertexEnvelope();
            LoginType login = OBJECT_FACTORY.createLoginType();
            login.setUserName(this.getUserName());
            login.setPassword(this.getPassword());
            envelope.setLogin(login);
            envelope.setRequestOrResponse(p_request);
            SAXToSOAPElement domToSaajConverter = new SAXToSOAPElement();
            Marshaller marshaller = this.getBindContext().createMarshaller();
            if (s_logger.isLoggable(Level.FINE)) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.setEventHandler((ValidationEventHandler)SERIALISATION_VALIDATION_EVENT_HANDLER);
                StringWriter stringWriter = new StringWriter();
                marshaller.marshal((Object)envelope, (Writer)stringWriter);
                s_logger.fine("Generated web service request:" + NL + stringWriter.toString());
            }
            marshaller.marshal((Object)envelope, (ContentHandler)domToSaajConverter);
            requestElement = domToSaajConverter.getLastParse();
        }
        catch (Exception ex) {
            throw this.newSevereRuntimeException("Could not construct Vertex request message", ex);
        }
        Element responseElement = this.doSoapRequest(p_endPointAddress, requestElement);
        Object responseCandidate = null;
        try {
            VertexEnvelope vertexEnvelope;
            Unmarshaller unmarshaller = this.getBindContext().createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)PARSE_VALIDATION_EVENT_HANDLER);
            Object envelopeCandidate = unmarshaller.unmarshal((Node)responseElement);
            if (!(envelopeCandidate instanceof VertexEnvelope)) {
                this.newSevereRuntimeException("Element in SOAP body is not of the expected type (expected VertexEnvelopeType, found " + envelopeCandidate.getClass().getName() + ")");
            }
            if (!p_responseType.isInstance(responseCandidate = (vertexEnvelope = (VertexEnvelope)envelopeCandidate).getRequestOrResponse())) {
                this.newSevereRuntimeException("VertexEnvelope response element does not contain the expected type (expected " + p_responseType.getName() + ", found " + responseCandidate.getClass().getName() + ')');
            }
            s_logger.finer("Parsed response.");
        }
        catch (JAXBException ex_jb) {
            throw this.newSevereRuntimeException("Could not parse SOAP response message", ex_jb);
        }
        s_logger.exiting(C_NAME, "doVertexRequest");
        return responseCandidate;
    }

    private Element doSoapRequest(String p_endPointAddress, SOAPElement p_requestElement) {
        ByteArrayOutputStream byteArrayOutputStream;
        String M_NAME = "doSoapRequest";
        s_logger.entering(C_NAME, "doSoapRequest");
        SOAPMessage soapRequest = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            soapRequest = messageFactory.createMessage();
            SOAPBody requestBody = soapRequest.getSOAPBody();
            MimeHeaders hd = soapRequest.getMimeHeaders();
            hd.addHeader("SOAPAction", "");
            requestBody.addChildElement(p_requestElement);
        }
        catch (SOAPException ex_s) {
            throw this.newSevereRuntimeException("Could not construct SOAP request message", ex_s);
        }
        SOAPMessage soapResponse = null;
        try {
            SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = connectionFactory.createConnection();
            soapResponse = connection.call(soapRequest, (Object)p_endPointAddress);
            s_logger.finer("Web service call succeeded.");
            if (s_logger.isLoggable(Level.FINE)) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    soapResponse.writeTo((OutputStream)byteArrayOutputStream);
                    s_logger.fine("Received web service response:" + NL + byteArrayOutputStream.toString("UTF-8"));
                }
                catch (IOException ex_io) {
                    this.fineThrowable("Could not serialise response message", ex_io);
                }
            }
        }
        catch (SOAPException ex_s) {
            throw this.newSevereRuntimeException("Could not execute web service request", ex_s);
        }
        SOAPBody responseBody = null;
        try {
            SOAPPart part = soapResponse.getSOAPPart();
            byteArrayOutputStream = new ByteArrayOutputStream();
            soapResponse.writeTo((OutputStream)byteArrayOutputStream);
            String response = byteArrayOutputStream.toString();
            int i = response.indexOf(PROBLEMATIC_NAMESPACE_XSI);
            if (i > 0) {
                response = response.substring(0, i) + response.substring(i + PROBLEMATIC_NAMESPACE_XSI.length(), response.length());
                ByteArrayInputStream Bis1 = new ByteArrayInputStream(response.getBytes("UTF-8"));
                StreamSource messageStream = new StreamSource(Bis1);
                part.setContent((Source)messageStream);
            }
            SOAPEnvelope envelope = part.getEnvelope();
            responseBody = envelope.getBody();
        }
        catch (Exception ex_s) {
            throw this.newSevereRuntimeException("Could not extract SOAP body from message", ex_s);
        }
        if (responseBody.hasFault()) {
            StringBuffer buffer = new StringBuffer("Received SOAP Fault.");
            SOAPFault fault = responseBody.getFault();
            Name faultCode = fault.getFaultCodeAsName();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(faultCode.getURI())) {
                buffer.append(" The faultcode has an unrecognised namespace (").append(faultCode.getURI()).append("); attempting to interpret the code anyway.");
            }
            String faultCodeLocalName = faultCode.getLocalName();
            buffer.append(" Faultcode was '").append(faultCodeLocalName).append("'.");
            int dotIndex = faultCodeLocalName.indexOf(46);
            String faultCodeClass = dotIndex < 0 ? faultCodeLocalName : faultCodeLocalName.substring(0, dotIndex);
            if ("VersionMismatch".equals(faultCodeClass)) {
                buffer.append(" The server does not understand this version ").append("of the SOAP protocol (version=").append("http://schemas.xmlsoap.org/soap/envelope/").append(')');
            } else if ("MustUnderstand".equals(faultCodeClass)) {
                buffer.append(" The server cannot interpret the SOAP headers.");
            } else if ("Client".equals(faultCodeClass)) {
                buffer.append(" The client dit not manage to send a valid").append(" request.");
            } else if ("Server".equals(faultCodeClass)) {
                buffer.append(" The server could not process the request.");
            } else {
                buffer.append(" The faultcode class is not recognised.");
            }
            String faultActor = fault.getFaultActor();
            if (faultActor != null) {
                buffer.append(" Faultactor was '").append(faultActor).append("'.");
            }
            String faultString = fault.getFaultString();
            buffer.append(NL).append(faultString).append(NL);
            Detail faultDetail = fault.getDetail();
            Iterator detailEntries = faultDetail.getDetailEntries();
            int entryNr = 0;
            while (detailEntries.hasNext()) {
                String detailString;
                ++entryNr;
                DetailEntry detailEntry = (DetailEntry)detailEntries.next();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    DOMSource source = new DOMSource((Node)detailEntry);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(stringWriter);
                    transformer.transform(source, result);
                    detailString = stringWriter.toString();
                }
                catch (TransformerException ex_t) {
                    detailString = "Could not serialise detail entry " + entryNr + ": " + ex_t;
                }
                buffer.append("Detail entry ").append(entryNr).append(':').append(NL).append(detailString).append(NL);
            }
            throw this.newSevereRuntimeException(buffer.toString());
        }
        Element responseElement = null;
        int nrElements = 0;
        for (Node currentNode = responseBody.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getNodeType() != 1) continue;
            if (responseElement == null) {
                responseElement = (Element)currentNode;
            }
            ++nrElements;
        }
        if (nrElements == 0) {
            throw this.newSevereRuntimeException("SOAP body did not contain any response elements.");
        }
        if (nrElements > 1) {
            throw this.newSevereRuntimeException("SOAP body contained more than one response element.");
        }
        s_logger.finer("Found 1 response element in SOAP body");
        s_logger.exiting(C_NAME, "doSoapRequest");
        return responseElement;
    }

    private String getCalculateTaxEndPointAddress() {
        if (s_calculateTaxEndPointAddress == null) {
            s_calculateTaxEndPointAddress = this.getProperty(PROP_CALCULATE_TAX_END_POINT_ADDR);
        }
        return s_calculateTaxEndPointAddress;
    }

    private String getLookupTaxAreasEndPointAddress() {
        if (s_lookupTaxAreasEndPointAddress == null) {
            s_lookupTaxAreasEndPointAddress = this.getProperty(PROP_LOOKUP_TAX_AREAS_END_POINT_ADDR);
        }
        return s_lookupTaxAreasEndPointAddress;
    }

    private String getLookupVersionRequestEndPointAddress() {
        if (s_lookupVersionRequestEndPointAddress == null) {
            s_lookupVersionRequestEndPointAddress = this.getProperty(PROP_VERSION_REQUEST_END_POINT_ADDR);
        }
        return s_lookupVersionRequestEndPointAddress;
    }

    private String getUserName() {
        if (s_userName == null) {
            s_userName = this.getProperty(PROP_USER_NAME);
        }
        return s_userName;
    }

    private String getPassword() {
        if (s_password == null) {
            s_password = this.getProperty(PROP_PASSWORD);
        }
        return s_password;
    }

    private String getProperty(String p_key) {
        return this.getProperty(TAX_PROVIDER_ID, p_key);
    }

    private JAXBContext getBindContext() throws JAXBException {
        if (s_bindContext == null) {
            s_bindContext = JAXBContext.newInstance((String)"com.ssa.ta.vertex1.ws.bindings");
        }
        return s_bindContext;
    }

    ObjectFactory getObjectFactory() {
        return OBJECT_FACTORY;
    }
}

