/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1;

import com.ssa.ta.taxprovider1.BuyerDestination;
import com.ssa.ta.taxprovider1.CustomerDestination;
import com.ssa.ta.taxprovider1.Geocode;
import com.ssa.ta.taxprovider1.GeocodeArray;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.QuotationSaleCustomerDestination;
import com.ssa.ta.taxprovider1.QuotationSaleSellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.QuotationSaleSellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.SellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.SellerDestination;
import com.ssa.ta.taxprovider1.SellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.TaxProviderException;
import com.ssa.ta.taxprovider1.VendorAdministrativeOrigin;
import com.ssa.ta.taxprovider1.VendorPhysicalOrigin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    public static final String NL = System.getProperty("line.separator");
    public static final String BRIDGE_ERROR_PREFIX = "TPB# ";
    private static final String LOG_SUBSYSTEM_NAME = "com.ssa.ta.taxprovider";
    private static final String C_NAME = Util.class.getName();
    private static final String SYSPROP_INSTALL_DIR = "com.ssa.ta.taxprovider.install.dir";
    private static final String SUBDIR_CONFIG = "etc";
    private static final Util INSTANCE = new Util();
    private static final Hashtable s_propertiesSet = new Hashtable();
    private static Logger s_logger = Logger.getLogger("com.ssa.ta.taxprovider");

    protected Util() {
    }

    static Util getInstance() {
        return INSTANCE;
    }

    private final Properties getProperties(String p_name) {
        String M_NAME = "getProperties";
        s_logger.entering(C_NAME, "getProperties", p_name);
        Properties properties = (Properties)s_propertiesSet.get(p_name);
        if (properties != null) {
            return properties;
        }
        String resourceName = "/" + this.getPropertyFileName(p_name);
        InputStream input = Util.class.getResourceAsStream(resourceName);
        if (input == null) {
            return null;
        }
        properties = new Properties();
        try {
            properties.load(input);
        }
        catch (IOException ex_io) {
            throw this.newSevereRuntimeException("Could not load properties resource " + resourceName, ex_io);
        }
        s_propertiesSet.put(p_name, properties);
        s_logger.finer("Loaded properties resource " + resourceName);
        s_logger.exiting(C_NAME, "getProperties");
        return properties;
    }

    private final String getPropertyFileName(String p_fileKey) {
        return p_fileKey + ".properties";
    }

    private final String getExpectedPropertyFilePath(String p_fileKey) {
        File propertyFile = new File(this.getConfigurationDirectory(), this.getPropertyFileName(p_fileKey));
        return propertyFile.getPath();
    }

    public final String getProperty(String p_fileKey, String p_propertyKey) {
        String M_NAME = "getProperty";
        s_logger.entering(C_NAME, "getProperty", new Object[]{p_fileKey, p_propertyKey});
        Properties properties = this.getProperties(p_fileKey);
        if (properties == null) {
            throw this.newSevereRuntimeException("Property file " + this.getExpectedPropertyFilePath(p_fileKey) + " not found");
        }
        String value = properties.getProperty(p_propertyKey);
        if (value == null) {
            throw this.newSevereRuntimeException("Property " + p_propertyKey + " in file " + this.getExpectedPropertyFilePath(p_fileKey) + " not found");
        }
        s_logger.config("Property " + p_fileKey + '[' + p_propertyKey + "]=" + value);
        s_logger.exiting(C_NAME, "getProperty", value);
        return value;
    }

    public final Logger getLogger() {
        return s_logger;
    }

    public final RuntimeException newSevereRuntimeException(String p_message) {
        return this.newSevereRuntimeException(p_message, null);
    }

    public final RuntimeException newSevereRuntimeException(String p_message, Throwable p_cause) {
        TaxProviderException exception = p_cause == null ? new TaxProviderException(BRIDGE_ERROR_PREFIX + p_message) : new TaxProviderException(BRIDGE_ERROR_PREFIX + p_message, p_cause);
        s_logger.log(Level.SEVERE, p_message, exception);
        return exception;
    }

    public final void fineThrowable(String p_message, Throwable p_cause) {
        s_logger.log(Level.FINE, p_message, p_cause);
    }

    final String geocodeArrayToString(GeocodeArray p_geocodeArray) {
        StringBuffer buffer = new StringBuffer("{");
        int arraySize = p_geocodeArray.sizeGeocode();
        for (int i = 0; i < arraySize; ++i) {
            Geocode geocode = p_geocodeArray.getGeocodeAt(i);
            this.appendGeocode(buffer, geocode).append(',');
        }
        int bufferSize = buffer.length();
        buffer.setLength(bufferSize - 1);
        buffer.append("}");
        return buffer.toString();
    }

    private final StringBuffer appendGeocode(StringBuffer p_buffer, Geocode p_geocode) {
        p_buffer.append('{');
        if (p_geocode.hasLocation()) {
            Location location = p_geocode.getLocation();
            this.appendLocation(p_buffer, location).append(',');
        } else {
            p_buffer.append("(no location),");
        }
        int arraySize = p_geocode.sizeJurisdiction();
        p_buffer.append('{');
        if (arraySize == 0) {
            p_buffer.append("no jurisdictions");
        }
        for (int i = 0; i < arraySize; ++i) {
            Jurisdiction jurisdiction = p_geocode.getJurisdictionAt(i);
            this.appendJurisdiction(p_buffer, jurisdiction).append(',');
        }
        int bufferSize = p_buffer.length();
        p_buffer.setLength(bufferSize - 1);
        p_buffer.append('}');
        p_buffer.append('}');
        return p_buffer;
    }

    private final StringBuffer appendJurisdiction(StringBuffer p_buffer, Jurisdiction p_jurisdiction) {
        int bufferLength;
        p_buffer.append('(');
        if (p_jurisdiction.hasJurisdictionName()) {
            p_buffer.append("name(").append(p_jurisdiction.getJurisdictionName()).append("),");
        }
        if (p_jurisdiction.hasJurisdictionLevel()) {
            p_buffer.append("level(").append(p_jurisdiction.getJurisdictionLevel()).append("),");
        }
        if (p_buffer.charAt((bufferLength = p_buffer.length()) - 1) == ',') {
            p_buffer.setLength(bufferLength - 1);
        }
        p_buffer.append('}');
        return p_buffer;
    }

    final String sellerPhysicalOriginToString(SellerPhysicalOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noSellerPhysicalOrigin>";
    }

    final String vendorPhysicalOriginToString(VendorPhysicalOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noVendorPhysicalOrigin>";
    }

    final String quotationSaleSellerPhysicalOriginToString(QuotationSaleSellerPhysicalOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noQuotationSaleSellerPhysicalOrigin>";
    }

    final String sellerAdministrativeOriginToString(SellerAdministrativeOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noSellerAdministrativeOrigin>";
    }

    final String vendorAdministrativeOriginToString(VendorAdministrativeOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noVendorAdministrativeOrigin>";
    }

    final String quotationSaleSellerAdministrativeOriginToString(QuotationSaleSellerAdministrativeOrigin p_origin) {
        if (p_origin.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_origin.getLocation());
            return buffer.toString();
        }
        return "<noQuotationSaleSellerAdministrativeOrigin>";
    }

    final String customerDestinationToString(CustomerDestination p_destination) {
        if (p_destination.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_destination.getLocation());
            return buffer.toString();
        }
        return "<noCustomerDestination>";
    }

    final String buyerDestinationToString(BuyerDestination p_destination) {
        if (p_destination.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_destination.getLocation());
            return buffer.toString();
        }
        return "<noBuyerDestination>";
    }

    final String sellerDestinationToString(SellerDestination p_destination) {
        if (p_destination.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_destination.getLocation());
            return buffer.toString();
        }
        return "<noBuyerDestination>";
    }

    final String quotationSaleCustomerDestinationToString(QuotationSaleCustomerDestination p_destination) {
        if (p_destination.hasLocation()) {
            StringBuffer buffer = new StringBuffer();
            this.appendLocation(buffer, p_destination.getLocation());
            return buffer.toString();
        }
        return "<noQuotationSaleCustomerDestination>";
    }

    final String inputTotalTaxToString(double p_inputTotalTax) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(p_inputTotalTax);
        return buffer.toString();
    }

    final String taxArayToString(TaxArray p_taxArray) {
        StringBuffer buffer = new StringBuffer("{");
        int arraySize = p_taxArray.sizeTax();
        for (int i = 0; i < arraySize; ++i) {
            Tax tax = p_taxArray.getTaxAt(i);
            this.appendTax(buffer, tax).append(',');
        }
        int bufferSize = buffer.length();
        buffer.setLength(bufferSize - 1);
        buffer.append('}');
        return buffer.toString();
    }

    private final StringBuffer appendTax(StringBuffer p_buffer, Tax p_tax) {
        int bufferLength;
        p_buffer.append('{');
        if (p_tax.hasCalculatedTax()) {
            p_buffer.append("calculatedTax(").append(p_tax.getCalculatedTax()).append("),");
        }
        if (p_tax.hasEffectiveRate()) {
            p_buffer.append("effectiveRate(").append(p_tax.getEffectiveRate()).append("),");
        }
        if (p_tax.hasJurisdiction()) {
            this.appendJurisdiction(p_buffer, p_tax.getJurisdiction()).append("),");
        }
        if (p_tax.hasTaxResult()) {
            p_buffer.append("taxResult(").append(p_tax.getTaxResult()).append("),");
        }
        if (p_buffer.charAt((bufferLength = p_buffer.length()) - 1) == ',') {
            p_buffer.setLength(bufferLength - 1);
        }
        p_buffer.append('}');
        return p_buffer;
    }

    private final StringBuffer appendLocation(StringBuffer p_buffer, Location p_location) {
        int bufferLength;
        p_buffer.append('{');
        if (p_location.hasGeocode()) {
            p_buffer.append("geocode(").append(p_location.getGeocode()).append("),");
        }
        if (p_location.hasStreet()) {
            p_buffer.append("street(").append(p_location.getStreet()).append("),");
        }
        if (p_location.hasCity()) {
            p_buffer.append("city(").append(p_location.getCity()).append("),");
        }
        if (p_location.hasZipCode()) {
            p_buffer.append("zipCode(").append(p_location.getZipCode()).append("),");
        }
        if (p_location.hasCounty()) {
            p_buffer.append("county(").append(p_location.getCounty()).append("),");
        }
        if (p_location.hasState()) {
            p_buffer.append("state(").append(p_location.getState()).append("),");
        }
        if (p_location.hasCountry()) {
            p_buffer.append("country(").append(p_location.getCountry()).append("),");
        }
        if (p_buffer.charAt((bufferLength = p_buffer.length()) - 1) == ',') {
            p_buffer.setLength(bufferLength - 1);
        }
        p_buffer.append('}');
        return p_buffer;
    }

    private final File getConfigurationDirectory() {
        File configDir = new File(this.getInstallationDirectory(), SUBDIR_CONFIG);
        return configDir;
    }

    private final File getInstallationDirectory() {
        File installDir;
        String installDirString = System.getProperty(SYSPROP_INSTALL_DIR);
        File rawInstallDir = new File(installDirString);
        try {
            installDir = rawInstallDir.getCanonicalFile();
        }
        catch (IOException ex_io) {
            throw this.newSevereRuntimeException("Could not determine installation directory.", ex_io);
        }
        return installDir;
    }
}

