/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1;

import com.eibus.util.DoubleHolder;
import com.eibus.util.IntHolder;
import com.eibus.util.StringHolder;
import com.ssa.ta.taxprovider1.BuyerDestination;
import com.ssa.ta.taxprovider1.Currency;
import com.ssa.ta.taxprovider1.CustomerDestination;
import com.ssa.ta.taxprovider1.DatabaseVersions;
import com.ssa.ta.taxprovider1.GeocodeArray;
import com.ssa.ta.taxprovider1.ITaxProvider;
import com.ssa.ta.taxprovider1.JavaVirtualMachineVersion;
import com.ssa.ta.taxprovider1.LibraryVersions;
import com.ssa.ta.taxprovider1.OperatingSystemVersion;
import com.ssa.ta.taxprovider1.OriginalCurrency;
import com.ssa.ta.taxprovider1.ProductVersions;
import com.ssa.ta.taxprovider1.QuotationSaleCustomerDestination;
import com.ssa.ta.taxprovider1.QuotationSaleSellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.QuotationSaleSellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.SellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.SellerDestination;
import com.ssa.ta.taxprovider1.SellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.TaxProviderException;
import com.ssa.ta.taxprovider1.VendorAdministrativeOrigin;
import com.ssa.ta.taxprovider1.VendorPhysicalOrigin;
import com.ssa.ta.taxprovider1.VersionResponse;
import com.ssa.taimpl.taxprovider1.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Manager {
    private static final Util UTIL = Util.getInstance();
    private static final Logger s_logger = UTIL.getLogger();
    private static final String C_NAME = Manager.class.getName();
    private static final String BRIDGE_ID = "bridge";
    private static final String PROP_PROVIDER_CLASS = "tax.provider.implementation";
    private static ITaxProvider s_taxProvider = null;

    private Manager() {
    }

    public static void getGeocode(GeocodeArray p_geocodes, String p_city, String p_state, String p_zipCode, String p_country) {
        String M_NAME = "getGeocode";
        s_logger.entering(C_NAME, "getGeocode", new Object[]{p_city, p_state, p_zipCode, p_country});
        try {
            Manager.getTaxProvider().getGeocode(p_geocodes, p_city, p_state, p_zipCode, p_country);
            s_logger.exiting(C_NAME, "getGeocode", UTIL.geocodeArrayToString(p_geocodes));
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    public static void purchaseOrderTPP(StringHolder p_documentNr, StringHolder p_documentDate, Currency p_currency, OriginalCurrency p_originalCurrency, String p_buyerCompany, BuyerDestination p_buyerDestination, boolean p_buyerIsTaxExempt, String p_buyerExemptReasonCode, String p_buyerExemptCertNr, String p_vendorCompany, VendorAdministrativeOrigin p_vendorAdministrativeOrigin, VendorPhysicalOrigin p_vendorPhysicalOrigin, IntHolder p_itemNumber, StringHolder p_itemPurchase, StringHolder p_itemPurchaseClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        String M_NAME = "purchaseOrderTPP";
        try {
            s_logger.entering(C_NAME, "purchaseOrderTPP", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_buyerCompany, UTIL.buyerDestinationToString(p_buyerDestination), new Boolean(p_buyerIsTaxExempt), p_buyerExemptReasonCode, p_buyerExemptCertNr, p_vendorCompany, UTIL.vendorAdministrativeOriginToString(p_vendorAdministrativeOrigin), UTIL.vendorPhysicalOriginToString(p_vendorPhysicalOrigin), p_itemNumber, p_itemPurchase, p_itemPurchaseClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
            Manager.getTaxProvider().purchaseOrderTPP(p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_buyerCompany, p_buyerDestination, p_buyerIsTaxExempt, p_buyerExemptReasonCode, p_buyerExemptCertNr, p_vendorCompany, p_vendorAdministrativeOrigin, p_vendorPhysicalOrigin, p_itemNumber, p_itemPurchase, p_itemPurchaseClass, p_itemQuantity, p_itemExtendedPrice, p_taxArray, p_itemTotalTax);
            s_logger.exiting(C_NAME, "purchaseOrderTPP", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_buyerCompany, UTIL.buyerDestinationToString(p_buyerDestination), new Boolean(p_buyerIsTaxExempt), p_buyerExemptReasonCode, p_buyerExemptCertNr, p_vendorCompany, UTIL.vendorAdministrativeOriginToString(p_vendorAdministrativeOrigin), UTIL.vendorPhysicalOriginToString(p_vendorPhysicalOrigin), p_itemNumber, p_itemPurchase, p_itemPurchaseClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    public static void taxOnlyAdjustmentSale(StringHolder p_documentNr, StringHolder p_documentDate, Currency p_currency, OriginalCurrency p_originalCurrency, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, SellerDestination p_sellerDestination, double p_inputTotalTax, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        String M_NAME = "taxOnlyAdjustmentSale";
        try {
            s_logger.entering(C_NAME, "taxOnlyAdjustmentSale", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.sellerPhysicalOriginToString(p_sellerPhysicalOrigin), UTIL.sellerAdministrativeOriginToString(p_sellerAdministrativeOrigin), UTIL.sellerDestinationToString(p_sellerDestination), UTIL.inputTotalTaxToString(p_inputTotalTax), UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
            Manager.getTaxProvider().taxOnlyAdjustmentSale(p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, p_sellerPhysicalOrigin, p_sellerAdministrativeOrigin, p_sellerDestination, p_inputTotalTax, p_taxArray, p_itemTotalTax);
            s_logger.exiting(C_NAME, "taxOnlyAdjustmentSale", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.sellerPhysicalOriginToString(p_sellerPhysicalOrigin), UTIL.sellerAdministrativeOriginToString(p_sellerAdministrativeOrigin), UTIL.sellerDestinationToString(p_sellerDestination), UTIL.inputTotalTaxToString(p_inputTotalTax), UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    public static void calculateTaxForInvoicing40(StringHolder p_documentNr, StringHolder p_documentDate, Currency p_currency, OriginalCurrency p_originalCurrency, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, String p_customerCode, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, StringHolder p_customerExemptCertNr, String p_customerCompany, CustomerDestination p_customerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) {
        String M_NAME = "calculateTaxForInvoicing40";
        try {
            s_logger.entering(C_NAME, "calculateTaxForInvoicing40", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.sellerPhysicalOriginToString(p_sellerPhysicalOrigin), UTIL.sellerAdministrativeOriginToString(p_sellerAdministrativeOrigin), p_customerCode, p_customerClassCode, new Boolean(p_customerIsTaxExempt), p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, UTIL.customerDestinationToString(p_customerDestination), p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
            Manager.getTaxProvider().calculateTaxForInvoicing40(p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, p_sellerPhysicalOrigin, p_sellerAdministrativeOrigin, p_customerCode, p_customerClassCode, p_customerIsTaxExempt, p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, p_customerDestination, p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, p_taxArray, p_itemTotalTax);
            s_logger.exiting(C_NAME, "calculateTaxForInvoicing40", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.sellerPhysicalOriginToString(p_sellerPhysicalOrigin), UTIL.sellerAdministrativeOriginToString(p_sellerAdministrativeOrigin), p_customerCode, p_customerClassCode, new Boolean(p_customerIsTaxExempt), p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, UTIL.customerDestinationToString(p_customerDestination), p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    public static void quoteTaxForSale40(StringHolder p_documentNr, StringHolder p_documentDate, Currency p_currency, OriginalCurrency p_originalCurrency, String p_sellerCompany, QuotationSaleSellerPhysicalOrigin p_quotationSaleSellerPhysicalOrigin, QuotationSaleSellerAdministrativeOrigin p_quotationSaleSellerAdministrativeOrigin, String p_customerCode, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, String p_customerExemptCertNr, String p_customerCompany, QuotationSaleCustomerDestination p_quotationSaleCustomerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) {
        String M_NAME = "quoteTaxForSale40";
        try {
            s_logger.entering(C_NAME, "quoteTaxForSale40", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.quotationSaleSellerPhysicalOriginToString(p_quotationSaleSellerPhysicalOrigin), UTIL.quotationSaleSellerAdministrativeOriginToString(p_quotationSaleSellerAdministrativeOrigin), p_customerCode, p_customerClassCode, new Boolean(p_customerIsTaxExempt), p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, UTIL.quotationSaleCustomerDestinationToString(p_quotationSaleCustomerDestination), p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
            Manager.getTaxProvider().quoteTaxForSale40(p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, p_quotationSaleSellerPhysicalOrigin, p_quotationSaleSellerAdministrativeOrigin, p_customerCode, p_customerClassCode, p_customerIsTaxExempt, p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, p_quotationSaleCustomerDestination, p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, p_taxArray, p_itemTotalTax);
            s_logger.exiting(C_NAME, "quoteTaxForSale40", new Object[]{p_documentNr, p_documentDate, p_currency, p_originalCurrency, p_sellerCompany, UTIL.quotationSaleSellerPhysicalOriginToString(p_quotationSaleSellerPhysicalOrigin), UTIL.quotationSaleSellerAdministrativeOriginToString(p_quotationSaleSellerAdministrativeOrigin), p_customerCode, p_customerClassCode, new Boolean(p_customerIsTaxExempt), p_customerExemptReasonCode, p_customerExemptCertNr, p_customerCompany, UTIL.quotationSaleCustomerDestinationToString(p_quotationSaleCustomerDestination), p_itemNumber, p_itemProduct, p_itemProductClass, p_itemQuantity, p_itemExtendedPrice, UTIL.taxArayToString(p_taxArray), p_itemTotalTax});
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    public static VersionResponse VersionResponse() {
        String M_NAME = "VersionResponse";
        try {
            VersionResponse p_VersionResponse = new VersionResponse();
            p_VersionResponse = Manager.getTaxProvider().VersionResponse();
            if (p_VersionResponse != null) {
                ProductVersions p_ProductVersions = p_VersionResponse.getProductVersions();
                LibraryVersions p_LibraryVersions = p_VersionResponse.getLibraryVersions();
                DatabaseVersions p_DatabaseVersions = p_VersionResponse.getDatabaseVersions();
                String p_configurationVersion = p_VersionResponse.getConfigurationVersion();
                String p_messageResourceVersion = p_VersionResponse.getMessageResourceVersion();
                OperatingSystemVersion p_OperatingSystemVersion = p_VersionResponse.getOperatingSystemVersion();
                JavaVirtualMachineVersion p_JVMVersion = p_VersionResponse.getJavaVirtualMachineVersion();
                s_logger.exiting(C_NAME, "VersionResponse", new Object[]{p_ProductVersions, p_LibraryVersions, p_DatabaseVersions, p_configurationVersion, p_messageResourceVersion, p_OperatingSystemVersion, p_JVMVersion});
            }
            return p_VersionResponse;
        }
        catch (TaxProviderException ex_tp) {
            throw ex_tp;
        }
        catch (ThreadDeath td) {
            s_logger.log(Level.SEVERE, "Unexpected thread death: ", td);
            throw td;
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Unexpected exception: ", t);
            throw new RuntimeException(t);
        }
    }

    private static ITaxProvider getTaxProvider() {
        if (s_taxProvider == null) {
            Object taxProviderCandidate;
            Class<?> taxProviderClass;
            String taxProviderClassName = UTIL.getProperty(BRIDGE_ID, PROP_PROVIDER_CLASS);
            try {
                taxProviderClass = Class.forName(taxProviderClassName);
            }
            catch (ClassNotFoundException ex_cnf) {
                throw UTIL.newSevereRuntimeException("Could not find tax provider implementation.", ex_cnf);
            }
            catch (LinkageError er_l) {
                throw UTIL.newSevereRuntimeException("Could not load tax provider implementation.", er_l);
            }
            try {
                taxProviderCandidate = taxProviderClass.newInstance();
            }
            catch (InstantiationException ex_i) {
                throw UTIL.newSevereRuntimeException("Could not instantiate tax provider implementation.", ex_i);
            }
            catch (IllegalAccessException ex_ia) {
                throw UTIL.newSevereRuntimeException("Could not instantiate tax provider implementation.", ex_ia);
            }
            s_taxProvider = (ITaxProvider)taxProviderCandidate;
            s_logger.info("Initialised tax provider.");
        }
        return s_taxProvider;
    }
}

