/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.AddressTerm;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.DateTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.StringTerm;
import javax.mail.search.SubjectTerm;

class SearchSequence {
    private static String[] monthTable = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static Calendar cal = new GregorianCalendar();

    SearchSequence() {
    }

    static Argument generateSequence(SearchTerm searchTerm, String string) throws SearchException, IOException {
        if (searchTerm instanceof AndTerm) {
            return SearchSequence.and((AndTerm)searchTerm, string);
        }
        if (searchTerm instanceof OrTerm) {
            return SearchSequence.or((OrTerm)searchTerm, string);
        }
        if (searchTerm instanceof NotTerm) {
            return SearchSequence.not((NotTerm)searchTerm, string);
        }
        if (searchTerm instanceof HeaderTerm) {
            return SearchSequence.header((HeaderTerm)searchTerm, string);
        }
        if (searchTerm instanceof FlagTerm) {
            return SearchSequence.flag((FlagTerm)searchTerm);
        }
        if (searchTerm instanceof FromTerm) {
            FromTerm fromTerm = (FromTerm)searchTerm;
            return SearchSequence.from(fromTerm.getAddress().toString(), string);
        }
        if (searchTerm instanceof FromStringTerm) {
            FromStringTerm fromStringTerm = (FromStringTerm)searchTerm;
            return SearchSequence.from(fromStringTerm.getPattern(), string);
        }
        if (searchTerm instanceof RecipientTerm) {
            RecipientTerm recipientTerm = (RecipientTerm)searchTerm;
            return SearchSequence.recipient(recipientTerm.getRecipientType(), recipientTerm.getAddress().toString(), string);
        }
        if (searchTerm instanceof RecipientStringTerm) {
            RecipientStringTerm recipientStringTerm = (RecipientStringTerm)searchTerm;
            return SearchSequence.recipient(recipientStringTerm.getRecipientType(), recipientStringTerm.getPattern(), string);
        }
        if (searchTerm instanceof SubjectTerm) {
            return SearchSequence.subject((SubjectTerm)searchTerm, string);
        }
        if (searchTerm instanceof BodyTerm) {
            return SearchSequence.body((BodyTerm)searchTerm, string);
        }
        if (searchTerm instanceof SizeTerm) {
            return SearchSequence.size((SizeTerm)searchTerm);
        }
        if (searchTerm instanceof SentDateTerm) {
            return SearchSequence.sentdate((SentDateTerm)searchTerm);
        }
        if (searchTerm instanceof ReceivedDateTerm) {
            return SearchSequence.receiveddate((ReceivedDateTerm)searchTerm);
        }
        if (searchTerm instanceof MessageIDTerm) {
            return SearchSequence.messageid((MessageIDTerm)searchTerm, string);
        }
        throw new SearchException("Search too complex");
    }

    static boolean isAscii(SearchTerm searchTerm) {
        if (searchTerm instanceof AndTerm || searchTerm instanceof OrTerm) {
            SearchTerm[] searchTermArray = searchTerm instanceof AndTerm ? ((AndTerm)searchTerm).getTerms() : ((OrTerm)searchTerm).getTerms();
            for (int i = 0; i < searchTermArray.length; ++i) {
                if (SearchSequence.isAscii(searchTermArray[i])) continue;
                return false;
            }
        } else {
            if (searchTerm instanceof NotTerm) {
                return SearchSequence.isAscii(((NotTerm)searchTerm).getTerm());
            }
            if (searchTerm instanceof StringTerm) {
                return SearchSequence.isAscii(((StringTerm)searchTerm).getPattern());
            }
            if (searchTerm instanceof AddressTerm) {
                return SearchSequence.isAscii(((AddressTerm)searchTerm).getAddress().toString());
            }
        }
        return true;
    }

    private static boolean isAscii(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static Argument and(AndTerm andTerm, String string) throws SearchException, IOException {
        SearchTerm[] searchTermArray = andTerm.getTerms();
        Argument argument = SearchSequence.generateSequence(searchTermArray[0], string);
        for (int i = 1; i < searchTermArray.length; ++i) {
            argument.append(SearchSequence.generateSequence(searchTermArray[i], string));
        }
        return argument;
    }

    private static Argument or(OrTerm orTerm, String string) throws SearchException, IOException {
        Object object;
        SearchTerm[] searchTermArray = orTerm.getTerms();
        if (searchTermArray.length > 2) {
            object = searchTermArray[0];
            for (int i = 1; i < searchTermArray.length; ++i) {
                object = new OrTerm((SearchTerm)object, searchTermArray[i]);
            }
            orTerm = (OrTerm)object;
            searchTermArray = orTerm.getTerms();
        }
        object = new Argument();
        ((Argument)object).writeAtom("OR");
        if (searchTermArray[0] instanceof AndTerm || searchTermArray[0] instanceof FlagTerm) {
            ((Argument)object).writeArgument(SearchSequence.generateSequence(searchTermArray[0], string));
        } else {
            ((Argument)object).append(SearchSequence.generateSequence(searchTermArray[0], string));
        }
        if (searchTermArray[1] instanceof AndTerm || searchTermArray[1] instanceof FlagTerm) {
            ((Argument)object).writeArgument(SearchSequence.generateSequence(searchTermArray[1], string));
        } else {
            ((Argument)object).append(SearchSequence.generateSequence(searchTermArray[1], string));
        }
        return object;
    }

    private static Argument not(NotTerm notTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("NOT");
        SearchTerm searchTerm = notTerm.getTerm();
        if (searchTerm instanceof AndTerm || searchTerm instanceof FlagTerm) {
            argument.writeArgument(SearchSequence.generateSequence(searchTerm, string));
        } else {
            argument.append(SearchSequence.generateSequence(searchTerm, string));
        }
        return argument;
    }

    private static Argument header(HeaderTerm headerTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("HEADER");
        argument.writeString(headerTerm.getHeaderName());
        argument.writeString(headerTerm.getPattern(), string);
        return argument;
    }

    private static Argument messageid(MessageIDTerm messageIDTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("HEADER");
        argument.writeString("Message-ID");
        argument.writeString(messageIDTerm.getPattern(), string);
        return argument;
    }

    private static Argument flag(FlagTerm flagTerm) throws SearchException {
        int n;
        boolean bl = flagTerm.getTestSet();
        Argument argument = new Argument();
        Flags flags = flagTerm.getFlags();
        Flags.Flag[] flagArray = flags.getSystemFlags();
        String[] stringArray = flags.getUserFlags();
        if (flagArray.length == 0 && stringArray.length == 0) {
            throw new SearchException("Invalid FlagTerm");
        }
        for (n = 0; n < flagArray.length; ++n) {
            if (flagArray[n] == Flags.Flag.DELETED) {
                argument.writeAtom(bl ? "DELETED" : "UNDELETED");
                continue;
            }
            if (flagArray[n] == Flags.Flag.ANSWERED) {
                argument.writeAtom(bl ? "ANSWERED" : "UNANSWERED");
                continue;
            }
            if (flagArray[n] == Flags.Flag.DRAFT) {
                argument.writeAtom(bl ? "DRAFT" : "UNDRAFT");
                continue;
            }
            if (flagArray[n] == Flags.Flag.FLAGGED) {
                argument.writeAtom(bl ? "FLAGGED" : "UNFLAGGED");
                continue;
            }
            if (flagArray[n] == Flags.Flag.RECENT) {
                argument.writeAtom(bl ? "RECENT" : "OLD");
                continue;
            }
            if (flagArray[n] != Flags.Flag.SEEN) continue;
            argument.writeAtom(bl ? "SEEN" : "UNSEEN");
        }
        for (n = 0; n < stringArray.length; ++n) {
            argument.writeAtom(bl ? "KEYWORD" : "UNKEYWORD");
            argument.writeAtom(stringArray[n]);
        }
        return argument;
    }

    private static Argument from(String string, String string2) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("FROM");
        argument.writeString(string, string2);
        return argument;
    }

    private static Argument recipient(Message.RecipientType recipientType, String string, String string2) throws SearchException, IOException {
        Argument argument = new Argument();
        if (recipientType == Message.RecipientType.TO) {
            argument.writeAtom("TO");
        } else if (recipientType == Message.RecipientType.CC) {
            argument.writeAtom("CC");
        } else if (recipientType == Message.RecipientType.BCC) {
            argument.writeAtom("BCC");
        } else {
            throw new SearchException("Illegal Recipient type");
        }
        argument.writeString(string, string2);
        return argument;
    }

    private static Argument subject(SubjectTerm subjectTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("SUBJECT");
        argument.writeString(subjectTerm.getPattern(), string);
        return argument;
    }

    private static Argument body(BodyTerm bodyTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("BODY");
        argument.writeString(bodyTerm.getPattern(), string);
        return argument;
    }

    private static Argument size(SizeTerm sizeTerm) throws SearchException {
        Argument argument = new Argument();
        switch (sizeTerm.getComparison()) {
            case 5: {
                argument.writeAtom("LARGER");
                break;
            }
            case 2: {
                argument.writeAtom("SMALLER");
                break;
            }
            default: {
                throw new SearchException("Cannot handle Comparison");
            }
        }
        argument.writeNumber(sizeTerm.getNumber());
        return argument;
    }

    private static String toIMAPDate(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        cal.setTime(date);
        stringBuffer.append(cal.get(5)).append("-");
        stringBuffer.append(monthTable[cal.get(2)]).append('-');
        stringBuffer.append(cal.get(1));
        return stringBuffer.toString();
    }

    private static Argument sentdate(DateTerm dateTerm) throws SearchException {
        Argument argument = new Argument();
        String string = SearchSequence.toIMAPDate(dateTerm.getDate());
        switch (dateTerm.getComparison()) {
            case 5: {
                argument.writeAtom("SENTSINCE " + string);
                break;
            }
            case 3: {
                argument.writeAtom("SENTON " + string);
                break;
            }
            case 2: {
                argument.writeAtom("SENTBEFORE " + string);
                break;
            }
            case 6: {
                argument.writeAtom("OR SENTSINCE " + string + " SENTON " + string);
                break;
            }
            case 1: {
                argument.writeAtom("OR SENTBEFORE " + string + " SENTON " + string);
                break;
            }
            case 4: {
                argument.writeAtom("NOT SENTON " + string);
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return argument;
    }

    private static Argument receiveddate(DateTerm dateTerm) throws SearchException {
        Argument argument = new Argument();
        String string = SearchSequence.toIMAPDate(dateTerm.getDate());
        switch (dateTerm.getComparison()) {
            case 5: {
                argument.writeAtom("SINCE " + string);
                break;
            }
            case 3: {
                argument.writeAtom("ON " + string);
                break;
            }
            case 2: {
                argument.writeAtom("BEFORE " + string);
                break;
            }
            case 6: {
                argument.writeAtom("OR SINCE " + string + " ON " + string);
                break;
            }
            case 1: {
                argument.writeAtom("OR BEFORE " + string + " ON " + string);
                break;
            }
            case 4: {
                argument.writeAtom("NOT ON " + string);
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return argument;
    }
}

