/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import com.sun.xml.rpc.client.http.RfcDateParser;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

public class HttpCookie {
    private Date expirationDate = null;
    private String nameAndValue;
    private String path;
    private String domain;
    private boolean isSecure = false;

    public HttpCookie(String cookieString) {
        this.parseCookieString(cookieString);
    }

    public HttpCookie(Date expirationDate, String nameAndValue, String path, String domain, boolean isSecure) {
        this.expirationDate = expirationDate;
        this.nameAndValue = nameAndValue;
        this.path = path;
        this.domain = this.stripPort(domain);
        this.isSecure = isSecure;
    }

    public HttpCookie(URL url, String cookieString) {
        this.parseCookieString(cookieString);
        this.applyDefaults(url);
    }

    private void applyDefaults(URL url) {
        if (this.domain == null) {
            this.domain = url.getHost();
        }
        if (this.path == null) {
            this.path = url.getFile();
            int last = this.path.lastIndexOf("/");
            if (last > -1) {
                this.path = this.path.substring(0, last);
            }
        }
    }

    private String stripPort(String domainName) {
        int index = domainName.indexOf(58);
        if (index == -1) {
            return domainName;
        }
        return domainName.substring(0, index);
    }

    private void parseCookieString(String cookieString) {
        StringTokenizer tokens = new StringTokenizer(cookieString, ";");
        if (!tokens.hasMoreTokens()) {
            // empty if block
        }
        this.nameAndValue = tokens.nextToken().trim();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("secure")) {
                this.isSecure = true;
                continue;
            }
            int equIndex = token.indexOf("=");
            if (equIndex < 0) continue;
            String attr = token.substring(0, equIndex);
            String val = token.substring(equIndex + 1);
            if (attr.equalsIgnoreCase("path")) {
                this.path = val;
                continue;
            }
            if (attr.equalsIgnoreCase("domain")) {
                if (val.indexOf(".") == 0) {
                    this.domain = this.stripPort(val.substring(1));
                    continue;
                }
                this.domain = this.stripPort(val);
                continue;
            }
            if (!attr.equalsIgnoreCase("expires")) continue;
            this.expirationDate = this.parseExpireDate(val);
        }
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        int index = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(0, index);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    boolean hasExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private Date parseExpireDate(String dateString) {
        RfcDateParser parser = new RfcDateParser(dateString);
        Date theDate = parser.getDate();
        return theDate;
    }

    public String toString() {
        String result = this.nameAndValue;
        if (this.expirationDate != null) {
            result = result + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            result = result + "; path=" + this.path;
        }
        if (this.domain != null) {
            result = result + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            result = result + "; secure";
        }
        return result;
    }
}

