/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.vertex1;

import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;

public class GeocodeDirectClient {
    private static final String SYSPROP_BACKEND = "backend";
    private static final String DEFAULT_BACKEND = "http://localhost:8080/vertex-ws/services/LookupTaxAreasDoc";
    private static final String SYSPROP_USER_NAME = "username";
    private static final String DEFAULT_USER_NAME = "ssa";
    private static final String SYSPROP_PASSWORD = "password";
    private static final String DEFAULT_PASSWORD = "ssa123";
    private static final String SYSPROP_CITY = "city";
    private static final String DEFAULT_CITY = "HUNTSVILLE";
    private static final String SYSPROP_STATE = "state";
    private static final String DEFAULT_STATE = "AL";
    private static final String SYSPROP_ZIPCODE = "zipcode";
    private static final String DEFAULT_ZIPCODE = "35801";
    private static final String SERVICE_NAMESPACE = "urn:vertexinc:o-series:tps:4:0";
    private static final String TAG_VERTEX_ENVELOPE = "VertexEnvelope";
    private static final String TAG_LOGIN = "Login";
    private static final String TAG_USER_NAME = "UserName";
    private static final String TAG_PASSWORD = "Password";
    private static final String TAG_TAX_AREA_REQUEST = "TaxAreaRequestType";
    private static final String TAG_TAX_AREA = "TaxAreaType";
    private static final String TAG_CITY = "City";
    private static final String TAG_MAIN_DIVISION = "MainDivision";
    private static final String TAG_POSTAL_CODE = "PostalCode";

    private GeocodeDirectClient() {
    }

    public static void main(String[] p_args) {
        try {
            GeocodeDirectClient.log("Starting direct geocode client...");
            String backend = GeocodeDirectClient.getProperty(SYSPROP_BACKEND, DEFAULT_BACKEND);
            String city = GeocodeDirectClient.getProperty(SYSPROP_CITY, DEFAULT_CITY);
            String state = GeocodeDirectClient.getProperty(SYSPROP_STATE, DEFAULT_STATE);
            String zipCode = GeocodeDirectClient.getProperty(SYSPROP_ZIPCODE, DEFAULT_ZIPCODE);
            String userName = GeocodeDirectClient.getProperty(SYSPROP_USER_NAME, DEFAULT_USER_NAME);
            String password = GeocodeDirectClient.getProperty(SYSPROP_PASSWORD, DEFAULT_PASSWORD);
            GeocodeDirectClient.log("");
            GeocodeDirectClient.log("Connecting to vertex...");
            SOAPMessage soapRequest = null;
            MessageFactory messageFactory = MessageFactory.newInstance();
            soapRequest = messageFactory.createMessage();
            SOAPBody requestBody = soapRequest.getSOAPBody();
            MimeHeaders hd = soapRequest.getMimeHeaders();
            hd.addHeader("SOAPAction", "");
            SOAPEnvelope envelope = soapRequest.getSOAPPart().getEnvelope();
            Name vertexEnvelopeName = envelope.createName(TAG_VERTEX_ENVELOPE, null, SERVICE_NAMESPACE);
            SOAPElement vertexEnvelope = requestBody.addChildElement(vertexEnvelopeName);
            SOAPElement login = vertexEnvelope.addChildElement(TAG_LOGIN);
            login.addChildElement(TAG_USER_NAME).addTextNode(userName);
            login.addChildElement(TAG_PASSWORD).addTextNode(password);
            SOAPElement taxAreaRequest = vertexEnvelope.addChildElement(TAG_TAX_AREA_REQUEST);
            SOAPElement taxArea = taxAreaRequest.addChildElement(TAG_TAX_AREA);
            taxArea.addChildElement(TAG_CITY).addTextNode(city);
            taxArea.addChildElement(TAG_MAIN_DIVISION).addTextNode(state);
            taxArea.addChildElement(TAG_POSTAL_CODE).addTextNode(zipCode);
            GeocodeDirectClient.log("SOAP Request:");
            soapRequest.writeTo((OutputStream)System.out);
            GeocodeDirectClient.log("");
            SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = connectionFactory.createConnection();
            SOAPMessage response = connection.call(soapRequest, (Object)backend);
            GeocodeDirectClient.log("SOAP Response:");
            response.writeTo((OutputStream)System.out);
            GeocodeDirectClient.log("");
        }
        catch (Exception ex) {
            GeocodeDirectClient.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        GeocodeDirectClient.log("Using argument -D" + p_key + '=' + value);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }
}

