/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.taxprovider1;

import com.ssa.ta.taxprovider1.Geocode;
import com.ssa.ta.taxprovider1.GeocodeArray;
import com.ssa.ta.taxprovider1.GetGeocodeRetObj1;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.Manager1;

public class GeocodeClient {
    private static final String SYSPROP_BUS_COMPONENT = "bc";
    private static final String DEFAULT_BUS_COMPONENT = "vertex";
    private static final String SYSPROP_CITY = "city";
    private static final String DEFAULT_CITY = "HUNTSVILLE";
    private static final String SYSPROP_STATE = "state";
    private static final String DEFAULT_STATE = "AL";
    private static final String SYSPROP_ZIPCODE = "zipcode";
    private static final String DEFAULT_ZIPCODE = "35801";
    private static final String SYSPROP_COUNTRY = "country";
    private static final String DEFAULT_COUNTRY = "USA";

    private GeocodeClient() {
    }

    public static void main(String[] p_args) {
        try {
            GeocodeClient.log("Starting geocode client...");
            String busComponent = GeocodeClient.getProperty(SYSPROP_BUS_COMPONENT, DEFAULT_BUS_COMPONENT);
            String city = GeocodeClient.getProperty(SYSPROP_CITY, DEFAULT_CITY);
            String state = GeocodeClient.getProperty(SYSPROP_STATE, DEFAULT_STATE);
            String zipCode = GeocodeClient.getProperty(SYSPROP_ZIPCODE, DEFAULT_ZIPCODE);
            String country = GeocodeClient.getProperty(SYSPROP_COUNTRY, DEFAULT_COUNTRY);
            GeocodeClient.log("");
            GeocodeClient.log("Connecting to bridge...");
            Manager1 taxProvider = new Manager1();
            taxProvider.initialize(busComponent);
            GetGeocodeRetObj1 returnObject = taxProvider.getGeocode(city, state, zipCode, country);
            GeocodeArray geocodes = returnObject.getGeocodeArray();
            int nrGeocodes = geocodes.sizeGeocode();
            for (int i = 0; i < nrGeocodes; ++i) {
                Location location;
                GeocodeClient.log("Found geocode[" + i + "]:");
                Geocode geocode = geocodes.getGeocodeAt(i);
                if (!geocode.hasLocation()) {
                    GeocodeClient.log("\tERROR: Geocode object returned without geocode content");
                }
                if ((location = geocode.getLocation()).hasGeocode()) {
                    GeocodeClient.log("\tGeocode: " + location.getGeocode());
                }
                if (location.hasStreet()) {
                    GeocodeClient.log("\tStreet:  " + location.getStreet());
                }
                if (location.hasCity()) {
                    GeocodeClient.log("\tCity:    " + location.getCity());
                }
                if (location.hasZipCode()) {
                    GeocodeClient.log("\tZipCode: " + location.getZipCode());
                }
                if (location.hasCounty()) {
                    GeocodeClient.log("\tCounty:  " + location.getCounty());
                }
                if (location.hasState()) {
                    GeocodeClient.log("\tState:   " + location.getState());
                }
                if (location.hasCountry()) {
                    GeocodeClient.log("\tCountry: " + location.getCountry());
                }
                int nrJurisdictions = geocode.sizeJurisdiction();
                for (int j = 0; j < nrJurisdictions; ++j) {
                    Jurisdiction jurisdiction = geocode.getJurisdictionAt(j);
                    String jurisdictionName = "UNDEFINED";
                    String jurisdictionLevel = "UNDEFINED";
                    if (jurisdiction.hasJurisdictionName()) {
                        jurisdictionName = jurisdiction.getJurisdictionName();
                    }
                    if (jurisdiction.hasJurisdictionLevel()) {
                        jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                    }
                    GeocodeClient.log("\tJurisdiction[" + j + "]: " + jurisdictionName + " (" + jurisdictionLevel + ')');
                }
            }
            GeocodeClient.log("");
            taxProvider.close();
        }
        catch (Exception ex) {
            GeocodeClient.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        GeocodeClient.log("Using argument -D" + p_key + '=' + value);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }
}

