/*
 * Decompiled with CFR 0.152.
 */
package unannoy.util;

import unannoy.util.NullArgumentException;

public class ArgCheck {
    public static void notNullOrEmpty(String argumentName, String argumentValue) throws NullArgumentException {
        ArgCheck.notNullOrEmpty(null, argumentName, argumentValue);
    }

    public static void notNullOrEmpty(String location, String argumentName, String argumentValue) throws NullArgumentException {
        if (argumentValue == null || argumentValue.length() == 0) {
            throw new NullArgumentException(location, argumentName, argumentValue);
        }
    }

    public static void notNull(String argumentName, Object argumentValue) throws NullArgumentException {
        ArgCheck.notNull(null, argumentName, argumentValue);
    }

    public static void notNull(String location, String argumentName, Object argumentValue) throws NullArgumentException {
        if (argumentValue == null) {
            throw new NullArgumentException(location, argumentName);
        }
    }

    public static String beginMessage(String location) {
        return location == null ? "" : "In \"" + location + "\": ";
    }

    public static String beginMessage(String location, String argName) {
        return ArgCheck.beginMessage(location) + ArgCheck.argString(argName) + " ";
    }

    public static String beginMessage(String location, String argName, String argValue) {
        return ArgCheck.beginMessage(location) + ArgCheck.argString(argName, argValue) + " ";
    }

    public static String argString(String argName) {
        return "argument \"" + argName + "\"";
    }

    public static String argString(String argName, String argValue) {
        return ArgCheck.argString(argName) + " with value \"" + argValue + "\"";
    }
}

