/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1.vertex1;

import com.ssa.taimpl.taxprovider1.vertex1.Util;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.w3c.dom.Node;

public class JaxbValidationHandler
implements ValidationEventHandler {
    private static final Util UTIL = Util.getInstance();
    private static final Logger s_logger = UTIL.getLogger();
    private final String m_messagePrefix;

    JaxbValidationHandler(String p_messagePrefix) {
        this.m_messagePrefix = p_messagePrefix;
    }

    public boolean handleEvent(ValidationEvent p_validationEvent) {
        if (p_validationEvent == null) {
            throw new IllegalArgumentException("ValidationEventHandler received null validation event");
        }
        int severity = p_validationEvent.getSeverity();
        Level logLevel = null;
        boolean returnValue = false;
        switch (severity) {
            case 0: {
                logLevel = Level.WARNING;
                returnValue = true;
                break;
            }
            default: {
                logLevel = Level.INFO;
            }
        }
        StringBuffer buffer = new StringBuffer(this.m_messagePrefix).append('[');
        this.appendSeverity(severity, buffer).append("] [");
        ValidationEventLocator eventLocator = p_validationEvent.getLocator();
        this.appendLocation(eventLocator, buffer).append("] [");
        String message = p_validationEvent.getMessage();
        if (message == null) {
            buffer.append("No message");
        } else {
            buffer.append(message);
        }
        buffer.append(']');
        Throwable throwable = p_validationEvent.getLinkedException();
        if (throwable != null) {
            s_logger.log(logLevel, buffer.toString(), throwable);
        } else {
            s_logger.log(logLevel, buffer.toString());
        }
        return returnValue;
    }

    private StringBuffer appendLocation(ValidationEventLocator p_eventLocator, StringBuffer p_buffer) {
        int currentLength;
        Object object;
        Node node;
        if (p_eventLocator == null) {
            p_buffer.append("Unknown Location");
            return p_buffer;
        }
        int initialLength = p_buffer.length();
        URL url = p_eventLocator.getURL();
        if (url != null) {
            p_buffer.append('\"').append(url).append("\", ");
        }
        int lineNr = p_eventLocator.getLineNumber();
        int colNr = p_eventLocator.getColumnNumber();
        int offset = p_eventLocator.getOffset();
        if (lineNr != -1 || colNr != -1 || offset != -1) {
            p_buffer.append('(');
            this.appendNr(lineNr, p_buffer).append(", ");
            this.appendNr(colNr, p_buffer).append(", ");
            this.appendNr(offset, p_buffer).append("), ");
        }
        if ((node = p_eventLocator.getNode()) != null) {
            p_buffer.append("node(").append(node).append("), ");
        }
        if ((object = p_eventLocator.getObject()) != null) {
            p_buffer.append("object(").append(object).append("), ");
        }
        if ((currentLength = p_buffer.length()) > initialLength) {
            p_buffer.setLength(currentLength - 2);
        }
        return p_buffer;
    }

    private StringBuffer appendNr(int p_nr, StringBuffer p_buffer) {
        if (p_nr == -1) {
            p_buffer.append('?');
        } else {
            p_buffer.append(p_nr);
        }
        return p_buffer;
    }

    private StringBuffer appendSeverity(int p_severity, StringBuffer p_buffer) {
        switch (p_severity) {
            case 2: {
                p_buffer.append("FATAL_ERROR");
                break;
            }
            case 1: {
                p_buffer.append("ERROR");
                break;
            }
            case 0: {
                p_buffer.append("WARNING");
                break;
            }
            default: {
                p_buffer.append("UNKNOWN_SEVERITY(").append(p_severity).append(')');
            }
        }
        return p_buffer;
    }
}

