/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

abstract class AbstractLogFormatter
extends Formatter {
    static final String NL = System.getProperty("line.separator");
    private static final int MAX_LEVEL_LENGTH = 7;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyMMdd-HHmmss");

    public AbstractLogFormatter() {
        SimpleTimeZone zone = new SimpleTimeZone(0, "UTC");
        DATE_FORMAT.setTimeZone(zone);
    }

    void appendDateLevelAndMessage(LogRecord p_record, StringBuffer p_buffer) {
        String dateString = DATE_FORMAT.format(new Date(p_record.getMillis()));
        p_buffer.append(dateString);
        String levelString = p_record.getLevel().toString();
        p_buffer.append(": ").append(levelString);
        int extraSpace = 7 - levelString.length();
        this.appendSpace(extraSpace, p_buffer);
        p_buffer.append(": ");
        String message = this.formatMessage(p_record);
        p_buffer.append(message);
    }

    private void appendSpace(int p_amount, StringBuffer p_buffer) {
        for (int i = 0; i < p_amount; ++i) {
            p_buffer.append(' ');
        }
    }

    public String formatMessage(LogRecord p_record) {
        String message;
        String formattedMessage = message = super.formatMessage(p_record);
        if (message.startsWith("ENTRY")) {
            formattedMessage = "-> " + p_record.getSourceClassName() + '.' + p_record.getSourceMethodName() + '(' + message.substring(5) + ')';
        } else if (message.startsWith("RETURN")) {
            formattedMessage = "<- " + p_record.getSourceClassName() + '.' + p_record.getSourceMethodName() + "(): " + message.substring(6);
        }
        return formattedMessage;
    }
}

