/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.BitSet;

public class URLName {
    protected String fullURL;
    private String protocol;
    private String username;
    private String password;
    private String host;
    private InetAddress hostAddress;
    private boolean hostAddressKnown = false;
    private int port = -1;
    private String file;
    private String ref;
    private int hashCode = 0;
    private static boolean doEncode;
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;

    public URLName(String string, String string2, int n, String string3, String string4, String string5) {
        int n2;
        this.protocol = string;
        this.host = string2;
        this.port = n;
        if (string3 != null && (n2 = string3.indexOf(35)) != -1) {
            this.file = string3.substring(0, n2);
            this.ref = string3.substring(n2 + 1);
        } else {
            this.file = string3;
            this.ref = null;
        }
        this.username = doEncode ? URLName.encode(string4) : string4;
        this.password = doEncode ? URLName.encode(string5) : string5;
    }

    public URLName(URL uRL) {
        this(uRL.toString());
    }

    public URLName(String string) {
        this.parseString(string);
    }

    public String toString() {
        if (this.fullURL == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.protocol != null) {
                stringBuffer.append(this.protocol);
                stringBuffer.append(":");
            }
            if (this.username != null || this.host != null) {
                stringBuffer.append("//");
                if (this.username != null) {
                    stringBuffer.append(this.username);
                    if (this.password != null) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.password);
                    }
                    stringBuffer.append("@");
                }
                if (this.host != null) {
                    stringBuffer.append(this.host);
                }
                if (this.port != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(Integer.toString(this.port));
                }
                if (this.file != null) {
                    stringBuffer.append("/");
                }
            }
            if (this.file != null) {
                stringBuffer.append(this.file);
            }
            if (this.ref != null) {
                stringBuffer.append("#");
                stringBuffer.append(this.ref);
            }
            this.fullURL = stringBuffer.toString();
        }
        return this.fullURL;
    }

    protected void parseString(String string) {
        int n;
        this.password = null;
        this.username = null;
        this.host = null;
        this.ref = null;
        this.file = null;
        this.protocol = null;
        this.port = -1;
        int n2 = string.length();
        int n3 = string.indexOf(58);
        if (n3 != -1) {
            this.protocol = string.substring(0, n3);
        }
        if (string.regionMatches(n3 + 1, "//", 0, 2)) {
            int n4;
            String string2 = null;
            int n5 = string.indexOf(47, n3 + 3);
            if (n5 != -1) {
                string2 = string.substring(n3 + 3, n5);
                this.file = n5 + 1 < n2 ? string.substring(n5 + 1) : "";
            } else {
                string2 = string.substring(n3 + 3);
            }
            int n6 = string2.indexOf(64);
            if (n6 != -1) {
                String string3 = string2.substring(0, n6);
                string2 = string2.substring(n6 + 1);
                int n7 = string3.indexOf(58);
                if (n7 != -1) {
                    this.username = string3.substring(0, n7);
                    this.password = string3.substring(n7 + 1);
                } else {
                    this.username = string3;
                }
            }
            if ((n4 = string2.length() > 0 && string2.charAt(0) == '[' ? string2.indexOf(58, string2.indexOf(93)) : string2.indexOf(58)) != -1) {
                String string4 = string2.substring(n4 + 1);
                if (string4.length() > 0) {
                    try {
                        this.port = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = -1;
                    }
                }
                this.host = string2.substring(0, n4);
            } else {
                this.host = string2;
            }
        } else if (n3 + 1 < n2) {
            this.file = string.substring(n3 + 1);
        }
        if (this.file != null && (n = this.file.indexOf(35)) != -1) {
            this.ref = this.file.substring(n + 1);
            this.file = this.file.substring(0, n);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return doEncode ? URLName.decode(this.username) : this.username;
    }

    public String getPassword() {
        return doEncode ? URLName.decode(this.password) : this.password;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getProtocol(), this.getHost(), this.getPort(), this.getFile());
    }

    public boolean equals(Object object) {
        String string;
        if (!(object instanceof URLName)) {
            return false;
        }
        URLName uRLName = (URLName)object;
        if (uRLName.protocol == null || !uRLName.protocol.equals(this.protocol)) {
            return false;
        }
        InetAddress inetAddress = this.getHostAddress();
        InetAddress inetAddress2 = uRLName.getHostAddress();
        if (inetAddress != null && inetAddress2 != null ? !inetAddress.equals(inetAddress2) : (this.host != null && uRLName.host != null ? !this.host.equalsIgnoreCase(uRLName.host) : this.host != uRLName.host)) {
            return false;
        }
        if (!(this.username == uRLName.username || this.username != null && this.username.equals(uRLName.username))) {
            return false;
        }
        String string2 = this.file == null ? "" : this.file;
        String string3 = string = uRLName.file == null ? "" : uRLName.file;
        if (!string2.equals(string)) {
            return false;
        }
        return this.port == uRLName.port;
    }

    public int hashCode() {
        InetAddress inetAddress;
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.protocol != null) {
            this.hashCode += this.protocol.hashCode();
        }
        if ((inetAddress = this.getHostAddress()) != null) {
            this.hashCode += inetAddress.hashCode();
        } else if (this.host != null) {
            this.hashCode += this.host.toLowerCase().hashCode();
        }
        if (this.username != null) {
            this.hashCode += this.username.hashCode();
        }
        if (this.file != null) {
            this.hashCode += this.file.hashCode();
        }
        this.hashCode += this.port;
        return this.hashCode;
    }

    private synchronized InetAddress getHostAddress() {
        if (this.hostAddressKnown) {
            return this.hostAddress;
        }
        if (this.host == null) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostAddress = null;
        }
        this.hostAddressKnown = true;
        return this.hostAddress;
    }

    static String encode(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && dontNeedEncoding.get(c)) continue;
            return URLName._encode(string);
        }
        return string;
    }

    private static String _encode(String string) {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            try {
                outputStreamWriter.write(n2);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                char c = Character.forDigit(byArray[j] >> 4 & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(byArray[j] & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (URLName.indexOfAny(string, "+%") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        String string2 = stringBuffer.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    private static int indexOfAny(String string, String string2) {
        return URLName.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n) {
        try {
            int n2 = string.length();
            for (int i = n; i < n2; ++i) {
                if (string2.indexOf(string.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    static {
        int n;
        doEncode = true;
        try {
            doEncode = !Boolean.getBoolean("mail.URLName.dontencode");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

