#
#	SCCSID ("@(#)install.sh	2.15 05/02/08")
#

CleanUp()
{
	rm -f $Pltf/installer $Pltf/ls_ctl $RmvDis 2>>$Elog
	if [ $Upgrade = 0 ]
	then rm -f version.txt
	fi
	if [ -d $Pltf ]
	then
		rmdir $Pltf 2>>$Elog
	fi
	exit $1
}

Fatal()
{
	echo "$prg: Elles can not run [installation process aborted]"
	exit 9
}

Elog=/dev/null
if [ ! -z "$LS_LOG" ]
then	Elog=$LS_LOG
	rm -f $Elog 2>/dev/null
fi

prg=`basename $0 2>>$Elog`
TarFile=""

Error=0
PortNr="9060"
while [ ! $# = 0 ]
do
	if [ "$1" = "-p" ]; then
		if [ -z "$2" ]; then
			Error=1
			break
		fi
		PortNr=$2
		shift 2
		continue
	fi
	if [ ! -z "$TarFile" ]; then
		Error=1
		break
	fi
	TarFile=$1; shift
done
Pnr="-p $PortNr"

if [ -z "$TarFile" ]; then
	TarFile=`ls *elles*.tar.Z 2>/dev/null`
	if [ -z "$TarFile" ]; then
		TarFile=`ls *.tar.Z 2>/dev/null`
		if [ -z "$TarFile" ]; then
			Error=1
		fi
	fi
	if [ $Error = 0 ]; then
		Nfiles=`ls "$TarFile" 2>/dev/null | wc -l | sed -e "/  */s///" -e "/  *$/s///"`
		if [ ! $Nfiles = 1 ]; then
			Error=1
		fi
	fi
fi
if [ $Error = 1 ]; then
     echo "Usage: $prg [-p <port number>] <tar input file>"
     exit
fi
PWD=`pwd 2>/dev/null`
startdir="$PWD"

case "$TarFile" in
[/\\]*|[a-z]:[/\\]*) ;;
*) TarFile="$startdir/$TarFile"
    ;;
esac
InputTar="$TarFile"
case "$TarFile" in
*.Z|*.z)	Tfile=`echo "$TarFile" | sed -e "s/\.[zZ]$//" 2>/dev/null`;;
*)		Tfile="$TarFile"; TarFile="$TarFile.Z";;
esac
if [ ! -s "$TarFile" ]
then
	if [ ! -s "$Tfile" ]
	then
	     echo "$prg: $InputTar not found or empty"
	     exit
	fi
fi
if [ -z "$BSE" ]
then   echo "$prg: environment variable BSE is not defined"
       Fatal
fi
BSEless=0
if [ $BSE = "bypass" ]
then
	BSEless=1
elif [ ! -d "$BSE" ]
then   if [ -f "$BSE" ]
       then echo "$prg: environment variable $BSE doesn't specify a directory"
       else echo "$prg: environment variable BSE points to non-existing directory $BSE"
       fi
       Fatal
fi

if [ $BSEless = 0 ]
then
	if [ ! -d "$BSE/bin" ]
	then   echo "$prg: environment variable BSE should point to an existing Baan environment [\$BSE/bin directory not found]"
	       Fatal
	fi
fi

if [ ! -w "$startdir" ]
then echo "$prg: current directory is not writable; please start again in a writable directory"
     Fatal
fi

Tdir="dir-$$-tmp"
Tfil="fil-$$-tmp.txt"
mkdir $Tdir 2>/dev/null
UmskVal=`umask 2>/dev/null`
if [ ! -d "$Tdir" ]
then echo "$prg: cannot create working directory, check umask setting [current value $UmskVal]"
     Fatal
fi
echo "$Tfil" >$Tfil 2>/dev/null
cp $Tfil $Tdir 2>/dev/null
Error=0
if [ ! -s "$Tdir/$Tfil" ]
then Error=1
fi
rm -f $Tfil $Tdir/$Tfil 2>/dev/null
rmdir $Tdir 2>/dev/null
if [ $Error = 1 ]
then echo "$prg: cannot create files in working directory, check umask setting [current value $UmskVal]"
     Fatal
fi

Platform()
{
	t1=""
	case $1 in
	ai*|AI*)		t1="aix";;
	OS/390)			t1="s390";;
	de*|DE*|osf*|OSF*)	t1="dec";;
	hp*|HP*)		t1="hpu";;
	li*|LI*|Li*)		t1="linux";;
	sc*|SC*)		t1="sco";;
	se*|SE*|DY*)		t1="sequent";;
	sn*|SN*|SI*)		t1="sni";;
	su*|SU*|Su*)		t1="sun";;
	*)			t1="undefined";;
	esac
	echo $t1
}

CheckTar()
{
	TarError=`sed -e "/Error exit delayed from previous errors/d" $1`
	if [ ! -z "$TarError" ]; then
		TarError=`echo $TarError | sed -e "/version.txt/d" -e "/\/ls_ctl/d" -e "/\/installer/d" -e "/disclaim.txt/d"`
		if [ -z "$TarError" ]; then
			rm -f $1
			return
		fi
		if [ $Pltf = "dec" ]; then
			TarError=`sed -e "/tar: Aborted/!d" $1`
			if [ ! -z "$TarError" ]; then
				tem=""
				while [ "$tem" = "" ]
				do
				echo "Bypass multi-volume assumption (y/n) ?   \c"
				read tem
				done
				case $tem in
				y*|Y*)	rm -f $1;return;;
				esac
			fi
		fi
		OutStr=$Elog
		if [ $OutStr = "/dev/null" ]
		then
			OutStr="/dev/tty"
		fi
		cat $1 >>$OutStr
		echo "$prg: could not extract mandatory files from $InputTar"
		echo "$prg: check if $InputTar was FTP-ed in ASCII mode (BINARY is necessary)"
		rm -f $1
		CleanUp
		Fatal
	fi
	rm -f $1
}

Upgrade=0
Trg=`uname 2>>$Elog`
Pltf=`Platform $Trg`

echo "Extracting installer from $InputTar"
RmvDis="disclaim.txt"
if [ -s disclaim.txt ]; then
	mv -f disclaim.txt disclaim.XXX
	RmvDis=""
fi
DoZcat=0
Xval=`od -tx2 -N2 "$TarFile" 2>/dev/null | sed -e "/00 /!d" -e "/.* /s///"`
case "$Xval" in
1f9d | 9d1f | 1F9D | 9D1F)	DoZcat=1;;
esac
TmpTar=tarext$$.txt
if [ $DoZcat = 1 ]; then
	zcat "$Tfile" 2>>$Elog | tar xf - $Pltf/installer $Pltf/ls_ctl disclaim.txt version.txt 2>>$TmpTar
	CheckTar $TmpTar
else
	tar xf "$Tfile" $Pltf/installer $Pltf/ls_ctl disclaim.txt version.txt 2>>$TmpTar
	CheckTar $TmpTar
fi
if [ -s disclaim.txt ]
then rm -f disclaim.XXX
else
	if [ -s disclaim.XXX ]; then
		mv -f disclaim.XXX disclaim.txt; RmvDis=""
	fi
fi
DoStop=1
if [ ! -s $Pltf/ls_ctl ]
then DoStop=0
fi
if [ ! -f $Pltf/installer ]
then if [ $Upgrade = 1 ]
     then 
	if [ ! -d $Pltf ]
	then mkdir $Pltf 2>/dev/null
	fi
	ln installer $Pltf 2>/dev/null
     fi
     if [ ! -f $Pltf/installer ]
     then echo "$prg: installer for $Pltf not found in $InputTar"
	  echo "$prg: Elles is not installed"
	  Fatal
     fi
fi
Error=0
if [ $DoStop = 1 ]
then	chmod 555 $Pltf/ls_ctl
	$Pltf/ls_ctl $Pnr -c alive
	Rval=$?
	if [ $Rval = 0 ]; then
		echo "\nElles listener present on port $PortNr"
		echo "Enter \"yes\" to continue this installation (old listener will be stopped)"
		echo "Enter \"no\" to stop this installation (old listener will keep running)"
		echo "\nDo you want to proceed with this installation: yes/no?  \c"
		read tem rest
		Proceed=0
		case "$tem" in
		y*|Y*)	Proceed=1;;
		esac
		if [ $Proceed = 0 ]; then
			echo "Installation is stopped"
			echo "You can choose another port number and repeat this installation."
			CleanUp 0
		fi
		$Pltf/ls_ctl $Pnr -c stop
		Rval=$?
		if [ ! $Rval = 0 ]; then
			echo "Failed to kill a running version of the Elles listener (installation aborted)"
			Error=1
		fi
	fi
fi
if [ $Error = 0 ]; then
	chmod 555 $Pltf/installer
	trap 'CleanUp' ERR
	$Pltf/installer $Pnr "$TarFile" $Pltf 2>/dev/null
	Error=$?
	trap - ERR
fi
CleanUp $Error
