/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import java.util.Hashtable;
import org.xml.sax.Attributes;

public class LayoutElement {
    public static final int FIELD = 0;
    public static final int SPECIAL = 1;
    public static final int TEXT = 2;
    private int m_type;
    private Hashtable m_attributes = new Hashtable();

    public LayoutElement(int n, Attributes attributes) {
        this.m_type = n;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            this.m_attributes.put(string, string2);
        }
    }

    public LayoutElement(Hashtable hashtable) {
        this.m_type = 0;
        this.m_attributes = hashtable;
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public int getType() {
        return this.m_type;
    }

    public static Font getStandardFont(Document document, int n) {
        String string = "Courier";
        float f = document.getPageSize().width() / (float)n;
        return FontFactory.getFont((String)string, (float)(f += 1.9f));
    }

    public Font getFont(Document document, int n) {
        if (this.m_type == 2) {
            return LayoutElement.getStandardFont(document, n);
        }
        int n2 = 0;
        String string = "Courier";
        float f = document.getPageSize().width() / (float)n;
        f += 1.9f;
        if (this.m_attributes.containsKey("bold") && "yes".equalsIgnoreCase((String)this.m_attributes.get("bold"))) {
            n2 = 1;
        }
        if (this.m_attributes.containsKey("underline") && "yes".equalsIgnoreCase((String)this.m_attributes.get("underline"))) {
            n2 = 4;
        }
        return FontFactory.getFont((String)string, (float)f, (int)n2);
    }
}

