/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BMLConverter
extends DefaultHandler {
    private Writer m_writer;
    private StringBuffer m_chars;
    private String m_charsSetDirectly;
    private int m_pass = 1;
    protected Stack m_tags = new Stack();
    private boolean m_stopWriting = false;
    static /* synthetic */ Class class$java$lang$String;

    public int getNumberOfPasses() {
        return 1;
    }

    public int getPass() {
        return this.m_pass;
    }

    protected void init() {
        this.m_stopWriting = false;
        this.m_tags.clear();
    }

    protected boolean isWritingStopped() {
        return this.m_stopWriting;
    }

    protected void stopWriting() {
        this.m_stopWriting = true;
    }

    protected void startWriting() {
        this.m_stopWriting = false;
    }

    public synchronized void convert(String string, String string2) throws SAXException, IOException {
        this.init();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        xMLReader.setContentHandler(this);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        this.m_writer = new BufferedWriter(outputStreamWriter);
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        for (int i = 0; i < this.getNumberOfPasses(); ++i) {
            this.m_pass = i + 1;
            this.parse(xMLReader, string);
        }
        this.m_writer.close();
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    protected void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        xMLReader.parse(string);
    }

    public void writeStartTag(String string) throws IOException {
        this.writeStartTag(string, true);
    }

    public void writeStartTag(String string, boolean bl) throws IOException {
        if (!this.m_stopWriting) {
            this.writeSpaces();
            this.m_tags.push(new Object[]{string, null});
            this.write("<");
            this.write(string);
            if (bl) {
                this.write(">");
            }
        }
    }

    protected void writeSpaces() throws IOException {
        this.write("\n");
        for (int i = 0; i < this.m_tags.size(); ++i) {
            this.write("   ");
        }
    }

    public String getCurrentTag() {
        if (this.m_tags.size() == 0) {
            return "none";
        }
        return (String)((Object[])this.m_tags.peek())[0];
    }

    public Object getCurrentExtra() {
        if (this.m_tags.size() == 0) {
            return null;
        }
        return ((Object[])this.m_tags.peek())[1];
    }

    public void setCurrentExtra(Object object) {
        ((Object[])this.m_tags.elementAt((int)(this.m_tags.size() - 1)))[1] = object;
    }

    public void writeEndTag() throws IOException {
        if (!this.m_stopWriting) {
            String string = this.getCurrentTag();
            this.m_tags.pop();
            this.write("</");
            this.write(string);
            this.write(">");
        }
    }

    public void write(String string) throws IOException {
        if (string != null && !this.m_stopWriting) {
            this.m_writer.write(string);
        }
    }

    public void writeData(String string) throws IOException {
        this.write("<![CDATA[" + string + "]]>");
    }

    public void writeTagAndData(String string, String string2) throws IOException {
        this.writeSpaces();
        this.write("<" + string + ">");
        this.writeData(string2);
        this.write("</" + string + ">");
    }

    public void writeTag(String string, String string2) throws IOException {
        this.writeSpaces();
        this.write("<" + string + ">");
        this.write(string2);
        this.write("</" + string + ">");
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public void characters(char[] cArray, int n, int n2) {
        try {
            if (this.m_chars != null) {
                String string = new String(cArray, n, n2);
                if (string.length() == 1) {
                    char c = string.charAt(0);
                    switch (c) {
                        case '<': {
                            string = "&lt;";
                            break;
                        }
                        case '>': {
                            string = "&gt;";
                            break;
                        }
                        case '&': {
                            string = "&amp;";
                            break;
                        }
                        case '\'': {
                            string = "&apos;";
                            break;
                        }
                        case '\"': {
                            string = "&quot;";
                        }
                    }
                }
                this.m_chars.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startCharacters() {
        this.m_chars = new StringBuffer();
    }

    public boolean isCharactersStarted() {
        return this.m_chars != null;
    }

    public void setCharactersDirectly(String string) {
        this.m_charsSetDirectly = string;
    }

    public String getCharacters() {
        if (this.m_charsSetDirectly != null) {
            return this.m_charsSetDirectly;
        }
        if (this.m_chars == null) {
            return "";
        }
        return this.m_chars.toString();
    }

    public void stopCharacters() {
        this.m_chars = null;
        this.m_charsSetDirectly = null;
    }

    protected void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    protected Writer getWriter() {
        return this.m_writer;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "com.ssaglobal.bml.BML2" + stringArray[0];
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[stringArray.length - 1];
            Object[] objectArray = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray.length - 1; ++i) {
                classArray[i] = class$java$lang$String == null ? BMLConverter.class$("java.lang.String") : class$java$lang$String;
                objectArray[i] = stringArray[i + 1];
            }
            Method method = clazz.getMethod("convertBML", classArray);
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println();
            System.out.println("Example usage: java -classpath .;bml2xml.jar;xml-apis.jar;xercesImpl.jar com.ssaglobal.bml.BMLConverter Rosettanet <bml file in> <rosettanet file out>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

