/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfWriter;
import com.ssaglobal.bml.LLine;
import com.ssaglobal.bml.LayoutElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BML2PDF
extends DefaultHandler {
    private StringBuffer m_chars;
    private String m_charsSetDirectly;
    private int m_pass = 1;
    private Hashtable m_lines = new Hashtable();
    private LLine m_currentLLine = null;
    private int m_currentLLineIndex = -1;
    private Document m_document = null;
    private Table m_currentTable = null;
    private Cell m_currentCell = null;
    private int m_pageWidth = 80;

    public int getNumberOfPasses() {
        return 1;
    }

    public int getPass() {
        return this.m_pass;
    }

    public static void convert(String string, String string2) {
        BML2PDF bML2PDF = new BML2PDF();
        bML2PDF.convertBML2PDF(string, string2);
    }

    public static void convertBML(String string, String string2) {
        BML2PDF.convert(string, string2);
    }

    public static void convertDirectory(String string, String string2) {
        BML2PDF bML2PDF = new BML2PDF();
        File file = new File(string);
        File file2 = new File(string2);
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].toString();
            String string4 = fileArray[i].getName();
            String string5 = string4.substring(0, string4.indexOf(".xml")) + ".pdf";
            String string6 = file2.toString() + "\\" + string5;
            bML2PDF.convertBML2PDF(string3, string6);
        }
    }

    public void convertBML2PDF(String string, String string2) {
        try {
            Document document = new Document(PageSize.A4, 5.0f, 5.0f, 5.0f, 5.0f);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(string2));
            document.open();
            this.convert(document, string);
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string + " - " + exception.getMessage());
        }
    }

    public synchronized void convert(Document document, String string) throws SAXException, IOException {
        this.m_document = document;
        XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        xMLReader.setContentHandler(this);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        for (int i = 0; i < this.getNumberOfPasses(); ++i) {
            this.m_pass = i + 1;
            this.parse(xMLReader, string);
        }
    }

    protected void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        xMLReader.parse(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equals("report")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    String string5 = attributes.getValue(i);
                    hashtable.put(string4, string5);
                }
                if (hashtable.containsKey("pwidth")) {
                    String string6 = (String)hashtable.get("pwidth");
                    this.m_pageWidth = Integer.parseInt(string6) + 1;
                }
            } else if (string3.equals("emptyline")) {
                this.m_document.add((Element)new Paragraph(" ", LayoutElement.getStandardFont(this.m_document, this.m_pageWidth)));
            } else if (string3.equals("pagebreak")) {
                this.m_document.newPage();
            } else if (string3.equals("row")) {
                this.m_currentTable = new Table(this.m_pageWidth);
                this.m_currentTable.setBorderWidth(0.0f);
                this.m_currentTable.setWidth(100.0f);
                String string7 = attributes.getValue("layout");
                if (string7 != null) {
                    this.m_currentLLine = (LLine)this.m_lines.get(string7);
                }
            } else if (string3.equals("e")) {
                Object object;
                this.m_currentCell = new Cell();
                this.m_currentCell.setBorderWidth(0.0f);
                if (this.m_currentLLine != null) {
                    ++this.m_currentLLineIndex;
                    if (this.m_currentLLine.hasElementAt(this.m_currentLLineIndex)) {
                        String string8;
                        object = this.m_currentLLine.getElementAt(this.m_currentLLineIndex);
                        Hashtable hashtable = ((LayoutElement)object).getAttributes();
                        if (hashtable.containsKey("align")) {
                            String string9 = (String)hashtable.get("align");
                            if ("Right".equalsIgnoreCase(string9)) {
                                this.m_currentCell.setHorizontalAlignment(2);
                            } else if ("Centered".equalsIgnoreCase(string9)) {
                                this.m_currentCell.setHorizontalAlignment(1);
                            }
                        }
                        int n = 0;
                        if (hashtable.containsKey("col")) {
                            string8 = (String)hashtable.get("col");
                            n = Integer.parseInt(string8);
                            n = Math.min(n, this.m_pageWidth - 1);
                            this.m_currentTable.addCell(this.m_currentCell, 0, n);
                        } else {
                            this.m_currentTable.addCell(this.m_currentCell);
                        }
                        if (hashtable.containsKey("width")) {
                            string8 = (String)hashtable.get("width");
                            int n2 = Integer.parseInt(string8);
                            n2 = Math.max(1, n2);
                            n2 = Math.min(n2, this.m_pageWidth - n);
                            this.m_currentCell.setColspan(n2);
                        }
                    }
                }
                if ((object = attributes.getValue("pv")) != null) {
                    this.setCharatersDirectly((String)object);
                } else {
                    this.startCharacters();
                }
            } else if (string3.equals("lline")) {
                String string10 = attributes.getValue("id");
                LLine lLine = new LLine(string10);
                this.m_lines.put(string10, lLine);
                this.m_currentLLine = lLine;
            } else if (string3.equals("special")) {
                LayoutElement layoutElement = new LayoutElement(1, attributes);
                this.m_currentLLine.addElement(layoutElement);
            } else if (string3.equals("field")) {
                LayoutElement layoutElement = new LayoutElement(0, attributes);
                this.m_currentLLine.addElement(layoutElement);
            } else if (string3.equals("text")) {
                LayoutElement layoutElement = new LayoutElement(2, attributes);
                this.m_currentLLine.addTextElement(layoutElement);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception startElement: " + this.m_currentLLine.getId());
            exception.printStackTrace();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (!(string3.equals("report") || string3.equals("emptyline") || string3.equals("pagebreak"))) {
                if (string3.equals("row")) {
                    Vector vector = this.m_currentLLine.getTextElements();
                    for (int i = 0; i < vector.size(); ++i) {
                        String string4;
                        LayoutElement layoutElement = (LayoutElement)vector.elementAt(i);
                        Hashtable hashtable = layoutElement.getAttributes();
                        Cell cell = new Cell();
                        cell.setBorderWidth(0.0f);
                        int n = 0;
                        if (hashtable.containsKey("col")) {
                            string4 = (String)hashtable.get("col");
                            n = Integer.parseInt(string4);
                            this.m_currentTable.addCell(cell, 0, n);
                        } else {
                            this.m_currentTable.addCell(cell);
                        }
                        string4 = "";
                        if (hashtable.containsKey("content")) {
                            string4 = (String)hashtable.get("content");
                            string4 = this.filterCharacters(string4);
                            int n2 = Math.max(1, string4.length());
                            n2 = Math.min(n2, this.m_pageWidth - n);
                            cell.setColspan(n2);
                        }
                        cell.addElement((Element)new Chunk(string4, layoutElement.getFont(this.m_document, this.m_pageWidth)));
                    }
                    this.m_currentLLine.setTempElement(null);
                    this.m_currentLLine = null;
                    this.m_currentLLineIndex = -1;
                    this.m_document.add((Element)this.m_currentTable);
                    this.m_currentTable = null;
                } else if (string3.equals("e")) {
                    if (this.m_currentLLine.hasElementAt(this.m_currentLLineIndex)) {
                        LayoutElement layoutElement = this.m_currentLLine.getElementAt(this.m_currentLLineIndex);
                        this.m_currentCell.addElement((Element)new Chunk(this.getCharacters(), layoutElement.getFont(this.m_document, this.m_pageWidth)));
                    } else {
                        Object object;
                        LayoutElement layoutElement = null;
                        if (this.m_currentLLine.hasTempElement()) {
                            layoutElement = this.m_currentLLine.getTempElement();
                        } else if (this.m_currentLLine.hasElements()) {
                            layoutElement = this.m_currentLLine.getLastElement();
                        }
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        String string5 = this.getCharacters();
                        int n = string5.length();
                        hashtable.put("colspan", "" + n);
                        this.m_currentCell.setColspan(n);
                        int n3 = 0;
                        if (layoutElement != null) {
                            String string6;
                            object = layoutElement.getAttributes();
                            int n4 = 1;
                            if (((Hashtable)object).containsKey("col")) {
                                string6 = (String)((Hashtable)object).get("col");
                                n4 = Integer.parseInt(string6);
                            }
                            if (((Hashtable)object).containsKey("width")) {
                                string6 = (String)((Hashtable)object).get("width");
                                n4 += Integer.parseInt(string6);
                            }
                            n3 = n4;
                            hashtable.put("col", "" + n3);
                        }
                        this.m_currentTable.addCell(this.m_currentCell, 0, n3);
                        object = new LayoutElement(hashtable);
                        this.m_currentLLine.setTempElement((LayoutElement)object);
                        this.m_currentCell.addElement((Element)new Chunk(string5, LayoutElement.getStandardFont(this.m_document, this.m_pageWidth)));
                    }
                    this.stopCharacters();
                    this.m_currentCell = null;
                } else if (string3.equals("lline")) {
                    this.m_currentLLine = null;
                    this.m_currentLLineIndex = -1;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception endElement: " + this.m_currentLLine.getId());
            exception.printStackTrace();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        try {
            if (this.m_chars != null) {
                String string = new String(cArray, n, n2);
                this.m_chars.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startCharacters() {
        this.m_chars = new StringBuffer();
    }

    public void setCharatersDirectly(String string) {
        this.m_charsSetDirectly = string;
    }

    public String getCharacters() {
        if (this.m_charsSetDirectly != null) {
            return this.m_charsSetDirectly;
        }
        if (this.m_chars == null) {
            return "";
        }
        return this.m_chars.toString();
    }

    public void stopCharacters() {
        this.m_chars = null;
        this.m_charsSetDirectly = null;
    }

    private String filterCharacters(String string) {
        String string2 = "";
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u2500': {
                    string2 = string2 + "_";
                    continue block6;
                }
                case '\u2502': {
                    string2 = string2 + "|";
                    continue block6;
                }
                case '\u252c': {
                    string2 = string2 + "_";
                    continue block6;
                }
                case '\u2532': {
                    string2 = string2 + "_";
                    continue block6;
                }
                default: {
                    string2 = string2 + string.charAt(i);
                }
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        BML2PDF.convertDirectory("C:\\tmp\\bml2pdf\\bml\\input", "C:\\tmp\\bml2pdf\\bml\\output");
    }
}

