/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2Cognos;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BML2CognosDesign
extends BML2Cognos {
    private String m_lineId;
    private String m_layoutId;
    private int m_fieldCounter = 0;
    private Vector m_fieldsWithSortseq = null;
    private LinkedHashMap m_layouts = null;
    private Hashtable m_blocks = null;
    private Writer m_mainWriter;
    private Vector m_fieldsWithHeightHigherThanOne = null;

    protected void init() {
        super.init();
        this.m_lineId = null;
        this.m_layoutId = null;
        this.m_fieldCounter = 0;
        this.m_fieldsWithSortseq = new Vector();
        this.m_layouts = new LinkedHashMap();
        this.m_blocks = new Hashtable();
        this.m_fieldsWithHeightHigherThanOne = new Vector();
    }

    protected void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            string2 = bufferedReader.readLine();
        }
        int n = stringBuffer.lastIndexOf(">");
        if (n != -1) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, n + 1));
        }
        if (!stringBuffer.toString().endsWith("</report>")) {
            stringBuffer.append("</report>");
        }
        bufferedReader.close();
        inputStreamReader.close();
        fileInputStream.close();
        StringReader stringReader = new StringReader(stringBuffer.toString());
        InputSource inputSource = new InputSource(stringReader);
        xMLReader.parse(inputSource);
        stringReader.close();
    }

    private void writeLayout(Attributes attributes) throws IOException {
        String string = this.m_layoutId = attributes.getValue("id");
        String string2 = "Detail";
        if (string.startsWith("before.")) {
            string2 = "Header";
        } else if (string.startsWith("after.")) {
            string2 = "Footer";
        } else if (string.startsWith("header.")) {
            string2 = "Header";
        } else if (string.startsWith("footer.")) {
            string2 = "Footer";
        }
        this.writeAttribute(string2, false, attributes, "id", "id");
        this.write("sequenceNumber=\"1\">");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.writeAttribute("ReportDesign", false, attributes, "id", "id", true);
                this.writeAttribute(null, false, attributes, "pwidth", "pageWidth");
                this.write(">");
                this.writeStartTag("Name");
                this.writeData(attributes.getValue("desc"));
                this.writeEndTag();
                this.writeStartTag("Description");
                this.writeData(attributes.getValue("desc"));
                this.writeEndTag();
            } else if (string3.equals("input_field")) {
                String string4 = attributes.getValue("sortseq");
                if (!"99".equals(string4)) {
                    this.m_fieldsWithSortseq.addElement(attributes.getValue("name"));
                }
            } else if (string3.equals("layout")) {
                this.m_mainWriter = this.getWriter();
                StringWriter stringWriter = new StringWriter();
                this.setWriter(stringWriter);
                this.writeLayout(attributes);
            } else if (string3.equals("field")) {
                this.writeField(attributes, false, false);
            } else if (string3.equals("special")) {
                this.writeField(attributes, true, false);
            } else if (string3.equals("text")) {
                this.writeField(attributes, false, true);
                this.writeTagAndData("Text", attributes.getValue("content"));
                this.writeEndTag();
            } else if (string3.equals("lline")) {
                this.m_lineId = attributes.getValue("id");
                int n = Integer.parseInt(this.m_lineId.substring(this.m_lineId.lastIndexOf(46) + 1, this.m_lineId.length()));
                this.m_blocks.put(this.m_layoutId, new Integer(n));
                this.m_fieldCounter = 0;
                this.write("<Line lineNumber=\"" + n + "\">");
                for (int i = 0; i < this.m_fieldsWithHeightHigherThanOne.size(); ++i) {
                    Object[] objectArray = (Object[])this.m_fieldsWithHeightHigherThanOne.elementAt(i);
                    String string5 = (String)objectArray[0];
                    int[] nArray = (int[])objectArray[1];
                    ++this.m_fieldCounter;
                    String string6 = string5.replaceAll("<fieldID>", this.m_lineId + "." + this.m_fieldCounter);
                    this.write(string6);
                    nArray[0] = nArray[0] - 1;
                    if (nArray[0] > 0) continue;
                    this.m_fieldsWithHeightHigherThanOne.remove(i);
                    --i;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeField(Attributes attributes, boolean bl, boolean bl2) throws IOException {
        String string;
        Object object;
        int n;
        Writer writer = null;
        int n2 = n = attributes.getValue("height") == null ? 0 : Integer.parseInt(attributes.getValue("height"));
        if (n > 1) {
            writer = this.getWriter();
            object = new StringWriter();
            this.setWriter((Writer)object);
        }
        ++this.m_fieldCounter;
        Object object2 = object = this.m_lineId + "." + this.m_fieldCounter;
        if (attributes.getValue("label") != null) {
            object2 = attributes.getValue("label");
        } else if (attributes.getValue("fldname") != null) {
            object2 = attributes.getValue("fldname");
        }
        this.writeAttribute("Field", false, attributes, "col", "startPosition");
        if (bl2) {
            // empty if block
        }
        this.writeAttribute(null, true, attributes, "bold", "bold", true);
        if (!bl2) {
            string = "string";
            string = bl ? attributes.getValue("type") : attributes.getValue("fldtype");
            string = "xs:string";
            this.write("<DataItem dataType=\"");
            this.write(string);
            this.write("\" id=\"" + (String)object + "\" ");
            this.writeAttribute(null, false, attributes, "width", "width");
            this.writeAttribute(null, false, attributes, "align", "alignment", true);
            this.write(">");
            this.writeTagAndData("Name", (String)object);
            this.writeTagAndData("Description", (String)object2);
            this.write("</DataItem>");
            this.writeEndTag();
        }
        if (n > 1) {
            string = this.getWriter().toString();
            String string2 = string.replaceAll((String)object, "<fieldID>");
            this.m_fieldsWithHeightHigherThanOne.addElement(new Object[]{string2, new int[]{n - 1}});
            this.setWriter(writer);
            this.write(string);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.writeEndTag();
            } else if (string3.equals("layout")) {
                if (this.getNumberOfLinesInBlock(this.m_layoutId) == -1) {
                    this.write("<Line lineNumber=\"1\"/>");
                    this.m_blocks.put(this.m_layoutId, new Integer(1));
                }
                this.writeEndTag();
                StringWriter stringWriter = (StringWriter)this.getWriter();
                this.m_layouts.put(this.m_layoutId, stringWriter.toString());
                this.setWriter(this.m_mainWriter);
            } else if (!string3.equals("field") && !string3.equals("special")) {
                if (string3.equals("lline")) {
                    this.write("</Line>");
                } else if (string3.equals("head")) {
                    this.buildDesign();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildDesign() throws IOException {
        int n;
        String string = null;
        String string2 = null;
        this.addBlock("header", false);
        this.writeStartTag("TopLevel");
        for (n = 0; n < this.m_fieldsWithSortseq.size(); ++n) {
            string = n == 0 ? "Noppes" : (String)this.m_fieldsWithSortseq.elementAt(n - 1);
            string2 = (String)this.m_fieldsWithSortseq.elementAt(n);
            this.addBlock("before." + string, false);
            this.write("<GroupingDataItem id=\"" + string2 + "\" dataType=\"xs:string\">");
            this.writeTagAndData("Name", string2);
            this.writeTagAndData("Description", string2);
            this.write("</GroupingDataItem>");
            this.writeStartTag("ChildLevel");
        }
        n = 0;
        if (this.m_fieldsWithSortseq.size() > 0) {
            string = (String)this.m_fieldsWithSortseq.elementAt(this.m_fieldsWithSortseq.size() - 1);
            if (this.addBlock("before." + string, true)) {
                n = 1;
            }
        }
        if (this.addBlock("detail", true)) {
            n = 1;
        }
        if (this.m_fieldsWithSortseq.size() > 0) {
            string = (String)this.m_fieldsWithSortseq.elementAt(this.m_fieldsWithSortseq.size() - 1);
            if (this.addBlock("after." + string, true)) {
                n = 1;
            }
        }
        if (n == 0) {
            this.write("<Detail id=\"detail.1\" sequenceNumber=\"1\"><Line lineNumber=\"1\"></Line></Detail>");
        }
        for (int i = this.m_fieldsWithSortseq.size() - 1; i >= 0; --i) {
            this.writeEndTag();
            string = i == 0 ? "Noppes" : (String)this.m_fieldsWithSortseq.elementAt(i - 1);
            this.addBlock("after." + string, false);
        }
        this.writeEndTag();
        this.addBlock("footer", false);
    }

    private boolean addBlock(String string, boolean bl) throws IOException {
        boolean bl2 = false;
        Iterator iterator = this.m_layouts.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            String string3 = (String)this.m_layouts.get(string2);
            if (bl) {
                string3 = string3.replaceAll("Footer", "Detail");
                string3 = string3.replaceAll("Footer", "Detail");
                string3 = string3.replaceAll("Header", "Detail");
                string3 = string3.replaceAll("Header", "Detail");
            }
            this.write(string3);
            bl2 = true;
        }
        return bl2;
    }

    public String getFieldName(int n) {
        if (n >= 0 && n < this.m_fieldsWithSortseq.size()) {
            return (String)this.m_fieldsWithSortseq.elementAt(n);
        }
        return "NO_FIELD";
    }

    public int getNumberOfLevels() {
        return this.m_fieldsWithSortseq.size();
    }

    public int getNumberOfLinesInBlock(String string) {
        Integer n = (Integer)this.m_blocks.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static void convertBML(String string, String string2, String string3) {
        try {
            BML2CognosDesign bML2CognosDesign = new BML2CognosDesign();
            bML2CognosDesign.convert("not_used", string, string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

