/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2CognosDesign;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BML2CognosData
extends BML2CognosDesign {
    private String m_blockId;
    private String m_layoutId;
    private int m_fieldCounter;
    private int m_currentLine;
    private int m_previousLine;
    private int m_block = HEADER;
    private boolean m_readDesign = true;
    private int m_currentLevel;
    private String m_sortGroupValue;
    private boolean m_firstRowEncountered = false;
    private Vector m_sortGroupValuesBeforeFirstRowEncountered;
    private boolean m_ignoreNextSortGroupEnd = false;
    private int m_ignoreSortGroupCount = 0;
    private static int HEADER = 0;
    private static int DETAIL = 1;
    private static int FOOTER = 2;

    protected void init() {
        super.init();
        this.m_layoutId = null;
        this.m_blockId = null;
        this.m_fieldCounter = 0;
        this.m_currentLine = 1;
        this.m_previousLine = 0;
        this.m_block = HEADER;
        this.m_readDesign = true;
        this.m_currentLevel = -1;
        this.m_sortGroupValue = null;
        this.m_firstRowEncountered = false;
        this.m_sortGroupValuesBeforeFirstRowEncountered = new Vector();
        this.m_ignoreNextSortGroupEnd = false;
        this.m_ignoreSortGroupCount = 0;
    }

    private void writeSortGroup() throws IOException {
        this.closeBlock();
        if (this.m_currentLevel >= this.getNumberOfLevels()) {
            this.m_sortGroupValue = null;
            this.m_block = DETAIL;
            return;
        }
        String string = this.m_sortGroupValue;
        this.m_sortGroupValue = null;
        if (this.getNumberOfLevels() > 0) {
            if (!"first".equals(this.getCurrentExtra())) {
                String string2 = this.getCurrentTag();
                this.writeEndTag();
                this.writeStartTag(string2);
                this.setCurrentExtra("later");
            }
            this.setCurrentExtra("later");
            this.writeStartTag("GroupingDataItemValue");
            this.write(string);
            this.writeEndTag();
            this.writeStartTag("ChildLevel");
            this.setCurrentExtra("first");
        } else {
            this.writeStartTag("TopLevel");
            this.setCurrentExtra("first");
        }
        this.m_block = this.m_currentLevel < this.getNumberOfLevels() - 1 ? HEADER : DETAIL;
    }

    private void writeLeftOverSortGroups() throws IOException {
        this.writeStartTag("TopLevel");
        this.setCurrentExtra("first");
        for (int i = 0; i < this.m_sortGroupValuesBeforeFirstRowEncountered.size(); ++i) {
            String string;
            this.m_sortGroupValue = string = (String)this.m_sortGroupValuesBeforeFirstRowEncountered.elementAt(i);
            ++this.m_currentLevel;
            this.writeSortGroup();
        }
        this.m_sortGroupValue = null;
        this.m_sortGroupValuesBeforeFirstRowEncountered = null;
        if (this.getNumberOfLevels() == 0) {
            ++this.m_currentLevel;
            this.m_block = DETAIL;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.writeStartTag("ReportsDocument");
                this.writeAttribute("ReportInstance", false, attributes, "id", "id", true);
                this.write("user=\"");
                this.write(this.getUser());
                this.write("\">");
                this.stopWriting();
            }
            if (this.m_readDesign) {
                super.startElement(string, string2, string3, attributes);
                return;
            }
            if (string3.equals("sortgroup")) {
                String string4 = attributes.getValue("groupvalue");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if (!this.m_firstRowEncountered) {
                    this.m_sortGroupValuesBeforeFirstRowEncountered.addElement(string4);
                    this.m_sortGroupValue = null;
                } else {
                    if (this.m_sortGroupValuesBeforeFirstRowEncountered != null) {
                        this.writeLeftOverSortGroups();
                    }
                    ++this.m_currentLevel;
                    int n = Integer.parseInt(attributes.getValue("id"));
                    if (n == this.m_currentLevel + 1) {
                        this.m_sortGroupValue = string4;
                        this.writeSortGroup();
                    } else {
                        this.closeBlock();
                        ++this.m_ignoreSortGroupCount;
                        this.stopWriting();
                    }
                }
                this.m_blockId = null;
                return;
            }
            if (string3.equals("pagebreak")) {
                return;
            }
            if (string3.equals("emptyline")) {
                return;
            }
            if (!string3.equals("row")) {
                if (!string3.equals("e")) return;
                ++this.m_fieldCounter;
                String string5 = this.m_layoutId + "." + this.m_fieldCounter;
                this.write("<Field layoutDataItemID=\"" + string5 + "\">");
                this.startCharacters();
                return;
            }
            if (this.isWritingStopped()) {
                return;
            }
            this.m_firstRowEncountered = true;
            String string6 = attributes.getValue("layout");
            this.m_fieldCounter = 0;
            int n = string6.lastIndexOf(46);
            String string7 = string6.substring(0, n);
            int n2 = Integer.parseInt(string6.substring(n + 1, string6.length()));
            n = string7.lastIndexOf(46);
            String string8 = string6.substring(0, n);
            this.m_currentLine = n2;
            if (!string7.equals(this.m_blockId) || string6.equals(this.m_layoutId)) {
                String string9;
                block39: {
                    this.m_layoutId = string6;
                    this.closeBlock();
                    this.m_currentLine = n2;
                    this.m_blockId = string7;
                    string9 = null;
                    if (this.m_currentLevel == -1 && this.m_blockId.startsWith("header")) {
                        this.m_block = HEADER;
                        string9 = "Header";
                        this.m_sortGroupValue = null;
                    } else if (this.m_currentLevel == -1 && this.m_blockId.startsWith("footer")) {
                        if ("TopLevel".equals(this.getCurrentTag())) {
                            this.writeEndTag();
                        }
                        this.m_block = FOOTER;
                        string9 = "Footer";
                    } else if (this.m_currentLevel == -1) {
                        if (this.m_sortGroupValuesBeforeFirstRowEncountered != null) {
                            this.writeLeftOverSortGroups();
                            this.m_blockId = string7;
                        } else if (this.m_sortGroupValue != null) {
                            this.m_block = HEADER;
                        } else {
                            this.writeEndTag();
                            this.m_block = FOOTER;
                            string9 = "Footer";
                        }
                    }
                    if (this.m_block == HEADER) {
                        if (this.m_blockId.startsWith("before.") || this.m_blockId.startsWith("header.") && this.m_currentLevel == -1) {
                            string9 = "Header";
                            break block39;
                        } else {
                            this.m_blockId = null;
                            this.stopWriting();
                            return;
                        }
                    }
                    if (this.m_block == DETAIL) {
                        if (!this.m_blockId.startsWith("footer.") && !this.m_blockId.startsWith("header.")) {
                            if (this.m_blockId.startsWith("before.") || this.m_blockId.startsWith("after.")) {
                                String string10 = this.getFieldName(this.getNumberOfLevels() - 1);
                                String string11 = this.getFieldName(this.getNumberOfLevels() - 2);
                                if (!this.m_blockId.startsWith("before." + string10) && !this.m_blockId.startsWith("after." + string10)) {
                                    this.m_blockId = null;
                                    this.stopWriting();
                                    return;
                                }
                            }
                            string9 = "Detail";
                            break block39;
                        } else {
                            this.m_blockId = null;
                            this.stopWriting();
                            return;
                        }
                    }
                    if (this.m_block == FOOTER) {
                        if (this.m_blockId.startsWith("after.") || this.m_blockId.startsWith("footer.") && this.m_currentLevel == -1) {
                            string9 = "Footer";
                        } else {
                            this.m_blockId = null;
                            this.stopWriting();
                            return;
                        }
                    }
                }
                this.writeStartTag(string9, false);
                this.write(" layoutBlockID=\"" + string7 + "\">");
            }
            this.m_layoutId = string6;
            if (this.m_currentLine - 1 > this.m_previousLine) {
                for (int i = this.m_previousLine + 1; i < this.m_currentLine; ++i) {
                    this.write("<Line layoutLineNumber=\"" + i + "\"></Line>");
                }
            }
            this.write("<Line layoutLineNumber=\"" + this.m_currentLine + "\">");
            this.m_previousLine = this.m_currentLine;
            return;
        }
        catch (Exception exception) {
            System.out.println("Oeps startElement: " + this.m_layoutId);
        }
    }

    private void closeBlock() throws IOException {
        String string = this.getCurrentTag();
        if (string.equals("Header") || string.equals("Detail") || string.equals("Footer")) {
            int n = this.getNumberOfLinesInBlock(this.m_blockId);
            if (this.m_previousLine < n) {
                for (int i = this.m_previousLine + 1; i <= n; ++i) {
                    this.write("<Line layoutLineNumber=\"" + i + "\"></Line>");
                }
            }
            this.m_currentLine = 1;
            this.m_previousLine = 0;
            this.m_blockId = null;
            this.writeEndTag();
        }
    }

    private void writeSortGroupEnd() throws IOException {
        String string;
        this.closeBlock();
        if (this.m_sortGroupValuesBeforeFirstRowEncountered != null) {
            this.writeLeftOverSortGroups();
        }
        if ((string = this.getCurrentTag()).equals("ReportInstance") || string.equals("TopLevel")) {
            this.m_currentLevel = -1;
            return;
        }
        while (!"ChildLevel".equals(string) && !"`".equals(string)) {
            this.writeEndTag();
            string = this.getCurrentTag();
        }
        this.writeEndTag();
        this.m_block = FOOTER;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.m_readDesign) {
                super.endElement(string, string2, string3);
            }
            if (string3.equals("report")) {
                this.startWriting();
                try {
                    while (true) {
                        this.writeEndTag();
                    }
                }
                catch (Exception exception) {
                }
            } else if (string3.equals("head")) {
                this.m_readDesign = false;
                this.startWriting();
            } else if (string3.equals("sortgroup")) {
                if (!this.isWritingStopped()) {
                    if (!this.m_ignoreNextSortGroupEnd) {
                        this.writeSortGroupEnd();
                    }
                    if ("Footer".equals(this.getCurrentTag())) {
                        this.writeEndTag();
                    }
                    this.m_ignoreNextSortGroupEnd = false;
                } else {
                    --this.m_ignoreSortGroupCount;
                    if (this.m_ignoreSortGroupCount == 0) {
                        this.startWriting();
                    }
                }
                --this.m_currentLevel;
            } else if (string3.equals("row")) {
                this.write("</Line>");
                if (this.m_ignoreSortGroupCount == 0) {
                    this.startWriting();
                }
            } else if (string3.equals("e")) {
                this.write("<Value>");
                this.write(this.getCharacters());
                this.write("</Value>");
                this.stopCharacters();
                this.write("</Field>");
            }
        }
        catch (Exception exception) {
            System.out.println("Oeps endElement: " + this.m_layoutId);
        }
    }

    public static void convertBML(String string, String string2, String string3, String string4) {
        try {
            BML2CognosData bML2CognosData = new BML2CognosData();
            bML2CognosData.convert(string, string2, string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

