/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2CognosData;
import com.ssaglobal.bml.BML2CognosDesign;
import com.ssaglobal.bml.BMLConverter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BML2Cognos
extends BMLConverter {
    private String m_user;
    private String m_version;
    private String m_Id;

    public synchronized void convert(String string, String string2, String string3, String string4) throws SAXException, IOException {
        this.m_user = string;
        this.m_version = string2;
        super.convert(string3, string4);
    }

    public void writeAttribute(String string, boolean bl, Attributes attributes, String string2, String string3, boolean bl2) throws IOException {
        if (string != null) {
            if (!this.isWritingStopped()) {
                this.m_tags.push(new Object[]{string, null});
            }
            this.write("<");
            this.write(string);
            this.write(" ");
        }
        this.write(string3);
        this.write("=\"");
        if (bl2) {
            String string4 = attributes.getValue(string2);
            if ("Yes".equals(string4)) {
                string4 = "true";
            } else if ("No".equals(string4)) {
                string4 = "false";
            } else if (string4 == null) {
                string4 = "false";
            }
            string4 = string4.toLowerCase();
            if (string3.equals("alignment")) {
                string4 = string4 == null || string4.equals("") ? ("Double".equals(attributes.getValue("fldtype")) ? "right" : "left") : (string4.equals("right") ? "right" : (string4.equals("not") ? "left" : (string4.equals("centered") ? "center" : "left")));
            } else if (string3.equals("color")) {
                if (string4 == null || string4.equals("")) {
                    string4 = "#FFFFFF";
                } else {
                    Color color = Color.BLACK;
                    if (color != null) {
                        string4 = "#";
                        string4 = string4 + this.toHex(color.getRed());
                        string4 = string4 + this.toHex(color.getGreen());
                        string4 = string4 + this.toHex(color.getBlue());
                    } else {
                        string4 = "#FFFFFF";
                    }
                }
            } else if (string3.equals("id") && string4.length() > 15) {
                string4 = string4.substring(1, 3) + string4.substring(string4.length() - 12, string4.length());
                string4 = string4.trim();
                string4 = string4 + "_" + this.m_version;
                this.m_Id = string4 = string4.trim();
            }
            this.write(string4);
        } else {
            this.write(attributes.getValue(string2));
        }
        this.write("\" ");
        if (bl) {
            this.write(">");
        }
    }

    public void writeAttribute(String string, boolean bl, Attributes attributes, String string2, String string3) throws IOException {
        this.writeAttribute(string, bl, attributes, string2, string3, false);
    }

    private String toHex(int n) {
        if (n < 16) {
            return "0" + Integer.toHexString(n).toUpperCase();
        }
        return Integer.toHexString(n).toUpperCase();
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public String getUser() {
        return this.m_user;
    }

    public String getId() {
        return this.m_Id;
    }

    public static void main(String[] stringArray) {
        String string = "C:\\development\\bml\\test\\";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        BML2CognosDesign bML2CognosDesign = new BML2CognosDesign();
        BML2CognosData bML2CognosData = new BML2CognosData();
        File file2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            try {
                if (!file2.getAbsolutePath().endsWith(".xml")) continue;
                String string2 = file2.getAbsolutePath();
                String string3 = string2.substring(0, string2.length() - 4) + "_design.xml";
                String string4 = string2.substring(0, string2.length() - 4) + "_data.xml";
                if (string2.endsWith("_design.xml") || string2.endsWith("_data.xml")) continue;
                System.out.println("Converting " + string3 + "...");
                bML2CognosDesign.convert(string2, string3);
                System.out.println("Converting " + string4 + "...");
                bML2CognosData.convert("btburg", "1.0", string2, string4);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Oeps: " + file2.getAbsolutePath());
                throwable.printStackTrace();
            }
        }
    }
}

