echo "
   WARNING: This conversion can not be used for Oracle 7.X !!!

   This script is just a template of how the conversion from an Oracle 7
   data model to an Oracle 8 data model can be done.

   Alter the procedure to match your specific system settings.

   The conversion should be done on the system where the Baan/Oracle driver runs
   to ensure that the value of ORA_COLUMN_FORMAT is passed to the driver correctly.

   To convert a Baan database that complies to the Oracle7 limitations
   to a database that complies to the Oracle8 limitations
   you should export and import the tables that are listed in the table below.

   Oracle 7 limitations:
   	Max number of columns per table:		254
   	Max lenght of a CHAR column (level-2):		255
   	Max lenght of a VARCHAR2 column (level-1):	2000
   	Max lenght of a RAW column:			255

   Oracle 8 limitations:
   	Max number of columns per table:		1000
   	Max lenght of a CHAR column (level-2):		2000
   	Max lenght of a VARCHAR2 column (level-1):	4000
   	Max lenght of a RAW column:			2000

   Using the Oracle 8 limitations means, that no Baan columns have to
   be split anymore. (See Technical manual)

   The conversion should be done as:

   FOR EACH TABLE THAT NEEDS CONVERSION
   DO
   	ORA_COLUMN_FORMAT=7 bdbpre  <options>
   	ORA_COLUMN_FORMAT=8 bdbpost <options>
   DONE
"

#
#  Generate the list of Baan database tables that need to be converted.
#

List=/tmp/LL.$$
trap ' rm $List ' 0

DBA_LOGIN=system/manager

sqlplus -SILENT ${DBA_LOGIN} << !END_SQL! > $List
	set newpage	0
	set space	0
	set verify      off;
	set feedback    off;
	set heading	off
	set pagesize	0

	REM	Search for Baan tables with column names containing '#'
	REM	These columns are split according to the Oracle7 limitations
	REM	and should be converted.

	COLUMN	"Baan group" 	FORMAT A20
	COLUMN	"Table"	 	FORMAT A10

	SELECT	distinct
		owner					"Baan group",
		LOWER( SUBSTR( table_name, 2, 8 ))	"Table",
		SUBSTR( table_name, 10 )		"Company number"
	FROM	all_tab_columns
	WHERE	table_name like 'T___________'
	AND	column_name like '%#%'
	ORDER BY 1, 3, 2
/

!END_SQL!

Release=6.2

while	read Owner Table Compnr
do
	if [ "$Owner" != "$OldOwner" ]
	then
		OldOwner=$Owner
		OldCompnr=XYZ
		echo	"\n\n#Baan Group: $Owner"
	fi
	if [ "$Compnr" != "$OldCompnr" ]
	then
		OldCompnr=$Compnr
		echo	"\n#Compnr: $Compnr"
	fi

	FileName=$BSE/tmp/${Table}${Compnr}.pre

	echo "	ORA_COLUMN_FORMAT=7 bdbpre${Release}  -N $Table -C $Compnr > $FileName "
	echo "	ORA_COLUMN_FORMAT=8 bdbpost${Release} -k -f < $FileName "

done	< $List
