
/*
 * General Definitions
 * Copyright Baan Development BV
 */

#ifndef	SYSTEM_H
#define	SYSTEM_H	1


#ifndef BDB_API
#include "baandefs.h"	/* standard defines for Baan Tools */
#endif 
#if defined(WIN32) && !defined(__WIN32__)
# define __WIN32__
#endif

#ifdef	__WIN32__
# define SYSMEMFUN
# define VOID_PTR
# define INCLSTDLIB
#endif

/* HGS: it's not a policy to include system headers from within system.h.
 * However, due to the numerous problems with atof() and the nature of
 * these problems, it has been decided to include stdlib.h to system.h in
 * order to prevent these serious problems as much as possible! 
 * Note: al_alloc.c does not compile when stdlib.h is included!
 */
#ifndef MALLOC_SOURCE
#if defined(INCLSTDLIB) || defined(__WIN32__)
#include <stdlib.h>	
#endif
#endif

/* Do this unconditionally for size_t */
#include <stddef.h>

/* Include timezone header file */
#ifndef BDB_API
#include "baan_tz.h"
#endif

#if defined(__WIN32__) && (defined(__BORLANDC__) || defined(__WATCOMC__))
# ifndef __FLAT__
   ERROR Compile as a WIN32s target
# endif
#endif

#if defined(__BORLANDC__) && !defined(__STDC__)
  ERROR Compile using Borland in ANSI C mode
#endif

#ifdef __cplusplus

# define START_CFUN     extern "C" {
# define END_CFUN       }
# define CFUN           extern "C"

#else   /* __cplusplus */

# define START_CFUN
# define END_CFUN
# define CFUN

#endif  /* __cplusplus */

/*
   Use the following macro if a callback-argument is needed to suppress warnings,
   but the argument is not used (which again causes a warning
*/

#define ArgUnused( var )        ( (var) = (var) )

#define RELEASE	62

/*
	Global type definitions
*/

/*
	System dependent datatype definitions. The number of bytes should 
	match across all systems, whether 32-bit or 64-bit.
*/

#ifdef DEC_OSF_ALPHA
typedef unsigned int	bu4;
typedef signed int	bs4;
#else
typedef unsigned long	bu4;
typedef signed long	bs4;
#endif


typedef bu4		WC;		/* TSS wide character */

typedef unsigned short	bu2;
typedef unsigned char	bu1;
typedef signed short	bs2;
typedef signed char	bs1;

/*
 * USE THIS IF YOU NEED "A POINTER TO ANY TYPE"
 */

#if defined( VOIDPTR ) || defined( VOID_PTR )
typedef void	MemType;
typedef void*	MemPtr;
typedef void*	BiPointer;
#else
typedef char	MemType;
typedef char*	MemPtr;
typedef char*	BiPointer;
#endif

#ifdef INT_SIG_TYPE
typedef int	SignalType;
#else
typedef void	SignalType;
#endif

#ifndef	SIGNAL_TYPE
#define SIGNAL_TYPE	SignalType
#endif

typedef	unsigned char	UCHAR;
typedef	unsigned short	USHORT;
typedef	unsigned long	ULONG;
typedef	unsigned int	UINT;

#define	long_reg	long
#define	ulong_reg	ULONG

#ifdef __WIN32__
typedef unsigned char	BOOLEAN;
#else
typedef int		BOOLEAN;
#endif

typedef short		compnr_t;

/* Memory allocation */
#ifndef BDB_API
#include "al_alloc.h"
#endif

/* Function redefines */

#if !defined(__cplusplus)
/*
 * This does NOT work in C++ because the include order
 * of the header files cannot be garantueed !!
 */
# if ! defined( SYSMEMFUN )
#  define memcpy	baan_memcpy
#  define memset	baan_memset
#  define memcmp	baan_memcmp

BiPointer	memset	( BiPointer	str,
			  int		kar,
			  size_t	count );

BiPointer	memcpy	( BiPointer		to,
			  const BiPointer	from,
			  size_t		count );

int		memcmp	( const BiPointer	s1,
			  const BiPointer	s2,
			  size_t		n );

# endif	/* SYSMEMFUN */

#endif	/* !defined(__cplusplus) */

#ifdef __WIN32__
/*
 * Avoid a name clash with the sopen function in the MS-Windows C library
 */

# ifdef sopen
#  undef sopen
# endif
# define sopen          baan_sopen
#endif

#ifdef HP3000_900
# define sclose		baanclose
#endif

#define ATOF(str)	baan_atof( (UCHAR*) str )

#ifdef BAANSTRCMP
# ifdef strcmp
#  undef strcmp
# endif
#endif

#ifdef DEVELOP

# ifndef AL_DEVELOP_C

/* redeclare strlen */
#  undef strlen
#  define strlen(str)     al_strlen(str)

# endif /* AL_DEVELOP_C */

#endif /* DEVELOP */

#ifndef BDB_API
#include "al_proto.h"
#endif

#ifdef IBM_OS390
/* various limits, including DBL_MAX */
#include <limits.h>

/* as defined in rpc/types.h */
# define MAXHOSTNAMELEN 64
#endif /* IBM_OS390 */

/*
 * Default floating point tolerance used in Baan C software is 6 decimals
 * Since 0.000001 is not accurate enough. 1 out of 4 comparisments like
 * 9.999999<1.0 fail, 0.0000009 is used as constant for DBLTLR
 * This constant is used with double_cmp() to get the default accuracy
 */
#define DBLTLR 0.0000009

/*
 *	General definitions
 */

/* 
 * The floating point types for this local hardware
 * Give each float/double format number a unique sequence number
 */
#define FLOAT_IEEE_BIG		1
#define FLOAT_IEEE_LITTLE	2
#define FLOAT_NSK		3
#define FLOAT_OS390		4

#if defined(IBM_OS390)
#  define FLOAT_FORMAT()	FLOAT_OS390
#elif defined(TANDEM_NSK)
#  define FLOAT_FORMAT()	FLOAT_NSK
#elif defined(HIGH_LOW)
#  define FLOAT_FORMAT()	FLOAT_IEEE_BIG
#else
#  define FLOAT_FORMAT()	FLOAT_IEEE_LITTLE
#endif

#if defined(TANDEM_NSK)
#  define ROOT_USER	65535
#else
#  define ROOT_USER	0
#endif

#define	BUFSIZE		1024	/* Default buffer size		*/
#define	S_BUFSIZE	(4*1024)	/* Default stream buffer size	*/
#define	MBMAX_BUFSIZE	(5*1024)	/* Maximum buffer size of mb string */
/*
#define	IPC_BUF_SIZE	(S_BUFSIZE)
*/
#define MAXRECSIZE	3072	/* Maximum ISAM record size	*/
#define	MAX_MESQ_SIZE	2040	/* Maximun message queue bucket */

#define OSUSERNAME_SIZE	256	/* system user */
#define GROUPNAME_SIZE	256	/* system group */
#define PATHNAME_SIZE	1024	/* use this for buffers for paths */

#ifndef __WIN32__
#if defined(IBM_AS400) || defined(IBM_OS390)
#define MAX_PATH	_POSIX_PATH_MAX
#else
#define MAX_PATH	PATH_MAX
#endif
#endif

/*
 *	SRC file name defines
 */
#ifdef __WIN32__
/* skip two positions for the drive letter in __FILE__  */
#define __SRC__		__FILE__ + 2
#else
#define __SRC__		__FILE__
#endif

/*
 *	Definitions for encrypt (al_baan_crypt.c)
 */

#define	CRYPT_LEN	32
#define PASSWD_LEN	(CRYPT_LEN - 1)

/*
 *	Definitions for log functions
 */

#define TO_NULL		0000
#define TO_SET		0000
#define TO_LOG		0001
#define TO_STDERR	0002
#define TO_STDOUT	0004
#define TO_CONSOLE	0010
#define TO_LOG_SYNC	(0020|TO_LOG)

#define LOG_SHOW_ERROR	0040
#define TO_HOOK		0100
#define LOG_WARN	0200	/* Warning		*/
#define LOG_INFO	0400	/* Info			*/


#define	LOG_DEST	( TO_NULL | TO_SET | TO_LOG | TO_STDERR | TO_STDOUT | TO_CONSOLE | TO_LOG_SYNC )
#define	LOG_MODIFIERS	( LOG_SHOW_ERROR | TO_HOOK | LOG_WARN | LOG_INFO )

/*
	Table management marks
*/

#define	BEG_OF_TBL	001
#define END_OF_SEQ	002
#define	END_OF_TBL	004
#define DEL_IN_TBL	010

/*
	Definition for zero
*/

#ifndef NULL
# define NULL		0
#endif

#ifndef TRUE
# define TRUE		1
#endif

#ifndef FALSE
# define FALSE		0
#endif

/*
	Definitions for numeric handling in
	character context
*/

/*
	TANDEM_NSK can use unalligned access, but this
	is slower that shifting.
*/

#if defined(_AIX) || defined(IBM_AS400)

# define ushort_out(p)	(*((USHORT *)(p)))
# define short_out(p)	(*((short *)(p)))
# define short_in(i,p)	((*((short *)(p)))=(i))
# define ushort_in(i,p)	((*((short *)(p)))=(i))
# define ulong_out(p)	(*((ULONG *)(p)))
# define long_out(p)	(*((long *)(p)))
# define long_in(i,p)	((*((long *)(p)))=(i))
# define ulong_in(i,p)	((*((ULONG *)(p)))=(i))
# define bs4_out(p)	(*((bs4 *)(p)))
# define bu4_out(p)	(*((bu4 *)(p)))
# define bs4_in(i,p)	((*((bs4 *)(p)))=(i))
# define bu4_in(i,p)	((*((bu4 *)(p)))=(i))
# define u3b_out(p)	((*((ULONG *)(p))) >> 8)

#else /* defined(_AIX) || defined(IBM_AS400) */

#if !defined(DEC_OSF_ALPHA)

# define ushort_out(p)	((unsigned short)(((p)[0]<<8)+((p)[1]&0377)))

# ifdef DRS500
#  define short_out(p)	((short)((((char *)(p))[0]<<8)+(((char *)(p))[1]&0377)))
# else
#  define short_out(p)	((short)(((p)[0]<<8)+((p)[1]&0377)))
# endif

# define short_in(i,p)	((p)[0]=(UCHAR)((i)>>8),(p)[1]=(UCHAR)(i))
# define ushort_in(i,p)	((p)[0]=(UCHAR)((i)>>8),(p)[1]=(UCHAR)(i))


# define bs4_out(p)					\
	((bs4)((((bs4)((char *)(p))[0])<<24)+		\
	(((bs4)((UCHAR *)(p))[1])<<16)+			\
	(((UCHAR *)(p))[2]<<8)+				\
	(((UCHAR *)(p))[3]&0377)))

# define bu4_out(p)				\
 	( (bu4) ((((bu4)(p)[0])<<24) +		\
	(((bu4)(p)[1])<<16) +			\
	((p)[2]<<8) +				\
	((p)[3]&0377)) )


# define bs4_in(i,p)			\
	((p)[0]=(UCHAR)(((bs4)i)>>24),		\
	 (p)[1]=(UCHAR)(((bs4)i)>>16),		\
	 (p)[2]=(UCHAR)(((bs4)i)>>8),		\
	 (p)[3]=(UCHAR)(i))

# define bu4_in(i,p)		\
	((p)[0]=(UCHAR)(((bu4)(i))>>24),	\
	 (p)[1]=(UCHAR)(((bu4)(i))>>16),	\
	 (p)[2]=(UCHAR)(((bu4)(i))>>8),	\
	 (p)[3]=(UCHAR)(i))

#  define long_out(p)					\
	((long)((((long)((UCHAR *)(p))[0])<<24)+	\
	(((long)((UCHAR *)(p))[1])<<16)+		\
	(((UCHAR *)(p))[2]<<8)+				\
	(((UCHAR *)(p))[3]&0377)))

#  define ulong_out(p)				\
 	( (ULONG) ((((ULONG)(p)[0])<<24) +	\
	(((ULONG)(p)[1])<<16) +			\
	((p)[2]<<8) +				\
	((p)[3]&0377)) )

#  ifdef DEC_RISC

#   define long_in(i,p)	((p)[0]=(((long)i)>>24),	\
			(p)[1]=(((long)i)>>16),		\
			(p)[2]=(((long)i)>>8),		\
			(p)[3]=(i))
#  else /* DEC_RISC */

#   define long_in(i,p)	((p)[0] = (UCHAR)((i) >> 24),	\
			 (p)[1] = (UCHAR)((i) >> 16),	\
			 (p)[2] = (UCHAR)((i) >>  8),	\
			 (p)[3] = (UCHAR) (i))

#  endif /* DEC_RISC */

#  define ulong_in(i,p)	((p)[0]=(i)>>24,(p)[1]=(i)>>16,(p)[2]=(i)>>8,(p)[3]=(i))

#endif  /* ! DEC_OSF_ALPHA */

#ifdef DEC_OSF_ALPHA
/*
 *      First the algorithm,
 *      let X be 0xAABBCCDD
 *      X<<8 gives 0xBBCCDD00, the mask applied gives 0xBB00DD00
 *      X>>8 gives 0x00AABBCC, the mask applied gives 0x00AA00CC
 *      both expressions merged with a bit-or gives   0xBBAADDCC
 *      let _tmp be this intermediate result
 *      _tmp<<16 gives 0xDDCC0000,
 *      _tmp>>16 gives 0x0000BBAA,
 *      both expressions merged with a bit-or gives   0xDDCCBBAA,
 *      the result.
 *      As one can see this makes up 8 bit-operations which can directly
 *      be mapped to Alpha instructions.
 *
 *      Now the implementation,
 *      the macro implements this algorithm without the _tmp variable:
 *      the expression for the intermediate result is given twice, it is
 *      expected that the compiler recognizes identical subexpressions (and
 *      generates code only once).
 *      The casts are necessary to access any source data as unsigned long.
 *      If the compiler can't figure out the exact alignment of the data it
 *      always assumes that pointers to long point to long-aligned data.
 *      To avoid alignment traps '__unaligned' is added. If the
 *      compiler knows that the data is aligned it simply ignores this type
 *      qualifier. Otherwise it takes the unaligned data and generates a
 *      load unaligned sequence to fetch it.
 *      The data is always manipulated as long data. The masks ensure that
 *      other bits disturbing ints and shorts are suppressed.
 *      At the end the expression is casted to the wanted data type. Then
 *      necessary sign extension takes place.
 *
 *      Although this is Digital Unix and Alpha specific it is expected that
 *      other platforms will benefit from the same algorithm. Then the casts
 *      may look different.
 *
 *	Author:  14-Jul-97, Hartmut Becker, Digital Munich
 */

#define long_out( p )							\
(                                                                       \
(((                                                                     \
   (((                                                                  \
        (((*(__unaligned unsigned long*)(p))<<8) & 0xff00ff00ff00ff00)  \
        +                                                               \
        (((*(__unaligned unsigned long*)(p))>>8) & 0x00ff00ff00ff00ff)  \
     ) <<16 ) & 0xffff0000ffff0000)                                     \
   +                                                                    \
   (((                                                                  \
        (((*(__unaligned unsigned long*)(p))<<8) & 0xff00ff00ff00ff00)  \
        +                                                               \
        (((*(__unaligned unsigned long*)(p))>>8) & 0x00ff00ff00ff00ff)  \
     ) >>16 ) & 0x0000ffff0000ffff)                                     \
  ) <<32 ) & 0xffffffff00000000)                                        \
+                                                                       \
(((                                                                     \
   (((                                                                  \
        (((*(__unaligned unsigned long*)(p))<<8) & 0xff00ff00ff00ff00)  \
        +                                                               \
        (((*(__unaligned unsigned long*)(p))>>8) & 0x00ff00ff00ff00ff)  \
     ) <<16 ) & 0xffff0000ffff0000)                                     \
   +                                                                    \
   (((                                                                  \
        (((*(__unaligned unsigned long*)(p))<<8) & 0xff00ff00ff00ff00)  \
        +                                                               \
        (((*(__unaligned unsigned long*)(p))>>8) & 0x00ff00ff00ff00ff)  \
     ) >>16 ) & 0x0000ffff0000ffff)                                     \
  ) >>32 ) & 0x00000000ffffffff)                                        \
)

/* signed and unsigned are the same */
#define ulong_out( p )	long_out(p)

#define bs4_out( p )       						\
((int)  (                                                               \
         ((                                                             \
          (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00ff00)+     \
          (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff00ff)      \
          ) << 16 ) +                                                   \
         ((                                                             \
          (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00ff00)+     \
          (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff00ff)      \
          ) >> 16 )                                                     \
        ))

#define bu4_out( p )                                                	\
((unsigned int)                                                         \
        (                                                               \
         ((                                                             \
          (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00ff00)+     \
          (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff00ff)      \
          ) << 16 ) +                                                   \
         ((                                                             \
          (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00ff00)+     \
          (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff00ff)      \
          ) >> 16 )                                                     \
        ))

#define short_out( p )       						\
((short)(                                                               \
         (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00)+          \
         (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff)           \
        ))

#define ushort_out( p )       						\
((unsigned short)                                                       \
        (                                                               \
         (((*(__unaligned unsigned long*)(p)) << 8) & 0xff00)+          \
         (((*(__unaligned unsigned long*)(p)) >> 8) & 0x00ff)           \
        ))

#define long_in(i,p)							\
(*(__unaligned unsigned long*)(p))=                                     \
(                                                                       \
(((                                                                     \
   (((                                                                  \
        ((((unsigned long)(i))<<8) & 0xff00ff00ff00ff00)                \
        +                                                               \
        ((((unsigned long)(i))>>8) & 0x00ff00ff00ff00ff)                \
     ) <<16 ) & 0xffff0000ffff0000)                                     \
   +                                                                    \
   (((                                                                  \
        ((((unsigned long)(i))<<8) & 0xff00ff00ff00ff00)                \
        +                                                               \
        ((((unsigned long)(i))>>8) & 0x00ff00ff00ff00ff)                \
     ) >>16 ) & 0x0000ffff0000ffff)                                     \
  ) <<32 ) & 0xffffffff00000000)                                        \
+                                                                       \
(((                                                                     \
   (((                                                                  \
        ((((unsigned long)(i))<<8) & 0xff00ff00ff00ff00)                \
        +                                                               \
        ((((unsigned long)(i))>>8) & 0x00ff00ff00ff00ff)                \
     ) <<16 ) & 0xffff0000ffff0000)                                     \
   +                                                                    \
   (((                                                                  \
        ((((unsigned long)(i))<<8) & 0xff00ff00ff00ff00)                \
        +                                                               \
        ((((unsigned long)(i))>>8) & 0x00ff00ff00ff00ff)                \
     ) >>16 ) & 0x0000ffff0000ffff)                                     \
  ) >>32 ) & 0x00000000ffffffff)                                        \
)

/* signed and unsigned are the same */
#define ulong_in( i,p )	long_in(i,p)

#define bs4_in( i,p )       						\
        *(__unaligned int*)(p)=                                         \
         ((                                                             \
          ((((unsigned long)(i)) << 8) & 0xff00ff00)+                   \
          ((((unsigned long)(i)) >> 8) & 0x00ff00ff)                    \
          ) << 16 ) +                                                   \
         ((                                                             \
          ((((unsigned long)(i)) << 8) & 0xff00ff00)+                   \
          ((((unsigned long)(i)) >> 8) & 0x00ff00ff)                    \
          ) >> 16 )

#define bu4_in( i,p )       						\
        *(__unaligned unsigned int*)(p)=                                \
         ((                                                             \
          ((((unsigned long)(i)) << 8) & 0xff00ff00)+                   \
          ((((unsigned long)(i)) >> 8) & 0x00ff00ff)                    \
          ) << 16 ) +                                                   \
         ((                                                             \
          ((((unsigned long)(i)) << 8) & 0xff00ff00)+                   \
          ((((unsigned long)(i)) >> 8) & 0x00ff00ff)                    \
          ) >> 16 )

#define short_in( i,p )       						\
        *(__unaligned short int*)(p)=                                   \
         ((((unsigned long)(i)) << 8) & 0xff00)+                        \
         ((((unsigned long)(i)) >> 8) & 0x00ff)

#define ushort_in( i,p )       						\
        *(__unaligned unsigned short int*)(p)=                          \
         ((((unsigned long)(i)) << 8) & 0xff00)+                        \
         ((((unsigned long)(i)) >> 8) & 0x00ff)

#endif /* DEC_OSF_ALPHA */

# define u3b_out(p)	((ULONG) ((((ULONG)(p)[0])<<16) + ((p)[1]<<8) + ((p)[2]&0377)) )

#endif /* _AIX || IBM_AS400 */

#define ushort_swap(x) 							\
			(((x) << 8 ) & 0xff00) + 			\
			(((x) >> 8 ) & 0x00ff) 

#define ushort_swap(x) 							\
			(((x) << 8 ) & 0xff00) + 			\
			(((x) >> 8 ) & 0x00ff) 

#define u3b_in(i,p)	((p)[0] = (UCHAR)((i) >> 16),	\
			 (p)[1] = (UCHAR)((i) >>  8),	\
			 (p)[2] = (UCHAR) (i))

/*
** SIZES used by network library
*/
#define	SIZE_SHORT	2
#define SIZE_LONG	4
#define SIZE_FLOAT	4
#define SIZE_DOUBLE	8

/* various defines for pipe_open */

#define	P_READ		001
#define	P_WRITE		002
#define	P_SHELL		004
#define	P_SETUID	010

/* various defines for act_shell */

#define SHELL_NO_WAIT	001
#define SHELL_CLEAN	002
#define SHELL_PG	004
#define SHELL_80_COLS	010
#define SHELL_132_COLS	020

/*
 *	MAX- and MIN-values
 */

#ifndef MIN
# define	MIN(X, Y)		(((X) < (Y)) ? (X) : (Y))
#endif
#ifndef MAX
# define	MAX(X, Y)		(((X) > (Y)) ? (X) : (Y))
#endif

#define MAX_BYTE	127
#define MAX_STRING	'~'

#define MAX_SHORT	32767		/* assume 16 bit short */
#define MAX_LONG	2147483647	/* 32 bit long */

#define MAX_FLOAT	999999999999.9e20

#ifndef IBM_OS390
#define MAX_DOUBLE	999999999999.9e64
#else
/* MVS has a maximum exponent of 63.  we can get DBL_MAX from limits.h */
#define MAX_DOUBLE     DBL_MAX
#define MAXINT	 	INT_MAX
#endif

#define MIN_BYTE	0
#define MIN_STRING	((char) 1)
#define MIN_SHORT	((-MAX_SHORT) - 1)	/* -1 by EB 01-11-93 */
#define MIN_LONG	((-MAX_LONG) - 1)
#define MIN_FLOAT	(-(MAX_FLOAT))
#define MIN_DOUBLE	(-(MAX_DOUBLE))

#define	MIN_DATE	1L			/* is: 01-01-0001 */
#define	MAX_DATE	3652059L		/* is: 31-12-9999 */

#define MIN_TIME	0			/* 00:00 01 Jan 1970 */
#define MAX_TIME	MAX_LONG		/* somewhere in 2038 */

#ifdef HEBREW
# define IN		0
# define OUT		1
#endif

#ifdef __cplusplus
CFUN UCHAR	iso8859_1_lower[],
#else
extern UCHAR	iso8859_1_lower[],
#endif
		iso8859_1_upper[],
		iso8859_1_sort_table[];

#define NLS_ISLOWER(ch)		(iso8859_1_lower[iso8859_1_upper[ch]] == ch)
#define NLS_ISUPPER(ch)		(iso8859_1_upper[iso8859_1_lower[ch]] == ch)
#define NLS_TOUPPER(ch)		(iso8859_1_upper[ch])
#define NLS_TOLOWER(ch)		(iso8859_1_lower[ch])
#define NLS_CHARCMP(ch1, sh2)	(iso8859_1_sort_table[ch1] - \
					iso8859_1_sort_table[ch2])


extern unsigned int	 DEBUG_LEVEL;

/*DEBUG LEVELS	*/
/*			037777777777 : maximum value */
#define	DATA_AKTIE	00000000001
#define	OBJ_SIZE	00000000002
#define	REF_PATH	00000000004
#define DEBUG_YY	00000000010	/* debug expressions */
#define FUN_DEBUG	00000000020
#define BDB_SERVER_TYPE	00000000040	/* also defined for BDB_DEBUG */
#define BDB_DELAY_LOCK	00000000100	/* also defined for BDB_DEBUG */
#define MUL_ACTION	00000000200
#define BDB_REFER	00000000400	/* also defined for BDB_DEBUG */
#define BDB_ACTIONS	00000001000	/* also defined for BDB_DEBUG */
#define DEBUG_FILEDEV	00000002000
#define RESOURCE_DBG	00000004000
#define PRINT_ENUMS	00000010000
#define INSTR_DEBUG	00000020000	/* instructions in baan_cpu.c */
#define BCPU_DEBUG	00000040000	/* Call baan_cpu_debug	*/
#define SRDD_USAGE	00000100000
#define GET_PUT_VAR	00000200000	/* Error message on get/putvar errors */
#define SCHED_DEBUG	00000400000
#define PTY_DEBUG	00001000000	/* debug pty's */
#define DEBUG_FILE	00002000000	/* shows opened seq files */
#define DEBUG_TSS	00004000000	/* debug TSS functions */
#define SYM_DEBUG	00010000000	/* show assignments */
#define DC_DEBUG	00020000000	/* Distributed Computing functions */
#define SHOW_TRACE      00040000000	/* show stack traces */
#define DEBUG_MESG	00100000000	/* let debugger stop on ds_send_message()*/
#define SHOW_FLOW	00200000000	/* show 3GL program flow */
#define SOCK_DEBUG	00400000000	/* debug socket-acties */
#define DEBUG_JVMI	01000000000	/* Debug JVMI interactions within Bshell */
#define	DEBUG_AMS	04000000000	/* Debug AMS */

/* Defines for SQL functions */

#define FUNC_SQL_ERROR		1
#define FUNC_SQL_BIND		2
#define FUNC_SQL_HANDLE_STAR	3
#define FUNC_SQL_EXTERN		4
#define FUNC_SQL_CRT_EXTVAR	5
#define FUNC_SQL_GET_EXTVAR	6
#define FUNC_SQL_PUT_EXTVAR	7
#define FUNC_SQL_WHERE_USED	8
#define	FUNC_SQL_UPDATE		9


/* Fixed Where Used Levels for BIC and SQL */

#define WUSED_INCLUDE   1
#define WUSED_TABLE     2
#define WUSED_COLUMN    3
#define WUSED_DOMAIN    4

/* Macros to handle BIT MASKS */
#define MASK_BITS               (sizeof(ULONG) * 8)
#define MASK_SET(N)             (mask[(N) / MASK_BITS] |= \
					(1 << ((N) % MASK_BITS)))
#define MASK_TEST(N)            (mask[(N) / MASK_BITS] &  \
					(1 << ((N) % MASK_BITS)))
#define MASK_DECL(name, size)   ULONG   name[size/MASK_BITS]
#define MASK_CLEAR(name)        memset((char *) name, '\0', sizeof(name))

/* determine number of digits */
#define NDIGITS(N) (((N) < 0 ? (int) log10((double) -(N)) :\
			(int) log10((double) (N))) + 1)

/* Structure-member macro's (borrowed from Xt-toolkit) */

#define DsSizeof(type,field)	sizeof( ( (type*) NULL )->field )

#ifdef IBM_AS400
/* avoid casting integer to a pointer */
#define DsOffset(p_type,field)  offsetof(*(p_type)"", field)
#else
#define DsOffset(p_type,field)\
	((unsigned int)(((char *)(&(((p_type)NULL)->field))) - ((char *)NULL)))
#endif

#define DsOffsetOf(s_type,field) DsOffset(s_type*,field)
#define DsNumber(arr)	(sizeof(arr) / sizeof(arr[0]))

#define	LFILELINE	log_mesg(__FILE__, __LINE__, "fileline", TO_SET, "");
#define	FILELINE	fprintf(stderr, "%s:%d\n", __FILE__, __LINE__);

#if defined(TANDEM_NSK)
/*
 * Tandem has a XPG 4 call interface and the
 * following macro's solve missing functions and 
 * portibility issues. The implementation can be
 * found in al_port.c
 */
#  include <sys/types.h>
#  define sbrk		tdm_sbrk
	char*		tdm_sbrk(long);
#  define write		tdm_write
#  define read		tdm_read
	ssize_t		tdm_write(int, const void *, size_t);
	ssize_t		tdm_read(int, void *, size_t);
#  define gethostname	tdm_gethostname
#  define O_NDELAY	O_NONBLOCK
#  define SIGCLD	SIGCHLD

#  define geteuid()	((geteuid() == (uid_t) ROOT_USER) ? \
				(uid_t) 0 : geteuid())
#  define getuid()	((getuid() == (uid_t) ROOT_USER)  ? \
				(uid_t) 0 : getuid())
#  define getpwuid(U)	getpwuid((U)==0 ? ROOT_USER : (U))
#endif


#ifndef SEP_CHAR
# define SEP_CHAR	'!'	/* also defined in ipclib.h */
#endif

#define SETERRNO(E)            errno = E
#define GETERRNO()             errno

#ifndef BDB_API
# include "hal.h"
#endif

#ifdef __WIN32__
#  define PATH_SEPARATOR ';'
#  define PATH_SLASH	'\\'
#else
#  define PATH_SEPARATOR ':'
#  define PATH_SLASH	'/'
#endif

#ifdef __WIN32__

# ifdef close
#  undef close
# endif

# define 	close		win_close	/* Required because of locking	*/

/* redefines for some Windows functions (counterpoint of the ANSI variants) */
# define	access		_access
# define	getpid		_getpid
# define	pclose		_pclose
# define	pipe		_pipe
# define	popen		_popen
# define	putenv		_putenv
# define	sleep(t)	Sleep((t)*1000)
# define	snprintf	_snprintf
# define	umask		_umask

#else	/* __WIN32__	*/
#ifdef BAANSNPRINTF
#define snprintf	portable_snprintf
#endif

# define closesocket(fd)	close( fd )

#ifdef MT_ENABLED
#include "tslib.h"
#include "mtsafe.h"
#endif

#endif	/* __WIN32__	*/

/* Include library function mapping header for ASCII-EBCDIC conversion layer */
#ifdef EBCDIC
#include "al_ebcdic.h"
#endif

#ifdef IBM_OS390
#include <sys/types.h>		/* because bpaunix.h requires pid_t */
#include <bpaunix.h>		/* Process Manager include file */

#endif

#if defined (IBM_OS390) && defined(V2R6)

/* On OS/390 V2R6 we have seen a memcpy problem, where a request to
 * copy 0 (zero) bytes copied 1 byte anyway. This happens when memcpy
 * has internal linkage. The internal linkage is set up by the next
 * remapping in /usr/include/string.h :
 *
 *  #pragma linkage(__memcpy,builtin)                                           
 *  void * __memcpy (void *, const void *, size_t);                             
 *  #define memcpy(x,y,z) __memcpy(x,y,z) 
 *
 * Because system header files are always included before the Baan 
 * system.h file we can just avoid the problem by using the nonbuiltin
 * C runtime memcpy function (using #undef)
 */

#ifdef memcpy
#undef memcpy
#endif

#endif

#ifdef IBM_AS400
/* The next two lines refer to data that is available in the
 * ILE/C runtime but is not externalized in the system header files
 * for some reason.
 */
extern char* optarg;
extern int optind, opterr, optopt;

/* mapping signal()/raise() family to sigaction()/kill() */
#define signal(a,b)	signal_as400(a,b)
#define raise(a)	raise_as400(a)

void 	(*signal_as400 ( int, void (*)(int) )) (int);
int 	raise_as400 ( int );

/* Get the library and program name of an IFS or QSYS pgm path name */
int SetUpQualifiedObjName(const char *link, char *append, char *buffer);
int submitJob(char *pgmPath, char **argv);
int giveDesc(int);
int sendChildInfo(int, int);
void libSlashObj(char *, char *);
#endif

/* Before we used teraspace on AS/400, we had a problem comparing pointers that were from different 16M segments,
 * so this check was added in several places to make sure that the pointers are
 * pointing to the same 16M segment before comparing the pointers 
 * In the future this check may be needed on other platforms, so we leave it over here,
 * in stead of cleaning up all places were this define was used.
 */

#define ISSAMESEGM(a,b) (1)
#define ISDIFFSEGM(a,b) (0)

#endif	/* SYSTEM_H */

