/* qc_iface.h */


#ifndef _QP_IFACE_H
#define _QP_IFACE_H

#ifndef BDB_API
#include "c_compnr.h"
#endif

/*
 * Defines
 */

/*
	SQL action types as returned by sql_action_type().
*/
#define SQL_UNKNOWN_ACTION	0
#define SQL_SELECT_STATEMENT	1
#define SQL_UPDATE_STATEMENT	2
#define SQL_DELETE_STATEMENT	4 

/*
 * Types
 */

typedef	int	(*SqlFunc)	( void );

typedef	union
{
	char	*s;
	long	l;
	double	d;
} SqlVal;

typedef struct	_qpc_sql_top	*SqlId;

/*
 * Function prototypes
 */

void	sql_error	( char *fmt, ... );

void	init_qpc_debug		( void );

void	qpc_change_tt_sql_trace ( int	change,
				  int	new_value );

void	qpc_unset_header	( void );

SqlFunc	sql_init_func		( int	  code,
				  SqlFunc func );

SqlId	sql_parse		( char	*select,
				  int	trans_id,
				  int	mode );

int	sql_sel_bind		( SqlId	sqlId,
				  char	*varname,
				  char	*sym );

int	sql_wh_bind		( SqlId sqlId,
				  char	*varname,
				  int	bdb_type,
				  int	size,
				  SqlVal *value );

int	sql_bind_input		( SqlId		sqlId,
				char		*varname,
                int		bdb_type,
                int		size,
                SqlVal	*value );

int	sql_set_rds_full	( SqlId	sqlId,
				  int	rds_full );

int	sql_set_timeout		( SqlId sqlId, 
				  int timeout_in_seconds );

int	sql_exec		( SqlId	sqlId,
				  compnr_t	compnr );

int	sql_retry		( SqlId	sqlId );
int	sql_query_with_rpoint	( SqlId	sqlId );
int	sql_save_rpoint		( SqlId	sqlId );
int	sql_fetch		( SqlId	sqlId );
int	sql_break		( SqlId	sqlId );

int	sql_get_error		( SqlId	sqlId,
				  int	*err_no,
				  char	**err_msg );

int	sql_close		( SqlId	sqlId );

int	sql_close_all		( void );
void	sql_where_used		( char *name, int mode );
int	sql_set_rds_full 	( SqlId sqlId, int rds_full );

char	*sql_action		( int action );
int	sql_action_type		( SqlId	sqlId );

long	sql_set_prof_qid		( SqlId sqlId, long prof_qid );
long	sql_get_prof_qid		( SqlId sqlId );

int sql_query_check(char *query, int mode);

#endif	/* _QP_IFACE_H */
