/* dbc library - public functions */

#ifndef C_PUBL_H
#define C_PUBL_H

#include "c_compnr_t.h"

/*
	Return codes of bdb_alter_table
*/

typedef enum {
	BDBAlterTableError = -1,
	BDBAlterTableOk = 0,
	BDBAlterTableOkNoAction = 1,
	BDBAlterTableNotAtomic = 2,
	BDBAlterTableNotPossible = 3
} BDBAlterTableResult;

/*
	Modes for bdb_alter_table
*/
typedef enum {
	BDBAlterTableModeCheck = 1,
	BDBAlterTableModeAtomic = 2,
	BDBAlterTableModeNotAtomic = 3
} BDBAlterTableMode;

int		bdb_logon		( char *logonname );
int		bdb_logoff		( void );

bu4		bdb_start_session	( char *session_name );
int		bdb_stop_session	( bu4 trans_id );

int		bdb_open ( BDB_MAIN_CURSOR **cursor, char *table_name, int customer_number,
		BDB_U_ABIND *u_abind, int no_binds, bu4 trans_id );
int		bdb_close ( BDB_MAIN_CURSOR *main_curs );
int		bdb_set_default_compnr( BDB_MAIN_CURSOR *main_cursor, compnr_t compnr );
int		bdb_set_default_query_timeout( bu4 trans_id, int timeout );

UCHAR	*bdb_bind_to_buf	( BDB_MAIN_CURSOR *mcurs, UCHAR *buf );
int		bdb_buf_to_bind		( BDB_MAIN_CURSOR *mcurs, UCHAR *buf );

int		bdb_exec_row ( BDB_MAIN_CURSOR *main_cursor, ULONG com_code,
		long arg, compnr_t compnr );

int		bdb_exec_table ( BDB_MAIN_CURSOR *main_cursor, long com_code,
		ULONG *arg, compnr_t compnr );
BDBAlterTableResult bdb_alter_table(BDB_MAIN_CURSOR *mainCursor, compnr_t compnr, int ignoreDomCons, BDBAlterTableMode alterMode);

int		bdb_exec_db ( long com_code, bu4 trans_id );

int		bdb_flush(bu4 trans_id);

char	*bdb_row_action		( long command );
char	*bdb_table_action	( long command );
char	*bdb_db_action		( long command );

void	reset_bdb_msg		( void );
char	*get_bdb_msg		( void );

int		bdb_get_bdb_errno ( void );
int		bdb_get_detail_error ( char **tname, compnr_t *compnr, char **extra, bu4 trans_id );
compnr_t bdb_get_physical_compnr (char *table_name, compnr_t logcompnr);

char	*bdb_domain_check ( DD_TABLE *dd_table, UCHAR *row );

int		bdb_permission ( BDB_MAIN_CURSOR *cursor, compnr_t compnr,
		DD_COLUMN *column, UCHAR *row );

int		init_dlock_offset ( BDB_CURSOR *cursor, ULONG id );
int		put_dlock_row ( BDB_CURSOR *cursor, UCHAR *row );
void	put_dlock_in_row ( DD_TABLE *table, UCHAR *row, long id );

int		bdb_determine_row_cursor ( BDB_CURSOR **cursor,
		BDB_MAIN_CURSOR *main_curs );

compnr_t bdb_compnr_from_cursor ( BDB_MAIN_CURSOR *cursor );

char bdb_user_info_get_language();
char *bdb_user_info_get_locale(char *locale);
char *bdb_user_info_get_package_combination(char *package_combination);
char *bdb_user_info_get_timezone(char *timezone);
char *bdb_user_info_get_user_name(char *user_name);
char bdb_user_info_get_user_type();

#endif /* C_PUBL_H */
