/*
 * Database actions
 * Copyright 1990-1997 Baan Development BV
 */

#ifndef DB_ACTIONS_H
#define	DB_ACTIONS_H	1

#include "system.h"
#include "bdberrno.h"
#if QPC_LIB
#include "datadict.h"
#endif

/*
	Row actions (start with 100 to avoid conflict with orig. codes 
*/
#define FUNC_BFRD_OFFSET	100
#define DB_ACT_INSERT		101
#define DB_ACT_DELETE		102
#define DB_ACT_UPDATE		103
#define DB_ACT_REFCNT		104
#define DB_ACT_REFRESH		105
#define DB_ACT_COMPLEX_DEL	106
#define DB_ACT_COMPLEX_UPD	107
#define DB_ACT_READ		108

/*
	Table commands:
*/
#define	DB_CREATE_INDEX		1
#define	DB_DROP_INDEX		2
#define	DB_CHANGE_ORDER		3	/* not used */
#define	DB_CREATE_TABLE		4
#define	DB_CLEAR_TABLE		5
#define	DB_DROP_TABLE		6
#define	DB_LOCK_TABLE		7
#define	DB_NR_ROWS		8
#define	DB_CLEAR_REFCNT		9
#define	DB_ALTER_TABLE		10

#define	DB_TABLE_LOAD_START	11
#define	DB_TABLE_LOAD_END	12
#define	DB_TABLE_STATS		13

#define MAX_TABLE_ACTION	13

/*
	Flag for CREAT_TABLE
*/
#define	CRT_NORMAL		0
#define	CRT_NO_INDEX		1

/*
	Flag for DROP_TABLE
*/
#define	DROP_NORMAL		0
#define	DROP_WITH_BACKUP	1

/*
	Flag for CREAT_INDEX
*/
#define	CRT_ALL_INDEXES		9999

/*
	Flag for read_equal
*/
#define	DB_READ_EQ_NO_LOCK		0
#define	DB_READ_EQ_LOCK			1
#define	DB_READ_EQ_REF_LOCK		2

#define DB_READ_EQ_CHK_RESTR_DEL	3 /* check if row is restricted via any restricted reference, for delete */
#define DB_READ_EQ_CHK_RESTR_UPD	4 /* check if row is restricted via any restricted reference, for update */

#define DB_READ_EQ_CHK_COUNTER_ONLY_DEL	5 /* check the delete counter if any counter restricted reference exists */
#define DB_READ_EQ_CHK_COUNTER_ONLY_UPD	6 /* check the update counter if any counter restricted reference exists */

#define	DB_READ_EQ_CHK_ALLREF_DEL	7 /* check if row is referenced via any reference, for delete */
#define	DB_READ_EQ_CHK_ALLREF_UPD	8 /* check if row is referenced via any reference, for update */

/*
	Flag for CLEAR_TABLE
*/
#define	CLEAR_WITH_ROLLBACK	0
#define	CLEAR_NO_ROLLBACK	1

/*
	Flag for DROP_TABLE
*/
#define	IGNORE_ALL_REFS		1024	/* > 1000 for distinguishing from 
					   compnr	*/

/*
	Flag for LOCK_TABLE
*/
#define BDB_USER_LOCK			0	/* original situation */
#define BDB_LOCK_FOR_DROP_TABLE		1
#define BDB_LOCK_FOR_CLEAR_TABLE	2
#define DB_USER_LOCK			0	/* original situation */
#define DB_LOCK_FOR_DROP_TABLE		1
#define DB_LOCK_FOR_CLEAR_TABLE		2

/*
	DB commands:
*/
#define	COMMIT_TRANSACTION		1
#define	SET_TRANSACTION_READONLY	2
#define	ABORT_TRANSACTION		3
#define	PREPARE_COMMIT			4
#define	TRANSACTION_NOT_ACTIVE		5
#define START_TRANSACTION		6
#define AUDIT_COMMIT_TABLE_ACTION	7
#define AUDIT_ABORT_TABLE_ACTION	8
#define	FLUSH				9			/* 6.1c only */

/* Count of the DB Commands above */
#define MAX_DB_ACTION			9
/*
	System commands (server)
*/
#define	SERVER_SETENV			1
#define	SERVER_SET_DD_MODE		2
#define	SERVER_LOCK_DB			3
#define	SERVER_CHECK_VERSION		5	
#define	SERVER_SEND_SERVER_INFO		6
#define SERVER_INVALIDATE_DD		8

/*
	System commands (session)
*/
#define	SESSION_INIT_2PHASE		1
#define	SESSION_NEW_SESSION_NAME	2
#define	PATH_LEN	128


/* maximum number of schedule signal to schedule server out */
#define	MAX_SCHEDULE_COUNT		3

/*
	Mode for detach session
*/
#define DETACH_ONLY_SESSION		1
#define DETACH_AND_CLOSE_SESSION	2

#define BDB_DEFAULT_COMPNR		-1

/*
	definitions for refer_func options
*/
#define	BDB_CHK_REFER		1
#define	BDB_REC_DEL		2	/* lock */
#define	BDB_REC_UPD		3	/* lock */
#define	BDB_LOCK_REC		4	/* lock */
#define	BDB_PRINT_ROW		5

/*
	Bit pattern to define Absolute mode for ref counter updates
*/
#define	ABS_REFCNT_MODE			0x1

/*
	Macro's for Absolute mode of refcounters
*/
#define	DB_REFCNT_IN( x )	( x * 2 )
#define DB_REFCNT_OUT( x )	( x / 2 )
#define DB_REFCNT_ADD( x, y )	( x += ( y * 2 ) )
#define DB_SET_ABS_MODE( x ) 	( x |= ABS_REFCNT_MODE )

/*
	Levels for permissions
*/
#define	PLEV_COL_DATA_CNUM	1	/* aabdb000.int:222 cond*/
#define	PLEV_COL_DATA		2	/* aabdb000.int:* cond	*/
#define	PLEV_COL_CNUM		3	/* aabdb000.int:222	*/
#define	PLEV_COL		4	/* aabdb000.int:*	*/
#define	PLEV_DATA_CNUM		5	/* aabdb000:222: cond	*/
#define	PLEV_DATA		6	/* aabdb000:*: cond	*/
#define	PLEV_TBL_CNUM		7	/* aabdb000:222		*/
#define	PLEV_TBL		8	/* aabdb000:*		*/
#define	PLEV_MOD_CNUM		9	/* aabdb:222		*/
#define	PLEV_MOD		10	/* aabdb:*		*/
#define	PLEV_PC_CNUM		11	/* aa:222		*/
#define	PLEV_PC			12	/* aa:*			*/
#define	PLEV_AP_CNUM		13	/* *:222		*/
#define	PLEV_AP			14	/* *:*			*/

/*
	Permissions	( type is char )
*/
#define	NO_PERMISSION		1
#define	PERM_READ		2
#define	PERM_MODIFY		4
#define	PERM_WRITE		8
#define	PERM_DELETE		16
#define	NO_RESTRICTION		(PERM_READ|PERM_MODIFY|PERM_WRITE|PERM_DELETE)
#define PERM_UNKNOWN		32
#define NO_PERM_DEFINED		64



typedef struct	_two_phase	{
	char	c_2phase[PATH_LEN],
		bse[PATH_LEN],
		logname[21];
	USHORT	uid,
		euid,
		gid,
		egid;
} TWO_PHASE;

/* debugging options for BDB_DEBUG */

#define DBG_SERVER_TYPE	00001
#define DBG_ACTIONS	00002
#define DBG_DELAY_LOCK	00004
#define DBG_REFER	00010
#define DBG_2PHASE	00020
#define DBG_MBSTORE	00040
#define DBG_PERMISSION	00100
#define DBG_TABLES      00200


/* value for COMMU_TABLE.refmode */

#define UPD_RESTRICTED		0001
#define DEL_RESTRICTED		0002

/* value for COMMU_ROW_CNTR.arg */
/* WARNING: These values are also defined in bic_global -> don't change ! */

#define DB_RETURN_ERROR		000001
#define DB_EXIT_ON_NOREC	000002
#define DB_SKIP_NOREC		000004
#define DB_EXIT_ON_DUPL		000010
#define DB_SKIP_DUPL		000020
#define DB_EXIT_ON_ROWCHANGED	000040
#define DB_SKIP_ROWCHANGED	000100
#define DB_WAIT_WHEN_LOCKED	000200
#define DB_INC_REFCNT		000400 /* DB_REFCNT_51: if set: refcnt++, */
#define DB_DEC_REFCNT		001000 /* DB_REFCNT_51: if set: refcnt--, */
			/* if both are set: set to zero */
#define DB_REF_UPD		002000 /* restricted delete */
#define DB_REF_DEL		004000 /* restricted update */
#define DB_RETURN_NOREC		010000
#define DB_RETURN_DUPL		020000
#define DB_RETURN_ROWCHANGED	040000
#define DB_RETURN_REF_NOT_EXISTS 0100000
#define DB_CHECK_IGNORED_REF	 0200000
#define DB_CHECK_ROWCHANGE 	 0400000
#define DB_PHYS_LOCK_DONE	01000000	/* rec already phys locked
						   (p.e. by table lock */
#define DB_SRV_CHECK_PERM	02000000 /* server should check permission */
#define DB_SRV_CHECK_RUNTIME	04000000 /* server should check runtime ref's */
#define DB_SRV_UPD_REFC		010000000 /* server handles refc operations */
#define DB_RETURN_REF_EXISTS	020000000 

#define DB_FLUSH_CONDITION	(DB_RETURN_NOREC|DB_RETURN_DUPL| \
				 DB_RETURN_ROWCHANGED|DB_RETURN_ERROR| \
				 DB_RETURN_REF_NOT_EXISTS|DB_RETURN_REF_EXISTS)

#define DB_RETURN_CONDITION	(DB_RETURN_NOREC|DB_RETURN_DUPL| \
				 DB_RETURN_ROWCHANGED|DB_RETURN_ERROR| \
				 DB_RETURN_REF_NOT_EXISTS|DB_RETURN_REF_EXISTS)


#define DUB_INSERT		1
#define DUB_DELETE		2
#define DUB_UPD_OLD		3
#define DUB_UPD_NEW		4
#define DUB_REFCNT		5
#define	DUB_COMPLEX_DEL		6
#define	DUB_COMPLEX_UPD_NEW	7
#define	DUB_REFRESH		8
#define DUB_CLEAR_TABLE		9
#define DUB_DROP_TABLE		10

#endif /* DB_ACTIONS_H */
