/* @(#) $RCSfile: baan_tz.h $ $Revision: /main/2 $ */

#ifndef BAAN_TZ_H
#define BAAN_TZ_H        1

#include <time.h>

/* Prototypes for timezone functions */

int		baan_timezone_is_valid( char *timezoneValue );
void		baan_timezone_set( char *timezoneValue );
struct tm	*baan_localtime(time_t *);
size_t		baan_strftime(char *, size_t, char *, struct tm *);
time_t		baan_mktime(struct tm *);
char		*baan_asctime(struct tm *timeptr);
char		*baan_ctime(time_t *);
struct tm	*baan_gmtime(time_t *);
time_t		baan_timegm(struct tm * tmp);
time_t		baan_timelocal(struct tm *);
void		baan_tzset(void);
double		baan_difftime(time_t, time_t);

/* Global variables */

/*
 * Do not remap timezone to baan_timezone.
 * This causes problems with struct timezone.
 */

extern	long	baan_timezone;	/* Defined in general/lib/tz/localtime.c */
extern	int	baan_daylight;	/* Defined in general/lib/tz/localtime.c */
extern	char*	baan_tzname[2];	/* Defined in general/lib/tz/localtime.c */

/* re-map system timezone functions to Baan's own functions */

#ifndef BAAN_TZ_LIB	/* Don't remap in library itself */

#define localtime( X)           baan_localtime( X)

#ifdef strftime		/* in case it's a macro e.g. IBM_OS390 */
#undef strftime
#endif
#define strftime( W, X, Y, Z)   baan_strftime( W, X, Y, Z)

#define mktime( X)              baan_mktime( X)

#ifdef asctime		/* in case it's a macro */ 
#undef asctime
#endif
#define asctime( X)             baan_asctime( X)

#ifdef ctime		/* in case it's a macro */ 
#undef ctime
#endif
#define ctime( X)               baan_ctime( X)
#define gmtime( X)              baan_gmtime( X)
#define timegm( X)              baan_timegm( X)
#define tzset()                 baan_tzset()

#ifdef difftime 	/* in case it's a macro e.g. IBM_OS390 */
#undef difftime
#endif
#define difftime( X, Y)         baan_difftime( X, Y)

#endif /* BAAN_TZ_LIB */

#endif /* BAAN_TZ_H */

