#ifndef _ARG_H
#define _ARG_H

#define CHAR_ARG	 1
#define SHORT_ARG	 2
#define USHORT_ARG	 3
#define INT_ARG		 4
#define UINT_ARG	 5
#define LONG_ARG	 6
#define ULONG_ARG	 7
#define STRING_ARG	 8
#define STRINGP_ARG	 9
#define FLAG_ARG	10
#define FUN_ARG		11	/* Function without arguments fun() */
#define FUNX_ARG	12	/* Function with argument fun(char *arg) */
#define SETENV_ARG	13

typedef struct {
	char    *name;
	int     type;
	void    *arg;
	ULONG   flag;
} ARGLIST;

int	parse_arguments		( int		argc,
				  char		**argv,
				  ARGLIST	*arglist );

int	string2argv		( char 		*string, 
				  int		maxargs,
				  char 		**argv,
				  int		*argc);

#endif
