/************************************************
 * File:   al_msltapi.h				
 * Author: Fritz Berzales			
 *         Chun Zhang				
 *						
 * Date:   01-10-1998					  
 *						
 * Description: Required defines for CSMQ
 *				Distributed to users
 ************************************************/

#ifndef __MSLTAPI_H
#define __MSLTAPI_H
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* String sizes */
#define	STR512	512
#define	STR1K	1024
#define	STR4K	4096
#define	STR8K	8192	
#define	STR16K	16384	

/* API error codes */

#define FUNCTION_NOT_FOUND	-8

/* Return index */
#define RET_INDEX			1

/* defines for convertions to unicode */
#define STR 0
#define CHR 1

/* Function pointers for calls into user code */
typedef int  (*INIT_API)();
typedef void (*TERMINATE_API)();
typedef void (*PROCESS_ARGS)(int, char**);
typedef int  (*PROCESS_ACTION_MESSAGE)(char*, int, int);

/****************************************************************
 * Function ProtoTypes
 ****************************************************************/
int     cs_send_params(int, int, int, char*, ...);
void 	cs_start_api(int, char**);
void    cs_api_log_write(char*, char*, int);
int		cs_get_next_field(char*);
void	cs_set_user_funcs(INIT_API, TERMINATE_API, PROCESS_ARGS,
			  PROCESS_ACTION_MESSAGE);
int 	cs_tssmbc2unicode(wchar_t*, char*);			/* + */
int 	cs_tssmbs2unicode(wchar_t**, char*);		/* + */
int		cs_tssunicode2extmbs(char*, wchar_t*, int);	/* + */

int		cs_tssunicode2tssmbs(char**, wchar_t*, int);
int		cs_tssextmbs2unicode(wchar_t*, char*);

/****************************************************************
 * DLL wrapper prototypes when building on NT
 ****************************************************************/
#ifdef _WIN32
int     csmqdll_send_params(int, int, int, char*, ...);
void 	csmqdll_start_api(int, char**);
void    csmqdll_api_log_write(char*, char*, int);
int		csmqdll_get_next_field(char*);
void	csmqdll_set_user_funcs(INIT_API, TERMINATE_API, PROCESS_ARGS,
			       PROCESS_ACTION_MESSAGE);
int 	csmqdll_tssmbc2unicode(wchar_t*, char*);			/* + */
int 	csmqdll_tssmbs2unicode(wchar_t**, char*);			/* + */
int		csmqdll_tssunicode2extmbs(char*, wchar_t*, int);	/* + */

int		csmqdll_tssunicode2tssmbs(char**, wchar_t*, int);
int		csmqdll_tssextmbs2unicode(wchar_t*, char*);
#endif
