#include <stdio.h>
#ifdef EBCDIC
#include "al_ebcdic.h"
#endif

extern int	ci_errno;

long	set_glong();
long	get_glong();
char	*ret_gname();

#define CHECK( X )	{						\
	if ( ci_errno ) {						\
		fprintf( stderr, "Function call %s failed, ci_errno: %d\n", \
		X, ci_errno );						\
	}								\
}

main( argc, argv)
int	argc;
char	*argv[];
{
	long	f,s;
	char	name[1024];
	char	*ptr;
	char	*hello();

#ifdef EBCDIC
	__argvtoascii_a(argc,argv);
#endif

	/* Start C-interface */
	start_ci( argv[0] );

	/* ---------------------------------------------------------------- */

	sprintf( name, "Uno" );
	set_gname( name );
	CHECK( "set_gname()" );

	/* ---------------------------------------------------------------- */

	memset( name, ' ', sizeof(name) );
	name[1023] = '\0';

	get_gname( name );
	CHECK( "get_gname()" );

	printf( "name: '%s'\n", name );

	/* ---------------------------------------------------------------- */

	f = 111L;
	s = set_glong( f );
	CHECK( "set_glong()" );
	printf( "return value of set_glong( 111 ): %ld\n", s );

	/* ---------------------------------------------------------------- */

	f = s = 0;
	f = get_glong( &s );
	CHECK( "get_glong()" );
	printf( "return value of get_glong( &s ): %ld value of s: %ld\n",
		f, s );

	/* ---------------------------------------------------------------- */

	hello();
	CHECK( "hello()" );

	if ( ! ci_errno ) {
		printf( "Global string set to 'Hello'\n" );
	}

	/* ---------------------------------------------------------------- */

	ptr	= ret_gname();
	CHECK( "ret_gname()" );

	if ( ! ci_errno ) {
		printf( "ret_gname() returns: '%s'\n", ptr );
	}

	/* ---------------------------------------------------------------- */

	/* Stop C-interface */
	stop_ci();
}
