/*************************************************************************
* File: ddc_tools.h
*
* This file declares structures and definitions for use by the ddc_driver
*
*************************************************************************/

#define DBG_MSG_1	"Form header function server:  "
#define DBG_MSG_2	"Form header function name:  "
#define DBG_MSG_3	"Form header update mode:  "
#define DBG_MSG_4	"Form header trans prefix:  "
#define DBG_MSG_5	"Field "
#define DBG_MSG_6	" prompt:  "
#define DBG_MSG_7	" ptype:  "
#define DBG_MSG_8	" pvalue:  "
#define DBG_MSG_9	" pseqnr:  "
#define DBG_MSG_10	" param.length:  "
#define DBG_MSG_11	" decimals:  "
#define DBG_MSG_12	" justify:  "
#define DBG_MSG_13	" zerofill:  "
#define DBG_MSG_14	" param.type:  "
#define DBG_MSG_15 	" listid:  "
#define DBG_MSG_16	" error message:  "
#define DBG_MSG_17	" onetime field:  "
#define DBG_MSG_18	" field prefix:  "
#define DBG_MSG_19	" bitmask:  "
#define DBG_MSG_20	" template:  "
#define DBG_MSG_21	" update mode:  "
#define DBG_MSG_22	" max retry:  "
#define DBG_MSG_23	"Comb.field - field id:  "
#define DBG_MSG_24	"Comb.field - trans.prefix:  "
#define DBG_MSG_25	"Comb.field - seq.number:  "
#define DBG_MSG_26	"Submenu ident is:  "
#define DBG_MSG_27	"Submenu description is:  "
#define DBG_MSG_28	"Menu structure for group:  "
#define DBG_MSG_29	"BOGUS entry with no function or menu!!"
#define DBG_MSG_30	"List was started - "
#define DBG_MSG_31	"Listid - "
#define DBG_MSG_32	", list element - "
#define DBG_MSG_33	"action - "
#define DBG_MSG_34	"List was repeated - "
#define DBG_MSG_35	"List time was - "
#define DBG_MSG_36	"List type was - "

#define MENU_NUM_PARMS	8
#define FUNC_NUM_PARMS	25
#define REQU_NUM_PARMS	14
#define REPL_NUM_PARMS	14
#define NUMB_NUM_PARMS	4
#define LSTA_NUM_PARMS	6
#define ELEM_NUM_PARMS	5
#define LEND_NUM_PARMS	6
#define INIT_NUM_PARMS	4
#define LSTR_NUM_PARMS	5
#define COMB_NUM_PARMS	7
#define LICE_NUM_PARMS	5

#define LOGGING_OFF     0
#define LOGGING_ON      1

#define DRIVER_SENT     1
#define DRIVER_REC      2
#define DRIVER_CNT	3
#define DRIVER_ERR	4

#define DRIVER_SENT_TXT "Driver sent:  "
#define DRIVER_REC_TXT  "Driver received:  "
#define DRIVER_CNT_TXT	"                  "
#define DRIVER_ERR_TXT  "Driver message:  "

#define LVF_ACTION_NUMRECS	1  /* Get number of records for lvf. */
#define LVF_ACTION_ADDELEM	2  /* Add an element to a lvf.       */
#define LVF_ACTION_ADDLVF	3  /* Add a new lvf to lvflist.      */
#define LVF_ACTION_REMLVF	4  /* Remove an lvf from lvflist.    */

#define TRAN_ACTION_REMOVE	1  /* Remove a transaction from reqlist. */
#define TRAN_ACTION_ADD		2  /* Add a transaction to reqlist.      */
#define TRAN_ACTION_LOOKUP	3  /* Look for a transaction in reqlist. */

#define MSG_FORMAT_1	1	/* str1, str2, str3             */
#define MSG_FORMAT_2	2	/* str1, str2, val1             */
#define MSG_FORMAT_3	3	/* str1, str2, val1, str3, str4 */
#define MSG_FORMAT_4	4	/* str1, str2, val1, str3, val2 */
#define MSG_FORMAT_5    5	/* str1, str2                   */
#define MSG_FORMAT_6	6	/* str1, str2, str3, str4       */
#define MSG_FORMAT_7	7	/* str1, str2 - without \n      */
#define MSG_FORMAT_8	8	/* str1, val1                   */

#define NUM_INIT_LVFS	100     /* Size to initialize lvflist.      */
#define NUM_INIT_TRANS	100     /* Size to initialize reqlist.      */
#define MAX_TRANS	10000   /* Maximum allowed size of lvflist. */
#define MAX_LVFS	10000   /* Maximum allowed size of reqlist. */

#define MAX_FUN_PARMS	1000	/* Max # of parms in a function msg. */
#define MAX_PARM_LEN	30	/* Max length of a parameter.	     */

#define MAXNAMELEN	30	/* Maximum length of input file name. */
#define MAX_INPUT_FILES 10	/* Max number of input files allowed. */

#define NUM_DEVICES	 9	/* The number of devices in use.     */

#define NUM_HASH_BUCKETS 20	/* Number of buckets in hash table.  */

#define HASH_ACTION_ADD    1	/* Add a server to the hash table.         */
#define HASH_ACTION_REMOVE 2	/* Remove all servers from the hash table. */
#define HASH_ACTION_LOOKUP 3	/* Check hash table for the given server.  */
#define HASH_ACTION_RNDSEL 4	/* Choose random function server.          */

#define PAUSE_VALUE	24900000  /* A value to be used as an upper bound */
				  /* for selecting a large number to use  */
				  /* to pause for 0 to 4 seconds between  */
				  /* sending requests to the server.      */


typedef struct _ACTIVE_LVF {
	char	*lvfname;
	int	recs;
}	ACTIVE_LVF;

typedef struct _PARM_LIST{
	char	ptype,
		pvalue[MAX_PARM_LEN];
	int	pseqnr,
		parmlen,
		dec,
		just,
		zfill,
		parmtype,
		onetime;
	char	listid[MAX_PARM_LEN],
		bitmask[MAX_PARM_LEN],
		template[MAX_PARM_LEN],
		iserver[MAXNAMELEN],
		iname[MAXNAMELEN];
	struct _PARM_LIST	*next;
}	PARM_LIST;

typedef struct _VALID_FSERVER{
	char	*group,
		*sname,
		*fname,
		*trans;
	int	num_parms;
	PARM_LIST	*fparm,
			*lparm;
	struct _VALID_FSERVER	*next;
}	VALID_FSERVER;

/*****************************************************************************
*	Prototypes
*****************************************************************************/
int		get_time (struct tm **);
int		get_field (char**, char*);
void	initialize_global_variables ( void );
int		initialize_lvf (LVF_HEADER **);
int 	initialize_LVF_element (LVF_FORM **, int);
int		initialize_lvf_repeat (LVF_REPEAT_FORM **);
int		initialize_request (REQUEST_FORM **);
int		initialize_reply (REPLY_FORM**);
void	initialize_parameter_structure (PARM_LIST *);
int		clear_LVF_header (LVF_HEADER *);
int		clear_LVF_element (LVF_FORM *);
int		clear_request (REQUEST_FORM **);
int		show_lvf_data (LVF_HEADER *);
int		show_lvf_data_element (LVF_FORM *);
int		show_lvf_repeat (LVF_REPEAT_FORM*);
void	show_reply_data (REPLY_FORM *);
int		show_request_data (REQUEST_FORM *);
int		write_mesg (int, char *);
int		mesg_print (char*, char*, char*, char*, int, int, int, int);
int		open_input_files (int, char*);
int		close_input_files (int);
int		which_input_file (FILE **);
int		get_hash_key (VALID_FSERVER);
int		hash_action (VALID_FSERVER *, int);
char	get_letter (int);
int		generate_date_string (int, char *);
int		generate_parameter (PARM_LIST *, char *);
int		generate_request (char *);
int     strcopy (char*, char*);
int     strgcat (char*, char*);
int		srv_msgsnd (int, MSGFORM*, int, int);
int		srv_msgrcv (int, MSGFORM*, int, long, int);
int		drv_msgsnd (int, MSGFORM*, int, int);
int		drv_msgrcv (int, MSGFORM*, int, long, int);
long		wrap_rnd_ri (long);

