/*****************************************************************************
 * File: test.c 
 * 
 * Description:
 *    This file implements all the wrapper functions  the IDL
 *
 * Revision History
 *    11/13/98   Chun Zhang    add wrapper functions
 *    10/9/98    Chun Zhang    first revision
 */

#include <stdlib.h>
#include <string.h>
#include <math.h>

/*
 * The following function just call the Math library functions
 */
double mysin (double a)
{
	return sin(a);
}
    
double mycos (double a)
{
	return cos(a);
}
    
double mytan (double a)
{
	return tan(a);
}
    
double mylog (double a)
{
	return log(a);
}

double mylog10(double a)
{
	return log(a);
}

double mypow(double a, double b)
{
	return pow(a, b);
}

double myceil(double a)
{
	return ceil(a);
}

double myfloor(double a)
{
	return floor(a);
}

/*
 * The following function just call the standard library functions
 */
double myatof(const char* s)
{
	return atof(s);
}

long myatoi(const char* s)
{
	return atoi(s);
}

long myatol(const char* s)
{
	return atol(s);
}

double mystrtod(const char* s, char** endp)
{
	return strtod(s, endp);
}
    
long mystrtol(const char* s, char** endp, long base)
{
	return strtol(s, endp, base);
}

long myrand()
{
	return rand();
}

void myexit(short status)
{
	exit(status);
}

long mysystem(const char* s)
{
	return system(s);
}

long myabs(long s)
{
	return abs(s);
}

char* mygetenv(const char* s)
{
	char *tmp;

	tmp = getenv(s);
	if(tmp)
	{
		return tmp;
	}
	else
	{
		return "";
	}
}

/*
 * The following function just call the string library functions
 */
char* mystrcpy(char** to,  const char* from)
{
	*to = realloc(*to, (strlen(from)+1)*sizeof(char));
	return strcpy(*to, from);
}

char* mystrncpy(char** to, const char* from, long count)
{
	*to = realloc(*to, (strlen(from)+1)*sizeof(char));
	return strncpy(*to, from, count);
}

char* mystrcat(char** str1, const char* str2)
{
	*str1  = realloc(*str1, (strlen(*str1)+strlen(str2)+1)*sizeof(char));
    return strcat(*str1, str2);
}

char* mystrncat(char** str1,  const char* str2,  long count)
{
	*str1  = realloc(*str1, (strlen(*str1)+strlen(str2)+1)*sizeof(char));
	return strncat(*str1, str2, count);
}

long mystrcmp(const char* str1,  const char* str2)
{
	return strcmp(str1, str2);
}

long mystrncmp(const char* str1, const char* str2, long count)
{
	return strncmp(str1, str2, count);
}

long mystrlen(const char* str1 )
{
	return strlen(str1);
}

char* mystrstr(const char* str1,  const char* str2)
{
	return strstr(str1, str2);
}
