/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.MethodCall;
import com.baan.baanvm.Queue;

class MethodParameter {
    private static final int SIZEOFINT = 4;
    private static final byte LONG_ARG = 108;
    private static final byte DOUBLE_ARG = 100;
    private static final byte STRING_ARG = 115;
    private static final Class[] stringTypes = new Class[]{null, class$java$lang$String == null ? (class$java$lang$String = MethodParameter.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MethodParameter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$$Ljava$lang$String == null ? (array$$Ljava$lang$String = MethodParameter.class$("[[Ljava.lang.String;")) : array$$Ljava$lang$String, array$$$Ljava$lang$String == null ? (array$$$Ljava$lang$String = MethodParameter.class$("[[[Ljava.lang.String;")) : array$$$Ljava$lang$String};
    private static final Class[] intTypes = new Class[]{Integer.TYPE, array$I == null ? (array$I = MethodParameter.class$("[I")) : array$I, array$$I == null ? (array$$I = MethodParameter.class$("[[I")) : array$$I, array$$$I == null ? (array$$$I = MethodParameter.class$("[[[I")) : array$$$I, array$$$$I == null ? (array$$$$I = MethodParameter.class$("[[[[I")) : array$$$$I};
    private static final Class[] doubleTypes = new Class[]{Double.TYPE, array$D == null ? (array$D = MethodParameter.class$("[D")) : array$D, array$$D == null ? (array$$D = MethodParameter.class$("[[D")) : array$$D, array$$$D == null ? (array$$$D = MethodParameter.class$("[[[D")) : array$$$D, array$$$$D == null ? (array$$$$D = MethodParameter.class$("[[[[D")) : array$$$$D};
    private MethodCall methodCall;
    private byte baanVmType;
    private Class javaVmType;
    private Object value;
    private byte nrOfDims;
    private boolean isArray;
    private int[] dims;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$$Ljava$lang$String;
    static /* synthetic */ Class array$$$Ljava$lang$String;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$$I;
    static /* synthetic */ Class array$$$I;
    static /* synthetic */ Class array$$$$I;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$$D;
    static /* synthetic */ Class array$$$D;
    static /* synthetic */ Class array$$$$D;

    MethodParameter(MethodCall methodCall) {
        this.methodCall = methodCall;
        this.parseMethodParameter();
    }

    private void parseMethodParameter() {
        this.parseType();
        this.parseValue();
    }

    private void parseType() {
        this.baanVmType = this.methodCall.getByte();
        this.nrOfDims = this.methodCall.getByte();
        this.dims = new int[this.nrOfDims];
        for (int i = 0; i < this.nrOfDims; ++i) {
            this.dims[i] = this.methodCall.getInt();
        }
        this.javaVmType = MethodParameter.getJavaVmType(this.baanVmType, this.nrOfDims);
    }

    private void parseValue() {
        switch (this.baanVmType) {
            case 115: {
                this.value = this.parseStringValue();
                break;
            }
            case 108: {
                this.value = this.parseIntValue();
                break;
            }
            case 100: {
                this.value = this.parseDoubleValue();
            }
        }
    }

    private Object parseIntValue() {
        switch (this.nrOfDims) {
            case 0: {
                return new Integer(this.methodCall.getInt());
            }
            case 1: {
                int[] nArray = new int[this.dims[0]];
                this.parseIntArray(nArray);
                return nArray;
            }
            case 2: {
                int[][] nArray = new int[this.dims[0]][this.dims[1]];
                this.parseIntArray(nArray);
                return nArray;
            }
            case 3: {
                int[][][] nArray = new int[this.dims[0]][this.dims[1]][this.dims[2]];
                this.parseIntArray(nArray);
                return nArray;
            }
            case 4: {
                int[][][][] nArray = new int[this.dims[0]][this.dims[1]][this.dims[2]][this.dims[3]];
                this.parseIntArray(nArray);
                return nArray;
            }
        }
        return null;
    }

    private void parseIntArray(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.methodCall.getInt();
        }
    }

    private void parseIntArray(int[][] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseIntArray(nArray[i]);
        }
    }

    private void parseIntArray(int[][][] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseIntArray(nArray[i]);
        }
    }

    private void parseIntArray(int[][][][] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseIntArray(nArray[i]);
        }
    }

    private Object parseDoubleValue() {
        switch (this.nrOfDims) {
            case 0: {
                return new Double(this.methodCall.getDouble());
            }
            case 1: {
                double[] dArray = new double[this.dims[0]];
                this.parseDoubleArray(dArray);
                return dArray;
            }
            case 2: {
                double[][] dArray = new double[this.dims[0]][this.dims[1]];
                this.parseDoubleArray(dArray);
                return dArray;
            }
            case 3: {
                double[][][] dArray = new double[this.dims[0]][this.dims[1]][this.dims[2]];
                this.parseDoubleArray(dArray);
                return dArray;
            }
            case 4: {
                double[][][][] dArray = new double[this.dims[0]][this.dims[1]][this.dims[2]][this.dims[3]];
                this.parseDoubleArray(dArray);
                return dArray;
            }
        }
        return null;
    }

    private void parseDoubleArray(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.methodCall.getDouble();
        }
    }

    private void parseDoubleArray(double[][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseDoubleArray(dArray[i]);
        }
    }

    private void parseDoubleArray(double[][][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseDoubleArray(dArray[i]);
        }
    }

    private void parseDoubleArray(double[][][][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseDoubleArray(dArray[i]);
        }
    }

    private Object parseStringValue() {
        switch (this.nrOfDims) {
            case 1: {
                return this.methodCall.getString(this.dims[0]);
            }
            case 2: {
                String[] stringArray = new String[this.dims[0]];
                this.parseStringArray(stringArray);
                return stringArray;
            }
            case 3: {
                String[][] stringArray = new String[this.dims[0]][this.dims[1]];
                this.parseStringArray(stringArray);
                return stringArray;
            }
            case 4: {
                String[][][] stringArray = new String[this.dims[0]][this.dims[1]][this.dims[2]];
                this.parseStringArray(stringArray);
                return stringArray;
            }
        }
        return null;
    }

    private void parseStringArray(String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.dims[this.nrOfDims - 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.methodCall.getString(n2);
        }
    }

    private void parseStringArray(String[][] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseStringArray(stringArray[i]);
        }
    }

    private void parseStringArray(String[][][] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseStringArray(stringArray[i]);
        }
    }

    Class getType() {
        return this.javaVmType;
    }

    Object getValue() {
        return this.value;
    }

    private static byte getDims(byte[] byArray, int n, int[] nArray) {
        byte by = byArray[n++];
        return by;
    }

    private static Class getJavaVmType(byte by, int n) {
        if (n >= 0 && n <= 4) {
            switch (by) {
                case 115: {
                    return stringTypes[n];
                }
                case 108: {
                    return intTypes[n];
                }
                case 100: {
                    return doubleTypes[n];
                }
            }
        }
        Queue.LogMessage("DispatchMethod: Illegal type/dimensions for parameter: " + by + "/" + n, 1);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

