REM **************************************************************************
REM * File	: tstructV7.sql
REM * Purpose	: show the table structure and statistics
REM * Author	: Peter Romeijn, Baan International b.v.
REM * Date	: Sept 1993
REM **************************************************************************

set verify 	off;
set feedback 	off;
set pagesize 	30;

define BLOCK_SIZE	= 2048;

accept table char prompt 'Enter table : '
spool table.def;

column table_name 	format A12		heading "table";
column segment_name 	format A12		heading "table";
column initial_extent	format 99999990		heading "initial";
column next_extent	format 99999990		heading "next";
column pct_increase 	format 990		heading "%incr";
column pct_free		format 990		heading "%free";
column pct_used 	format 990		heading "%used";
column ini_trans	format 990		heading "initrans";
column tablespace_name	format A15		heading "tablespace";
column extent_id				heading "extent";
column extents					heading "#extents";
column blocks					heading "#blocks";
column bytes					heading "#bytes";
column index_name 	format A17		heading "index";
column column_name 	format A12		heading "column";

set heading off;
column user noprint new_value owner;
select user from dual;
set heading on;

ttitle col 25 'Table &table of ' owner skip 2 -
       col 25 'Current table definition' skip 2;
select table_name, pct_free, pct_used, ini_trans, tablespace_name, 
	initial_extent, next_extent, pct_increase
from user_tables
where table_name = upper('&table');

ttitle col 25 'Current allocated space' skip 2;
select segment_name, extents, blocks, bytes
from user_segments
where segment_name = upper('&table');

ttitle col 25 'Current space in use' skip 2;
select  count(distinct(substr(rowid,1,8) || substr(rowid,14,5)))
		"#blocks with rows",
	count(distinct(substr(rowid,1,8) || substr(rowid,14,5))) * &BLOCK_SIZE
						"#bytes"
from &table;

ttitle off;
select avg(count(*)) "#records per block"
from &table
group by substr(rowid,1,8) || substr(rowid,14,5);

break on report on segment_name;
compute sum of blocks on report;
compute sum of bytes on report;
ttitle col 25 'Extent information table &table' skip 2;
select  segment_name, extent_id, 
	blocks, bytes
from user_extents
where segment_name = upper('&table');
clear breaks;

ttitle col 25 'Created indexes on table &table' skip 2;
break on index_name;
select c.index_name, c.column_name, i.tablespace_name
from user_ind_columns c, user_indexes i
where c.table_name = upper('&table') and c.index_name = i.index_name;
clear breaks;

ttitle off;
spool off;

exit;
