REM ***************************************************************************
REM File	: ora_pre.sql
REM Description : Creates list of one company's tables to be converted
REM		  It will create a flat file, called ora.tables.pre.<compnr>,
REM		  which only contains those tables having a column with length
REM		  > 255 bytes.
REM		  The file can be used as input for bdbpre6.1 with
REM		  ORA_INIT=0110000 (can read VARCHAR of length 2000)
REM Input	: Login as owner of tables. Give company number, e.g. 000.
REM Author	: Peter Romeijn, Baan Development BV
REM Date	: April 1995
REM ***************************************************************************

whenever oserror exit oscode
whenever sqlerror exit sql.sqlcode
set newpage	0
set space	0
set linesize	8
set pagesize	0
set echo	off
set feedback	off
set verify	off

REM Select tables for manual conversion

spool &2/ora.tables.pre.&1

select substr(lower(table_name),2,8) from user_tab_columns
where table_name like 'T___________' and
      substr(table_name,10,3) = '&1' and
      data_length > 255
group by table_name;

spool	off
exit success
