/*
 * Prototype of conversion functions for the Al-library
 * Copyright 1990-1998 Baan Development BV
 */

#ifndef _AL_CONV_H
#define _AL_CONV_H

/* al_gregd.c */

void	set_first_day_of_week	( int	num );

long	date_to_num		( int	year,
				  int	month,
				  int	day );

int	al_utc_to_local		( long	*p_ldays,
				  long	*p_ltime,
				  long	utcdays,
				  long	utctime );

int	al_local_to_utc		( long	*udayp,
				  long	*utimep,
				  long	loc_days,
				  long	loc_time );

int	num_to_date		( long	days,
				  int	*year,
				  int	*month,
				  int	*day );

long	str_to_date		( char	*date,
				  char	*format );

int	format_date		( long	days,
				  char	*format,
				  char	*buf );

int	num_to_week		( long	days,
				  char	*firstweek,
				  int	*dagnr1,
				  int	*dagnr2,
				  int	*week,
				  int	*jaar );

long	week_to_num		( int	week,
				  int	jaar,
				  int	dag );

void	gregdate		( char	*datum,
				  char	*firstweek,
				  int	*dagnr1,
				  int	*dagnr2,
				  int	*week );

void	w_to_dat		( int	week,
				  int	jaar,
				  int	dag,
				  char	*dat );

int 	al_pack_utc		( int 	year, 
				  int	month, 
				  int	day, 
				  int	hour, 
				  int	min, 
				  int	sec, 
				  bs4	*utc );

int	al_unpack_utc		( bs4	utc, 
				  int	*year, 
				  int	*month, 
				  int	*day, 
				  int	*hour, 
				  int	*min, 
				  int	*sec );

long	date_num		( void );
long	date_num_utc		( void );


/* al_isutl.c	*/

float	float_out		( char	*p );
double	double_out		( char	*p );

void	float_in		( double f, char	*p );
void	double_in		( double d, char	*p );

void al_convert_double(UCHAR* ptr, int from, int to);
void al_convert_float(UCHAR* ptr, int from, int to);


#endif /* _AL_CONV_H */
