/***********************************************************************
* File: ddc_supplier.c
* 
* This file declares the function prototype for getting DDC groups
* 
***********************************************************************/
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#ifdef _WIN32
# include <windows.h>
# include <process.h>
# include <io.h>
#else	/* _WIN32 */
# include <sys/ipc.h>
#endif

#include "system.h"
#include "ddc_baan.h"
#include "ddc.h"
#include "ddc_supplier.h"
#include "ddc_tools.h"

int	ddc_groups_by_driver( glist )
GROUPLIST       **glist;
/*	IN:	&glist;
	OUT:	glist is the pointer to first occurrence in the 
		group list GROUPLIST from the DDC DEVICE DRIVER 
		Returns 0 if succeeded
			-1 otherwise
*/
{
/* glist is filled correctly */
	
	GROUPLIST       *ptr;
	static char     *grpident[] =   {"Group1",
                                     "Group2",
                                     "Group3",
                                     "Group4",
                                     "Group5"
                                    };
	static int      num = sizeof (grpident) / sizeof (char *);
	register int    i = 0;

	while ( i < num ) {
        	ptr = (GROUPLIST *) calloc( 1, sizeof( GROUPLIST ) ); 
		strcopy( ptr->grpident, grpident[i] );
		ptr->lnext = *glist;
		*glist = ptr;
		i++;
	}

        return 0;
}

int		ddc_execute_collect_group( grpident, msgtext )
char            *grpident,
                *msgtext;
/*      IN:     grpident        : The group identification of a device,
                msgtext         : The message text: "DDC_EXECUTE".
        OUT:    Returns 0 if the ddc device group is going to execute
                        -1 otherwise
*/
{
        /* To all members of 'grpident' do:
                Give an "DDC_EXECUTE" sign (execution can be started).  */
        /* DDC device driver suppliers have to implement this function  */
	
	return(0);
}


int		ddc_end_collect_session()
/*	IN:	The ddc.server has sent a "DDC_END" message to the driver
	OUT:	Returns 0 if the DDC Controller is going to take necessary
			actions
			-1 otherwise
*/
{
	/* Send to all collect processes an indication (or: message)
	   that it has prepare to stop the current data collection 
	   session. */
	/* DDC device driver suppliers have to implement this function	*/

	return(0);
}

int     ddc_free_LVF_FORM_memory( lvfform )
LVF_FORM	*lvfform;
/*      IN:     lvf =pointer a one of more LVF forms
        OUT:    all memory belonging to '*lvf' is freed
                Returns 0 if succeeded
                        -1 if not (error occured)
*/
{
	if ( ! lvfform )
		return( -1 );

	if ( lvfform->listid ) free( lvfform->listid );
	if ( lvfform->record ) free( lvfform->record );
	if ( lvfform->action ) free( lvfform->action );
	free ( lvfform );

	return( 0 );
}


