/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.Bucket;
import com.baan.baanvm.DispatchMethodListener;
import com.baan.baanvm.QueueListenerDaemon;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;

class BaanVMProxy {
    private DataInputStream m_is;
    private DataOutputStream m_os;
    private Hashtable m_queues = null;
    private static final String s_version = "1.0";
    private static Socket s_socket = null;
    private static boolean s_debugTrace = false;
    private static boolean s_dbgjvmi = false;
    private static boolean s_isJVMI2 = false;
    private static BaanVMProxy s_instance = null;

    public static BaanVMProxy instance() {
        if (s_instance != null) {
            return s_instance;
        }
        return BaanVMProxy.createInstance();
    }

    private static synchronized BaanVMProxy createInstance() {
        if (s_instance == null) {
            s_instance = new BaanVMProxy();
        }
        return s_instance;
    }

    public static boolean isJVMI2() {
        return s_isJVMI2;
    }

    public static void DebugTrace(String string) {
        if (s_debugTrace) {
            System.err.println(string);
        }
    }

    public BaanVMProxy() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.m_queues = new Hashtable();
            InputStream inputStream = null;
            OutputStream outputStream = null;
            if (s_socket == null) {
                inputStream = System.in;
                outputStream = System.out;
            } else {
                inputStream = s_socket.getInputStream();
                outputStream = s_socket.getOutputStream();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.m_is = new DataInputStream(bufferedInputStream);
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                this.m_os = new DataOutputStream(bufferedOutputStream);
                try {
                    System.setOut(System.err);
                }
                catch (SecurityException securityException) {
                    BaanVMProxy.DebugTrace("BaanVMProxy::initialize() caught '" + securityException + "'");
                    throw securityException;
                }
                this.writeString(s_version);
                this.m_os.flush();
            }
            catch (Exception exception) {
                BaanVMProxy.DebugTrace("BaanVMProxy::initialize() caught '" + exception + "'");
                throw exception;
            }
            catch (Throwable throwable) {
                BaanVMProxy.DebugTrace("BaanVMProxy::initialize() caught '" + throwable + "'");
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void readBytes(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while ((n2 += this.m_is.read(byArray, n2, n - n2)) < n) {
        }
    }

    private String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, n);
        String string = new String(byArray);
        return string;
    }

    private String readCommand() throws IOException {
        int n = this.m_is.readInt();
        String string = this.readString(n);
        return string;
    }

    private int readQueueId() throws IOException {
        int n = this.m_is.readInt();
        return n;
    }

    private Bucket readBucket() throws IOException {
        byte[] byArray;
        int n = this.m_is.readInt();
        int n2 = this.m_is.readInt();
        String string = null;
        if (n > 0) {
            byArray = new byte[n];
            this.readBytes(byArray, n);
            string = new String(byArray);
        } else {
            string = new String();
        }
        byArray = new byte[n2];
        this.readBytes(byArray, n2);
        return new Bucket(byArray, string);
    }

    private void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF8");
        this.m_os.writeInt(byArray.length);
        this.m_os.write(byArray);
    }

    private void writeCommand(String string) throws IOException {
        this.writeString(string);
    }

    private void addQueue(int n) {
        Integer n2 = new Integer(n);
        LinkedList linkedList = new LinkedList();
        this.m_queues.put(n2, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkBucketToQueue(int n, Bucket bucket) {
        LinkedList linkedList;
        Integer n2 = new Integer(n);
        LinkedList linkedList2 = linkedList = (LinkedList)this.m_queues.get(n2);
        synchronized (linkedList2) {
            linkedList.add(bucket);
        }
    }

    private boolean queueExists(int n) {
        Integer n2 = new Integer(n);
        return this.m_queues.containsKey(n2);
    }

    private void removeQueue(int n) {
        Integer n2 = new Integer(n);
        this.m_queues.remove(n2);
        QueueListenerDaemon.stopListener(n);
    }

    private void removeAllQueues() {
        Hashtable hashtable = (Hashtable)this.m_queues.clone();
        this.m_queues.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            QueueListenerDaemon.stopListener(n);
        }
        hashtable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBucketFromQueue(int n, Bucket bucket) {
        int n2 = 1;
        if (this.queueExists(n)) {
            Bucket bucket2 = null;
            Integer n3 = new Integer(n);
            LinkedList linkedList = (LinkedList)this.m_queues.get(n3);
            if (linkedList == null) {
                BaanVMProxy.DebugTrace("BaanVMProxy::getBucketFromQueue(): queue == NULL");
                n2 = -2;
            } else {
                LinkedList linkedList2 = linkedList;
                synchronized (linkedList2) {
                    if (linkedList.size() != 0) {
                        bucket2 = (Bucket)linkedList.removeFirst();
                    }
                }
                if (bucket2 != null) {
                    bucket.setHeader(bucket2.getHeader());
                    bucket.setBucket(bucket2.getBucket());
                    bucket2 = null;
                    if (bucket.getBucket() == null) {
                        n2 = 0;
                    }
                } else {
                    bucket = null;
                    n2 = -4;
                }
            }
        } else {
            n2 = -2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putBucketInQueue(int n, Bucket bucket) {
        int n2 = 0;
        if (this.queueExists(n)) {
            byte[] byArray = bucket.getBucket();
            byte[] byArray2 = new byte[]{0};
            String string = bucket.getHeader();
            if (string != null) {
                try {
                    byArray2 = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray2 = string.getBytes();
                }
            }
            try {
                DataOutputStream dataOutputStream = this.m_os;
                synchronized (dataOutputStream) {
                    this.writeCommand("putBucket");
                    this.m_os.writeInt(n);
                    this.m_os.writeInt(byArray2.length);
                    this.m_os.writeInt(byArray.length);
                    this.m_os.write(byArray2);
                    this.m_os.write(byArray);
                    this.m_os.flush();
                }
            }
            catch (IOException iOException) {
                BaanVMProxy.DebugTrace("BaanVMProxy::putBucketInQueue('" + n + "', ...) caught '" + iOException + "'");
                n2 = -1;
            }
        } else {
            n2 = -2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int installListenerOnQueue(int n) {
        int n2 = 0;
        if (this.queueExists(n)) {
            try {
                DataOutputStream dataOutputStream = this.m_os;
                synchronized (dataOutputStream) {
                    this.writeCommand("installListener");
                    this.m_os.writeInt(n);
                    this.m_os.flush();
                }
            }
            catch (IOException iOException) {
                BaanVMProxy.DebugTrace("BaanVMProxy::installListenerOnQueue('" + n + "') caught '" + iOException + "'");
                n2 = -1;
            }
        } else {
            n2 = -2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LogMessage(String string, int n) {
        if (n == 0 && !s_dbgjvmi) {
            return;
        }
        if (this.m_os != null) {
            try {
                DataOutputStream dataOutputStream = this.m_os;
                synchronized (dataOutputStream) {
                    this.writeCommand("logMessage");
                    this.m_os.writeInt(n);
                    this.writeString(string + "\n\u0000");
                    this.m_os.flush();
                }
            }
            catch (IOException iOException) {
                BaanVMProxy.DebugTrace("BaanVMProxy::LogMessage('" + string + "', '" + n + "') caught '" + iOException + "'");
            }
        }
    }

    public void handleMessages() {
        block9: {
            try {
                String string;
                while (true) {
                    int n;
                    if ((string = this.readCommand()).equals("putBucket")) {
                        n = this.readQueueId();
                        Bucket bucket = this.readBucket();
                        this.linkBucketToQueue(n, bucket);
                        QueueListenerDaemon.dispatchQueueEvent(n);
                        continue;
                    }
                    if (string.equals("addQueue")) {
                        n = this.readQueueId();
                        this.addQueue(n);
                        continue;
                    }
                    if (string.equals("removeQueue")) {
                        n = this.readQueueId();
                        this.removeQueue(n);
                        continue;
                    }
                    if (!string.equals("startDispatchMethodListener")) break;
                    n = this.readQueueId();
                    DispatchMethodListener.start(n);
                }
                if (string.equals("stop")) {
                    this.removeAllQueues();
                    break block9;
                }
                this.LogMessage("BaanVMProxy (bjvmi.jar): command '" + string + "' not recognized, exiting.", 1);
            }
            catch (IOException iOException) {
                BaanVMProxy.DebugTrace("BaanVMProxy::handleMessages() caught '" + iOException + "'");
            }
            catch (Exception exception) {
                BaanVMProxy.DebugTrace("BaanVMProxy::handleMessages() caught '" + exception + "'");
                this.LogMessage("BaanVMProxy::handleMessages() caught '" + exception + "'", 1);
            }
            catch (Throwable throwable) {
                BaanVMProxy.DebugTrace("BaanVMProxy::handleMessages() caught '" + throwable + "'");
                this.LogMessage("BaanVMProxy::handleMessages() caught '" + throwable + "'", 1);
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-dbgjvmi")) {
                s_dbgjvmi = true;
                BaanVMProxy.DebugTrace("BaanVMProxy::main(): -dbgjvmi option");
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                s_debugTrace = true;
                BaanVMProxy.DebugTrace("BaanVMProxy::main(): -debug option");
                continue;
            }
            if (stringArray[i].equals("-socket")) {
                BaanVMProxy.DebugTrace("BaanVMProxy::main(): -socket " + stringArray[++i] + " option");
                try {
                    s_socket = new Socket(InetAddress.getLocalHost(), Integer.parseInt(stringArray[i]));
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("BaanVMProxy::main(): InetAddress.getLocalHost() failed: " + unknownHostException.getMessage());
                    return;
                }
                catch (IOException iOException) {
                    System.err.println("BaanVMProxy::main(): Socket creation failed: " + iOException.getMessage());
                    return;
                }
                BaanVMProxy.DebugTrace("BaanVMProxy::main(): -socket option created Socket '" + s_socket + "'");
                continue;
            }
            System.err.println("BaanVMProxy::main(): Illegal argument '" + stringArray[i] + "' (ignored)");
        }
        s_isJVMI2 = true;
        BaanVMProxy.DebugTrace("BaanVMProxy::main()");
        BaanVMProxy baanVMProxy = BaanVMProxy.instance();
        baanVMProxy.handleMessages();
        BaanVMProxy.DebugTrace("BaanVMProxy exit");
    }
}

