/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbAPIException;
import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbDatabase;
import java.io.IOException;
import java.sql.SQLException;

abstract class SQLCommand {
    private final EntryPoint _entryPoint;

    public SQLCommand(EntryPoint entryPoint) {
        this._entryPoint = entryPoint;
    }

    protected final Object getSynchronizationObject() {
        return this._entryPoint.getSynchronizationObject();
    }

    public void run() throws SQLException, IOException, InterruptedException {
        throw new Error("UNREACHED");
    }

    public int runInt() throws SQLException, IOException, InterruptedException {
        throw new Error("UNREACHED");
    }

    public boolean runBoolean() throws SQLException, IOException, InterruptedException {
        throw new Error("UNREACHED");
    }

    public String runString() throws SQLException, IOException, InterruptedException {
        throw new Error("UNREACHED");
    }

    public Object runObject() throws SQLException, IOException, InterruptedException {
        throw new Error("UNREACHED");
    }

    public String getDescription() {
        return this._entryPoint.getEntryPointDescription();
    }

    Object execute(Class clazz) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                if (clazz.equals(Void.class)) {
                    this.run();
                    return null;
                }
                if (clazz.equals(Integer.class)) {
                    return new Integer(this.runInt());
                }
                if (clazz.equals(Boolean.class)) {
                    return new Boolean(this.runBoolean());
                }
                if (clazz.equals(String.class)) {
                    return this.runString();
                }
                if (clazz.equals(Object.class)) {
                    return this.runObject();
                }
                throw new Error("UNREACHED");
            }
        }
        catch (IOException iOException) {
            throw this.protocolError("I/O problem while communicating with subprocess", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw this.protocolError("problem while communicating with subprocess", interruptedException);
        }
        catch (JbdbAPIException jbdbAPIException) {
            jbdbAPIException.setDescription(this.getDescription());
            throw jbdbAPIException;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
    }

    public JbdbConnection.JbdbProtocolException protocolError(String string, Throwable throwable) {
        JbdbDatabase.getSingleton().getLogger().logError(string + ", " + this.getDescription());
        return new JbdbConnection.JbdbProtocolException(string, throwable);
    }

    void execute() throws SQLException {
        this.execute(Void.class);
    }

    int executeInt() throws SQLException {
        return (Integer)this.execute(Integer.class);
    }

    boolean executeBoolean() throws SQLException {
        return (Boolean)this.execute(Boolean.class);
    }

    String executeString() throws SQLException {
        return (String)this.execute(String.class);
    }

    Object executeObject() throws SQLException {
        return this.execute(Object.class);
    }

    static interface EntryPoint {
        public Object getSynchronizationObject();

        public String getEntryPointDescription();
    }
}

