/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbDatabase;
import com.baan.jbdb.datatypes.JbdbArray;
import com.baan.jbdb.datatypes.JbdbValue;
import java.util.ArrayList;
import java.util.List;

class JbdbRow {
    private final List _columns = new ArrayList();

    public String getColumnAsString(int n) {
        JbdbValue jbdbValue = this.getColumn(n);
        return jbdbValue.isNull() ? null : jbdbValue.toASCIIString();
    }

    public JbdbValue getColumn(int n) {
        if (n < 0 || n >= this._columns.size()) {
            JbdbDatabase.apiError("incorrect column number");
        }
        return (JbdbValue)this._columns.get(n);
    }

    public void add(JbdbValue jbdbValue) {
        this._columns.add(jbdbValue);
    }

    public String getColumnElementAsString(int n, int n2) {
        JbdbValue jbdbValue = this.getColumnElement(n, n2);
        return jbdbValue.isNull() ? null : jbdbValue.toASCIIString();
    }

    public JbdbValue getColumnElement(int n, int n2) {
        JbdbValue jbdbValue;
        if (n < 0 || n >= this._columns.size()) {
            JbdbDatabase.apiError("incorrect column number");
        }
        if (!((jbdbValue = (JbdbValue)this._columns.get(n)) instanceof JbdbArray)) {
            JbdbDatabase.apiError("not an array column");
        }
        JbdbArray jbdbArray = (JbdbArray)jbdbValue;
        if (n2 < 0 || n2 >= jbdbArray.getDepth()) {
            JbdbDatabase.apiError("incorrect array index");
        }
        return jbdbArray.getElement(n2);
    }
}

