/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbAPIException;
import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbLogger;
import com.baan.jbdb.JbdbNullLogger;
import com.baan.jbdb.JbdbProcessFactory;
import com.baan.jbdb.JbdbSession;
import com.baan.jbdb.JbdbStatement;
import com.baan.jbdb.JbdbStdLogger;
import com.baan.jbdb.JbdbTable;
import com.baan.jbdb.OSProcessFactory;
import com.baan.jbdb.SQLCommand;
import com.baan.jbdb.Util;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class JbdbDatabase
implements SQLCommand.EntryPoint {
    private static JbdbDatabase _Singleton = null;
    private static final JbdbLogger NULL_LOGGER = new JbdbNullLogger();
    private JbdbLogger _logger = new JbdbStdLogger();
    private final JbdbProcessFactory _processFactory;
    private int _nextId = 0;
    private final Map _connections = Collections.synchronizedMap(new HashMap());
    private final Map _jbdbObjects = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$baan$jbdb$JbdbStatement;
    static /* synthetic */ Class class$com$baan$jbdb$JbdbSession;
    static /* synthetic */ Class class$com$baan$jbdb$JbdbConnection;

    public JbdbLogger getLogger() {
        return this._logger;
    }

    public void setLogger(JbdbLogger jbdbLogger) {
        this._logger = jbdbLogger == null ? NULL_LOGGER : jbdbLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JbdbDatabase getSingleton() {
        if (_Singleton != null) {
            return _Singleton;
        }
        Class clazz = JbdbDatabase.class;
        synchronized (clazz) {
            if (_Singleton == null) {
                JbdbDatabase.initialize(new OSProcessFactory());
            }
            return _Singleton;
        }
    }

    public static void initialize(JbdbProcessFactory jbdbProcessFactory) {
        _Singleton = new JbdbDatabase(jbdbProcessFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Class clazz = JbdbDatabase.class;
        synchronized (clazz) {
            return this._nextId++;
        }
    }

    public final void addJbdbObject(int n, Object object) {
        this._jbdbObjects.put(new Integer(n), object);
    }

    public final void unlinkJbdbObject(int n) {
        this._jbdbObjects.remove(new Integer(n));
    }

    public final void unlinkJbdbObject(Integer n) {
        this._jbdbObjects.remove(n);
    }

    public JbdbDatabase(JbdbProcessFactory jbdbProcessFactory) {
        this._processFactory = jbdbProcessFactory;
    }

    public String getJbdb1ProcessPackageCombination(final JbdbConnection jbdbConnection) throws SQLException {
        return new SQLCommand(this){

            public String runString() throws SQLException, IOException {
                return jbdbConnection.getPackageCombination();
            }
        }.executeString();
    }

    public int createJbdb1Session(final JbdbConnection jbdbConnection, final String string, final String string2) throws SQLException {
        return new SQLCommand(this){

            public int runInt() throws SQLException, IOException {
                return JbdbDatabase.this.createSession(jbdbConnection, string, string2);
            }
        }.executeInt();
    }

    public int createJBDB1Statement(final JbdbConnection jbdbConnection) throws SQLException {
        return new SQLCommand(this){

            public int runInt() throws SQLException, IOException {
                int n = JbdbDatabase.this.getNextId();
                JbdbStatement jbdbStatement = new JbdbStatement(jbdbConnection, n);
                JbdbDatabase.this.addJbdbObject(n, jbdbStatement);
                return n;
            }
        }.executeInt();
    }

    public JbdbConnection createJbdb1Connection() throws SQLException {
        final JbdbConnection jbdbConnection = this.createConnection();
        jbdbConnection.init("");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JbdbConnection jbdbConnection2 = jbdbConnection;
                    synchronized (jbdbConnection2) {
                        jbdbConnection.exit();
                    }
                }
                catch (Exception exception) {
                    JbdbDatabase.this._logger.logError("Could not stop process at JVM shutdown.");
                    System.err.println("Could not stop process at JVM shutdown.");
                    exception.printStackTrace();
                }
            }
        });
        return jbdbConnection;
    }

    public int getJbdb1ProcessLanguage(final JbdbConnection jbdbConnection) throws SQLException {
        return new SQLCommand(this){

            public int runInt() throws SQLException, IOException {
                return jbdbConnection.getLanguage();
            }
        }.executeInt();
    }

    public JbdbTable getJbdb1Table(final JbdbConnection jbdbConnection, final String string) throws SQLException {
        return (JbdbTable)new SQLCommand(this){

            public Object runObject() throws SQLException, IOException {
                return jbdbConnection.getTable(string);
            }
        }.executeObject();
    }

    public int createSession(int n, final String string, final String string2) throws SQLException {
        final JbdbConnection jbdbConnection = this.getConnection(n);
        return new SQLCommand(jbdbConnection){

            public int runInt() throws SQLException, IOException {
                return JbdbDatabase.this.createSession(jbdbConnection, string, string2);
            }
        }.executeInt();
    }

    private int createSession(JbdbConnection jbdbConnection, String string, String string2) throws SQLException, IOException {
        return jbdbConnection.createSession(string, string2);
    }

    private JbdbSession getSession(int n) {
        JbdbSession jbdbSession = (JbdbSession)this._jbdbObjects.get(new Integer(n));
        if (jbdbSession == null) {
            JbdbDatabase.apiError("session id " + n + ": session does not exist");
        }
        return jbdbSession;
    }

    public void stopSession(int n) throws SQLException {
        final JbdbSession jbdbSession = this.getSession(n);
        new SQLCommand(jbdbSession){

            public void run() throws SQLException, IOException {
                jbdbSession.stop();
            }
        }.execute();
    }

    public int createStatement(int n) throws SQLException {
        final JbdbSession jbdbSession = this.getSession(n);
        return new SQLCommand(jbdbSession){

            public int runInt() throws SQLException, IOException {
                return jbdbSession.createStatement();
            }
        }.executeInt();
    }

    private JbdbStatement getStatement(int n) {
        JbdbStatement jbdbStatement = (JbdbStatement)this._jbdbObjects.get(new Integer(n));
        if (jbdbStatement == null) {
            JbdbDatabase.apiError("statement does not exist", n);
        }
        return jbdbStatement;
    }

    public void prepareJbdb1Statement(int n, final String string, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.jbdb1SetSession(JbdbDatabase.this.getSession(n2));
                jbdbStatement.prepare(string);
            }
        }.execute();
    }

    public void prepareStatement(int n, final String string) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.prepare(string);
            }
        }.execute();
    }

    public void executeStatement(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.execute(n2);
            }
        }.execute();
    }

    public void destroyStatement(int n) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.destroy();
            }
        }.execute();
    }

    public static void apiError(String string) throws JbdbAPIException {
        JbdbDatabase.getSingleton()._logger.logError(string);
        throw new JbdbAPIException(string, null);
    }

    public static void apiError(String string, int n) throws JbdbAPIException {
        JbdbDatabase.getSingleton()._logger.logError(string + ", unknown statement id " + n);
        JbdbAPIException jbdbAPIException = new JbdbAPIException(string, null);
        jbdbAPIException.setDescription("unknown statement id " + n);
        throw jbdbAPIException;
    }

    public Object getSynchronizationObject() {
        return this;
    }

    public void setQueryTimeOut(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.setTimeOut(n2);
            }
        }.execute();
    }

    public boolean fetchOnStatement(int n) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public boolean runBoolean() throws SQLException, IOException {
                return jbdbStatement.fetch();
            }
        }.executeBoolean();
    }

    public String getColumnValue(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public String runString() throws SQLException, IOException {
                return jbdbStatement.getCurrentRow().getColumnAsString(n2);
            }
        }.executeString();
    }

    public String getEntryPointDescription() {
        return null;
    }

    public void breakStatement(int n) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.breek();
            }
        }.execute();
    }

    public int statementGetNumParameters(int n) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getNumParameters();
            }
        }.executeInt();
    }

    public int statementGetParameterType(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getParameter(n2).getType().toJbdbType();
            }
        }.executeInt();
    }

    public int statementGetNumResultCols(int n) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getNumResultColumns();
            }
        }.executeInt();
    }

    public int statementGetColumnDepth(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getColumn(n2).getDepth();
            }
        }.executeInt();
    }

    public String statementGetColumnName(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public String runString() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getColumn(n2).getName();
            }
        }.executeString();
    }

    public int statementGetColumnType(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getColumn(n2).getType().toJbdbType();
            }
        }.executeInt();
    }

    public int statementGetColumnLength(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getColumn(n2).getType().getMaxLength();
            }
        }.executeInt();
    }

    public int statementGetColumnNullable(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public int runInt() throws SQLException, IOException {
                return jbdbStatement.getMetadata().getColumn(n2).isNullable();
            }
        }.executeInt();
    }

    public String getColumnArrayValue(int n, final int n2, final int n3) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public String runString() throws SQLException, IOException {
                return jbdbStatement.getCurrentRow().getColumnElementAsString(n2, n3);
            }
        }.executeString();
    }

    private JbdbConnection createConnection() throws SQLException {
        JbdbConnection jbdbConnection;
        try {
            int n = this.getNextId();
            jbdbConnection = this._processFactory.exec(n);
            jbdbConnection.initialize();
            this._connections.put(new Integer(n), jbdbConnection);
        }
        catch (IOException iOException) {
            throw Util.ToSQLException("could not create connection", iOException);
        }
        return jbdbConnection;
    }

    public JbdbConnection getConnection(int n) {
        JbdbConnection jbdbConnection = (JbdbConnection)this._connections.get(new Integer(n));
        if (jbdbConnection == null) {
            JbdbDatabase.apiError("connection id " + n + ": connection does not exist");
        }
        return jbdbConnection;
    }

    public int createConnection(String string) throws SQLException {
        JbdbConnection jbdbConnection = this.createConnection();
        jbdbConnection.init(string);
        return jbdbConnection.getId();
    }

    public void connectionClose(final int n) throws SQLException {
        final JbdbConnection jbdbConnection = this.getConnection(n);
        new SQLCommand(jbdbConnection){

            public void run() throws SQLException, IOException, InterruptedException {
                JbdbDatabase.this._connections.remove(new Integer(n));
                jbdbConnection.exit();
            }
        }.execute();
    }

    public void statementBindParameter(int n, final int n2, final String string) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        new SQLCommand(jbdbStatement){

            public void run() throws SQLException, IOException {
                jbdbStatement.bindParameter(n2, string);
            }
        }.execute();
    }

    public void setJbdbHome(String string) {
        this._processFactory.setHomeDirectory(string);
    }

    public String getPortingSetVersion() throws SQLException {
        return new SQLCommand(this){

            public String runString() throws SQLException, IOException, InterruptedException {
                if (JbdbDatabase.this._connections.isEmpty()) {
                    JbdbConnection jbdbConnection = JbdbDatabase.this.createConnection();
                    String string = jbdbConnection.getPortingSetVersion();
                    jbdbConnection.exit();
                    return string;
                }
                JbdbConnection jbdbConnection = (JbdbConnection)JbdbDatabase.this._connections.values().iterator().next();
                return jbdbConnection.getPortingSetVersion();
            }
        }.executeString();
    }

    public boolean getColumnValueIsNull(int n, final int n2) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public boolean runBoolean() throws SQLException, IOException {
                return jbdbStatement.getCurrentRow().getColumn(n2).isNull();
            }
        }.executeBoolean();
    }

    public boolean getColumnArrayValueIsNull(int n, final int n2, final int n3) throws SQLException {
        final JbdbStatement jbdbStatement = this.getStatement(n);
        return new SQLCommand(jbdbStatement){

            public boolean runBoolean() throws SQLException, IOException {
                return jbdbStatement.getCurrentRow().getColumnElement(n2, n3).isNull();
            }
        }.executeBoolean();
    }

    public JbdbTable connectionGetTable(final int n, final String string) throws SQLException {
        return (JbdbTable)new SQLCommand(this){

            public Object runObject() throws SQLException, IOException, InterruptedException {
                return JbdbDatabase.this.getConnection(n).getTable(string);
            }
        }.executeObject();
    }

    public final void printAllObjects() {
        System.out.println("All objects:");
        Iterator<Object> iterator = this._jbdbObjects.keySet().iterator();
        TreeSet treeSet = new TreeSet();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            System.out.print("  " + n + "  ");
            Object v = this._jbdbObjects.get(n);
            if ((class$com$baan$jbdb$JbdbStatement == null ? JbdbDatabase.class$("com.baan.jbdb.JbdbStatement") : class$com$baan$jbdb$JbdbStatement).isInstance(v)) {
                System.out.print("statement");
            } else if ((class$com$baan$jbdb$JbdbSession == null ? JbdbDatabase.class$("com.baan.jbdb.JbdbSession") : class$com$baan$jbdb$JbdbSession).isInstance(v)) {
                System.out.print("session");
            } else if ((class$com$baan$jbdb$JbdbConnection == null ? JbdbDatabase.class$("com.baan.jbdb.JbdbConnection") : class$com$baan$jbdb$JbdbConnection).isInstance(v)) {
                System.out.print("connection");
            }
            System.out.println("");
        }
    }

    public final void printObjectTree() {
        System.out.println("Connections/sessions/statements:");
        Iterator<Object> iterator = this._connections.keySet().iterator();
        TreeSet treeSet = new TreeSet();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            JbdbConnection jbdbConnection = this.getConnection((Integer)iterator.next());
            System.out.println("  connection id: " + jbdbConnection.getId());
            jbdbConnection.printObjectTree();
        }
    }
}

