/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbReference;
import com.baan.jbdb.JbdbTable;
import com.baan.jbdb.SQLCommand;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class JbdbColumn {
    private final JbdbTable _table;
    private final String _name;
    private final int _number;
    private final boolean _isCombined;
    static final /* synthetic */ boolean $assertionsDisabled;

    JbdbColumn(JbdbTable jbdbTable, String string, int n, boolean bl) {
        block3: {
            this._table = jbdbTable;
            this._name = string;
            this._number = n;
            this._isCombined = bl;
            try {
                if (!$assertionsDisabled && this.isIndex() && !this.isCombined()) {
                    throw new AssertionError();
                }
            }
            catch (SQLException sQLException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public String getBaseName() {
        return this._name;
    }

    public JbdbTable getTable() {
        return this._table;
    }

    public boolean isCombined() throws SQLException {
        return this._isCombined;
    }

    public boolean isIndex() throws SQLException {
        return this._name.startsWith("_index");
    }

    public boolean isPrimaryIndex() throws SQLException {
        return this._name.equals("_index1");
    }

    public JbdbColumn[] getChildren() throws SQLException {
        if (!this.isCombined()) {
            return new JbdbColumn[]{this};
        }
        final JbdbConnection jbdbConnection = this._table.getConnection();
        return (JbdbColumn[])new SQLCommand(jbdbConnection){

            public Object runObject() throws SQLException, IOException {
                Object object;
                jbdbConnection.sendRequestName('R');
                jbdbConnection.sendRequestName('C');
                jbdbConnection.sendString(JbdbColumn.this._table.getName());
                jbdbConnection.sendComma();
                jbdbConnection.sendInt(JbdbColumn.this._number);
                jbdbConnection.sendEndOfRequest();
                jbdbConnection.flush();
                jbdbConnection.receiveCheckByte('R');
                jbdbConnection.receiveCheckByte('C');
                ArrayList<JbdbColumn> arrayList = new ArrayList<JbdbColumn>();
                if (jbdbConnection.receiveSQLException() == null) {
                    while (jbdbConnection.receiveListPart()) {
                        object = jbdbConnection.receiveTypedString();
                        arrayList.add(JbdbColumn.this._table.getColumn((String)object));
                    }
                }
                jbdbConnection.receiveEndOfResponse();
                object = new JbdbColumn[arrayList.size()];
                arrayList.toArray((T[])object);
                return object;
            }
        }.executeObject();
    }

    public JbdbReference getReference() throws SQLException {
        final JbdbConnection jbdbConnection = this._table.getConnection();
        return (JbdbReference)new SQLCommand(jbdbConnection){

            public Object runObject() throws SQLException, IOException {
                jbdbConnection.sendRequestName('R');
                jbdbConnection.sendRequestName('R');
                jbdbConnection.sendString(JbdbColumn.this._table.getName());
                jbdbConnection.sendComma();
                jbdbConnection.sendInt(JbdbColumn.this._number);
                jbdbConnection.sendEndOfRequest();
                jbdbConnection.flush();
                jbdbConnection.receiveCheckByte('R');
                jbdbConnection.receiveCheckByte('R');
                JbdbReference jbdbReference = null;
                if (jbdbConnection.receiveSQLException() == null && jbdbConnection.receiveOptional()) {
                    String string = jbdbConnection.receiveTypedString();
                    jbdbConnection.receiveCheckComma();
                    String string2 = jbdbConnection.receiveTypedString();
                    jbdbConnection.receiveCheckComma();
                    int n = jbdbConnection.receiveTypedInt();
                    jbdbConnection.receiveCheckComma();
                    int n2 = jbdbConnection.receiveTypedInt();
                    jbdbReference = new JbdbReference(jbdbConnection, string, string2, n, n2);
                }
                jbdbConnection.receiveEndOfResponse();
                return jbdbReference;
            }
        }.executeObject();
    }

    int getIndexNr() throws SQLException {
        return this.isIndex() ? Integer.parseInt(this._name.substring(6)) : 0;
    }

    String getFullName() {
        return this.getTable().getName() + "." + this.getBaseName();
    }

    static {
        $assertionsDisabled = !JbdbColumn.class.desiredAssertionStatus();
    }
}

