REM ***************************************************************************
REM File	: ora_reorg.sql
REM Description : Creates list of one company's tables to be converted
REM		  A flat file is created, called ora.tables.reorg.<compnr>,
REM		  which contains tables which do not have a column with length
REM		  > 255. The file can be used as input for bdbreconfig6.1 -Z
REM		  with ORA_INIT=0111000.
REM Input	: Login as owner of tables. Give company number, e.g. 000.
REM Author	: Peter Romeijn, Baan Development BV
REM Date	: April 1995
REM ***************************************************************************

whenever oserror exit oscode
whenever sqlerror exit sql.sqlcode
set newpage	0
set space	0
set linesize	8
set pagesize	0
set echo	off
set feedback	off
set verify	off

REM Select tables for automatic conversion
spool &2/ora.tables.reorg.&1

select substr(lower(table_name),2,8) from user_tab_columns a
where table_name like 'T___________' and
      substr(table_name,10,3) = '&1' and
      exists (select table_name from user_tab_columns b
		where a.table_name = b.table_name and
                        (b.data_type = 'VARCHAR2' or b.column_name like 'HASH%')
                group by b.table_name) and
      not exists (select table_name from user_tab_columns b
                where a.table_name = b.table_name and b.data_length > 255
                group by b.table_name)
group by table_name;

spool off
exit success
