
#ifndef _MSLOT_H
#define _MSLOT_H

#define	MSG_LEN	4096

/* M_BOOL is identical to BOOLEAN in system.h */
#ifdef _WIN32
typedef unsigned char	M_BOOL;
#else
typedef int 		M_BOOL;
#endif

#ifdef __cplusplus
extern "C" {
#endif

int	MSltOpen	( int		projectID,
			  const char	*boxName,
			  M_BOOL	isServer,
			  M_BOOL	beFast );

M_BOOL	MSltSend	( int		destKey,
			  int		myKey,
			  const char	*buf,
			  int		len,
			  M_BOOL	beFast  );

int	MSltRecv	( int		myKey,
			  int		sourceKey,
			  int		timeout,
			  char		*buf,
			  int		*bufSize,
			  M_BOOL	beFast  );

void	MSltClose	( int		key,
			  M_BOOL	beFast );

#ifdef __cplusplus
}
#endif

#endif
