#ifndef __SQLClassicInterface_h
#define __SQLClassicInterface_h

#ifdef __cplusplus
extern "C" {
#endif 

/*
	SQL function codes for sql_init_func()
*/
#define FUNC_SQL_ERROR       1
#define FUNC_SQL_BIND        2 /* obsolete */
#define FUNC_SQL_HANDLE_STAR 3 /* obsolete */
#define FUNC_SQL_EXTERN      4 /* obsolete */
#define FUNC_SQL_CRT_EXTVAR  5
#define FUNC_SQL_GET_EXTVAR  6
#define FUNC_SQL_PUT_EXTVAR  7
#define FUNC_SQL_WHERE_USED  8
#define FUNC_SQL_UPDATE      9 /* obsolete */

/*
	Parse modes for sql_parse
*/
#define SQL_PM_SUPPRESS_MESS           001  /* Same as PRS_SUPPRESS_MESS ! */
#define SQL_PM_IGNORE_DUPL_TABLE_NAMES 002
#define SQL_PM_ADD_TABLES              004
#define SQL_PM_WHERE_USED              010
#define SQL_PM_DFLT_TARGET_FOR_ARRAY_INDEXING    040
	/*
		SQL_PM_DFLT_TARGET_FOR_ARRAY_INDEXING: Generate default target 
		"<table>.<column>(<index>)" for array indexing. E.g.  for the 
		query "select a.phoneno(1) from dbtst120 a" the default target 
		"dbtst120.phoneno(1)" is generated.
	*/
#define SQL_PM_FLATTEN_MULTI_LANGUAGE_COLUMN 0400
	/*
		SQL_PM_FLATTEN_MULTI_LANGUAGE_COLUMN: All MLE columns are "flattened";
		i.e. the current language of the column is selected.
	*/


#define SQL_PM_DIALECT_BAANIV       01000 /* BaanIV syntax and query processor */
#define SQL_PM_DIALECT_CORELLI       0100 /* 5.0 syntax and query processor */
#define SQL_PM_DIALECT_ERPLN        02000 /* ERP LN syntax and "new" query processor */
#define SQL_PM_DIALECT_ANSI           020 /* ANSI syntax and "new" query processor */
	/*
		Only one of these parse modes may be set at the same time.

		In the BaanIV Porting Set, SQL_PM_DIALECT_CORELLI is not
		supported, and the default is SQL_PM_DIALECT_BAANIV.

		In the ERP LN Porting Set, SQL_PM_DIALECT_BAANIV is not
		supported, and the default depends on the Tools/applications
		that are used: SQL_PM_DIALECT_CORELLI for 5.0, and
		SQL_PM_DIALECT_ERPLN for later versions.

		The numbering is weird for backward compatibility: these parse
		modes can be passed to bsql.
	*/


#define SQL_PM_DIALECT_MASK         03120
	/*
		SQL_PM_DIALECT_MASK: the set of all languages defined above,
		as a bitmask.
	*/

#define SQL_PM_CLASSIC_PRS_GET_EXTVAR 0200
	/*
		SQL_PM_CLASSIC_PRS_GET_EXTVAR: generate info about parameters
		for BIC the way it was done in Corelli and earlier: overwrite
		the input query string with the parameter names.

		Note: Only available if a "classic" query processor is
		selected; see above.
	*/
#define SQL_PM_CLASSIC_SELECT_ROW_ONLY 04000
	/*
		Note: Only available if a "classic" query processor is
		selected; see above.
	*/
/* NOTE: when adding more parse modes, start at 010000 ! */

/*
	SQL action types as returned by sql_action_type().
*/
#define SQL_UNKNOWN_ACTION   0
#define SQL_SELECT_STATEMENT 1
#define SQL_UPDATE_STATEMENT 2
#define SQL_DELETE_STATEMENT 4 

#define SQL_FRONT_END        0400

typedef void* SqlId;
typedef int (*SqlFunc)(void);

typedef union
{
	char *s;
	long l;
	double d;
} SqlVal;

bu4 sql_get_new_id(void);

void init_qpc_debug(void);
int qpc_session_used(char *dbc_session);
char *sql_action(int action);
int sql_action_type(SqlId sql);
int sql_bind_input(SqlId sql, const char *varname, int bdb_type, int size, SqlVal *value);
int sql_break(SqlId sql);
int sql_close(SqlId sql);
int sql_exec(SqlId sql, compnr_t compnr);
int sql_fetch(SqlId sql);
int sql_get_error(SqlId sql, int *err_no, char **err_msg);
const char * sql_get_statement_text(SqlId sql);
SqlFunc sql_init_func(int code, SqlFunc func);
SqlId sql_parse(char *select, int trans_id, int mode);
int sql_query_with_rpoint(SqlId sql);
int sql_retry(SqlId sql);
int sql_save_rpoint(SqlId sql);
int sql_sel_bind(SqlId sql, char *varname, char *sym);
int sql_set_rds_full(SqlId sql, int rds_full);
int sql_set_timeout(SqlId sql, int timeout_interval);
int sql_wh_bind(SqlId sql, char *varname, int bdb_type, int size, SqlVal *value);
void sql_where_used(char *name, int mode);


/* Functions that are available on 7.6 and higher */
int sql_get_stmt_id(SqlId sql, bu4 *pStmtId, bu4 *pOrgStmtId);
int sql_skip_rows(SqlId sql, int numRows, int *skippedRows);
int sql_get_num_parameters(SqlId sql);
int sql_get_num_resultcols(SqlId sql);
int sql_get_parameter_name(SqlId sql, int param_num, const char **param_name);
int sql_get_select_target(SqlId sql, int col_num, const char **param_name, int *is_derived);


/* Functions that are available on 7.6 and higher */
int sql_get_stmt_id(SqlId sql, bu4 *pStmtId, bu4 *pOrgStmtId);
int sql_skip_rows(SqlId sql, int numRows, int *skippedRows);
int sql_get_num_parameters(SqlId sql);
int sql_get_num_resultcols(SqlId sql);
int sql_get_parameter_name(SqlId sql, int param_num, const char **param_name);
int sql_get_select_target(SqlId sql, int col_num, const char **param_name, int *is_derived);

/* For the "old" CPU profiler */
int sql_is_LN_statement( SqlId );
long sql_set_prof_qid ( SqlId sqlId, long prof_qid );
long sql_get_prof_qid ( SqlId sqlId );

void SQLOnCloseSession(bu4 SessionId);

#ifdef __cplusplus
}
#endif

#endif
