/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbProcessFactory;
import com.baan.jbdb.OSProcess;
import com.baan.jbdb.Util;
import java.io.File;
import java.io.IOException;

class OSProcessFactory
implements JbdbProcessFactory {
    private static final String SLASH = File.separator;
    private String _jbdbHome;
    private String[] _jbdbCommandLine;

    OSProcessFactory() {
    }

    public void setHomeDirectory(String string) {
        this._jbdbHome = string;
    }

    private String getHomeDirectory() throws IOException {
        if (this._jbdbHome == null || this._jbdbHome.length() == 0) {
            this._jbdbHome = Util.getenv("JBDBHOME");
        }
        return this._jbdbHome;
    }

    public JbdbConnection exec(int n) throws IOException {
        return new OSProcess(n, this.getJbdbCommandLine());
    }

    private String[] getJbdbCommandLine() throws IOException {
        if (this._jbdbCommandLine == null) {
            String string = "jbdb" + (SLASH.equals("\\") ? ".exe" : "6.1");
            String string2 = this.findJbdbBinDirectory();
            String string3 = string2 + SLASH + string;
            String string4 = this.getHomeDirectory();
            this._jbdbCommandLine = string4 != null && string4.length() != 0 ? new String[]{string3, "-h", string4} : new String[]{string3};
        }
        return this._jbdbCommandLine;
    }

    private String findJbdbBinDirectory() throws IOException {
        String string = this.getHomeDirectory();
        if (string != null && string.length() != 0) {
            return string + SLASH + "bin";
        }
        String string2 = Util.getenv("BSE_BIN");
        if (string2 != null && string2.length() != 0) {
            return string2;
        }
        String string3 = Util.getenv("BSE");
        if (string3 != null && string3.length() != 0) {
            return string3 + SLASH + "bin";
        }
        throw new IOException("Don't know where to find jbdb binary: Neither JBDBHOME, BSE_BIN or BSE were set");
    }
}

