/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbDatabase;
import com.baan.jbdb.JbdbStatement;
import com.baan.jbdb.SQLCommand;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

class JbdbSession
implements SQLCommand.EntryPoint {
    private final JbdbConnection _connection;
    private final int _id;
    private final int _nr;
    private final Map _statements = new HashMap();

    public final void printObjectTree() {
        Iterator<Object> iterator = this._statements.keySet().iterator();
        TreeSet treeSet = new TreeSet();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            JbdbStatement jbdbStatement = (JbdbStatement)this._statements.get((Integer)iterator.next());
            System.out.println("      stmt id: " + jbdbStatement.getId());
        }
    }

    public JbdbSession(int n, JbdbConnection jbdbConnection, String string, String string2) throws SQLException, IOException {
        this._id = n;
        this._connection = jbdbConnection;
        this._connection.sendRequestName('S');
        this._connection.sendString(string);
        this._connection.sendComma();
        this._connection.sendString(string2);
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('S');
        this._nr = this._connection.receiveSQLException() == null ? this._connection.receiveTypedInt() : -1;
        this._connection.receiveEndOfResponse();
    }

    public void stop() throws SQLException, IOException {
        Object[] objectArray = this._statements.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            JbdbStatement jbdbStatement = (JbdbStatement)objectArray[i];
            try {
                jbdbStatement.destroy();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JbdbDatabase.getSingleton().unlinkJbdbObject(this.getId());
        this._connection.unlinkSession(this.getId());
        this._connection.sendRequestName('$');
        this._connection.sendInt(this.getNr());
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('$');
        if (this._connection.receiveSQLException() == null) {
            // empty if block
        }
        this._connection.receiveEndOfResponse();
    }

    public int createStatement() throws SQLException {
        int n = JbdbDatabase.getSingleton().getNextId();
        JbdbStatement jbdbStatement = new JbdbStatement(this, n);
        this._statements.put(new Integer(n), jbdbStatement);
        JbdbDatabase.getSingleton().addJbdbObject(n, jbdbStatement);
        return n;
    }

    public void unlinkStatement(int n) {
        this._statements.remove(new Integer(n));
    }

    public JbdbConnection getConnection() {
        return this._connection;
    }

    public Object getSynchronizationObject() {
        return this.getConnection();
    }

    public int getId() {
        return this._id;
    }

    public int getNr() {
        return this._nr;
    }

    public String getEntryPointDescription() {
        return "session id " + this._id;
    }
}

