/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.BaanVMProxy;
import com.baan.baanvm.Bucket;
import com.baan.baanvm.IQueueListener;
import com.baan.baanvm.Queue;
import java.util.Hashtable;

class QueueListenerDaemon
extends Thread {
    private static Hashtable listeners;
    private IQueueListener listener;
    private int queueId;

    public static synchronized void installListener(int n, IQueueListener iQueueListener) throws Exception {
        Integer n2;
        QueueListenerDaemon queueListenerDaemon = null;
        BaanVMProxy.DebugTrace("QueueListenerDaemon::installListener(" + n + ")");
        int n3 = Queue.installListener(n);
        if (n3 != 0) {
            throw new Exception("bvmInstallListener(" + n + ") ret=" + n3);
        }
        if (listeners == null) {
            listeners = new Hashtable();
        }
        if ((queueListenerDaemon = (QueueListenerDaemon)listeners.get(n2 = new Integer(n))) != null) {
            Queue.LogMessage("QueueListener on Queue: " + n + " already installed", 0);
            throw new Exception("QueueListener on Queue: " + n + " already installed");
        }
        queueListenerDaemon = new QueueListenerDaemon(n, iQueueListener);
        listeners.put(n2, queueListenerDaemon);
        queueListenerDaemon.setDaemon(true);
        queueListenerDaemon.start();
        Queue.LogMessage("QueueListener on Queue: " + n + " installed", 0);
    }

    private static synchronized QueueListenerDaemon getListenerDaemon(int n) {
        QueueListenerDaemon queueListenerDaemon = null;
        if (listeners != null) {
            Integer n2 = new Integer(n);
            queueListenerDaemon = (QueueListenerDaemon)listeners.get(n2);
        }
        return queueListenerDaemon;
    }

    private static synchronized void removeListenerDaemon(int n) {
        if (listeners != null) {
            Integer n2 = new Integer(n);
            listeners.remove(n2);
        }
    }

    public static void dispatchQueueEvent(int n) throws Exception {
        QueueListenerDaemon queueListenerDaemon = QueueListenerDaemon.getListenerDaemon(n);
        BaanVMProxy.DebugTrace("Java: QueueListenerDaemon::dispatchQueueEvent(" + n + "," + queueListenerDaemon + ")");
        if (queueListenerDaemon == null) {
            Queue.LogMessage("QueueListenerDaemon: No QueueListener Installed on QueueId: " + n, 0);
            throw new Exception("dispatchQueueEvent: No QueueListener Installed on QueueId: " + n);
        }
        queueListenerDaemon.setBucketSync();
    }

    public QueueListenerDaemon(int n, IQueueListener iQueueListener) {
        BaanVMProxy.DebugTrace("Java: QueueListenerDaemon::QueueListenerDaemon(" + n + "," + iQueueListener + ")");
        this.queueId = n;
        this.listener = iQueueListener;
    }

    public void start() {
        super.start();
        this.setPriority(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        try {
            try {
                while (true) {
                    Bucket bucket;
                    if ((n = Queue.getBucket(this.queueId, bucket = new Bucket())) > 0 && bucket.getBucket() == null) {
                        Queue.LogMessage("Received NULL Bucket, while expecting bucket of size: " + n, 0);
                        bucket.setBucket("null");
                    }
                    if (n >= 0) {
                        Queue.LogMessage("QueueListenerDaemon.run: invoking listener for queue " + this.queueId, 0);
                        this.listener.onReceive(bucket);
                        bucket = null;
                        continue;
                    }
                    if (n != -4 || !this.getBucketSync(10000)) break;
                }
            }
            catch (NullPointerException nullPointerException) {
                Queue.LogMessage("QueueListenerDaemon::run: '" + nullPointerException + "'", 1);
                nullPointerException.printStackTrace();
                Object var4_7 = null;
                Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
                QueueListenerDaemon.removeListenerDaemon(this.queueId);
                return;
            }
            catch (ThreadDeath threadDeath) {
                Queue.LogMessage("QueueListenerDaemon::run: '" + threadDeath + "'", 0);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Queue.LogMessage("QueueListenerDaemon::run: '" + throwable + "'", 1);
                Object var4_8 = null;
                Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
                QueueListenerDaemon.removeListenerDaemon(this.queueId);
                return;
            }
            Object var4_6 = null;
            Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
            QueueListenerDaemon.removeListenerDaemon(this.queueId);
            return;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
            QueueListenerDaemon.removeListenerDaemon(this.queueId);
            throw throwable;
        }
    }

    public synchronized void setBucketSync() {
        Queue.LogMessage("QueueListenerDaemon::setBucketSync queueid " + this.queueId, 0);
        this.notify();
    }

    public synchronized boolean getBucketSync(int n) {
        BaanVMProxy.DebugTrace("QueueListenerDaemon::getBucketSync " + this + " queueid " + this.queueId);
        try {
            this.wait(n);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Queue.LogMessage("QueueListenerDaemon: wait() interrupted for QueueId: " + this.queueId, 0);
            return false;
        }
    }

    public static void stopListener(int n) {
        QueueListenerDaemon queueListenerDaemon = QueueListenerDaemon.getListenerDaemon(n);
        if (queueListenerDaemon != null) {
            Queue.LogMessage("QueueListenerDaemon: stop Java listener on queue " + n, 0);
            queueListenerDaemon.setBucketSync();
        }
    }

    public static void stopAll() {
        Queue.LogMessage("QueueListenerDaemon: stop all Java Threads", 0);
    }
}

