/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.BaanVMProxy;
import com.baan.baanvm.Bucket;

class Queue {
    Queue() {
    }

    private static native int jniGetBucket(int var0, Bucket var1);

    public static int getBucket(int n, Bucket bucket) {
        if (BaanVMProxy.isJVMI2()) {
            return BaanVMProxy.instance().getBucketFromQueue(n, bucket);
        }
        return Queue.jniGetBucket(n, bucket);
    }

    private static native int jniPutBucket(int var0, Bucket var1);

    public static int bvmPutBucket(int n, Bucket bucket) {
        if (BaanVMProxy.isJVMI2()) {
            return BaanVMProxy.instance().putBucketInQueue(n, bucket);
        }
        return Queue.jniPutBucket(n, bucket);
    }

    public static int putBucket(int n, Bucket bucket) {
        if (BaanVMProxy.isJVMI2()) {
            return BaanVMProxy.instance().putBucketInQueue(n, bucket);
        }
        return Queue.jniPutBucket(n, bucket);
    }

    private static native int jniInstallListener(int var0);

    public static int installListener(int n) {
        if (BaanVMProxy.isJVMI2()) {
            return BaanVMProxy.instance().installListenerOnQueue(n);
        }
        return Queue.jniInstallListener(n);
    }

    private static native void jniLogMessage(String var0, int var1);

    public static void LogMessage(String string, int n) {
        if (BaanVMProxy.isJVMI2()) {
            BaanVMProxy.instance().LogMessage(string, n);
        } else {
            Queue.jniLogMessage(string, n);
        }
    }

    static {
        try {
            if (BaanVMProxy.isJVMI2()) {
                Queue.LogMessage("Queue: Load Library 'jvm2bvm.dll' skipped ", 0);
            } else if (System.getProperty("java.vendor").indexOf("Microsoft") != -1) {
                System.loadLibrary("msjvm2bvm");
                Queue.LogMessage("Queue: Load Library 'msjvm2bvm.dll' succeeded ", 0);
            } else {
                System.loadLibrary("jvm2bvm");
                Queue.LogMessage("Queue: Load Library 'jvm2bvm.dll' succeeded ", 0);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Queue: load jvm2bvm: UnsatisfiedLinkError: " + unsatisfiedLinkError.toString());
            System.err.flush();
        }
        catch (SecurityException securityException) {
            System.err.println("Queue: load jvm2bvm: " + securityException.toString());
            System.err.flush();
        }
    }
}

