/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.BaanVMProxy;
import com.baan.baanvm.Bucket;
import com.baan.baanvm.ClassHolder;
import com.baan.baanvm.MethodParameter;
import com.baan.baanvm.Queue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MethodCall {
    private static final byte METHOD_DISPATCH_ENCODING_VERSION1 = 1;
    private static final byte METHOD_DISPATCH_ENCODING_VERSION2 = 2;
    private static final byte ASYNCHRONOUS = 0;
    private static final byte SYNCHRONOUS = 1;
    private static final int SIZEOFINT = 4;
    private static final int SIZEOFDOUBLE = 8;
    private boolean parseOk;
    private int baanvmProcess_1;
    private int baanvmProcess_2;
    private int offset;
    private int returnQueue;
    private byte encodingVersion;
    private byte parameterCount;
    private byte syncMode;
    private byte[] bucket;
    private String className;
    private String methodName;
    private Object[] parameterValues;
    private Class[] parameterTypes;
    private MethodParameter[] parameters;

    public MethodCall(Bucket bucket) {
        if (bucket != null) {
            this.bucket = bucket.getBucket();
        } else {
            Queue.LogMessage("MethodCall: Empty bucket", 0);
            this.bucket = null;
        }
        this.offset = 0;
        this.parseMethodCall();
    }

    private void parseMethodCall() {
        if (this.bucket == null || this.bucket.length == 0) {
            Queue.LogMessage("DispatchMethod: empty bucket: Can't dispatch", 0);
            return;
        }
        this.encodingVersion = this.getByte();
        if (this.encodingVersion != 1 && this.encodingVersion != 2) {
            Queue.LogMessage("DispatchMethod: Incompatible bucket format(" + this.encodingVersion + "): Can't dispatch", 1);
            return;
        }
        if (this.encodingVersion == 2) {
            this.returnQueue = this.getInt();
            this.baanvmProcess_1 = this.getInt();
            this.baanvmProcess_2 = this.getInt();
            this.syncMode = this.getByte();
        } else {
            this.syncMode = 0;
        }
        this.className = this.getString();
        this.methodName = this.getString();
        this.parameterCount = this.getByte();
        if (this.parameterCount > 0) {
            this.parameters = new MethodParameter[this.parameterCount];
            this.parameterValues = new Object[this.parameterCount];
            this.parameterTypes = new Class[this.parameterCount];
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            this.parameters[i] = new MethodParameter(this);
            this.parameterTypes[i] = this.parameters[i].getType();
            this.parameterValues[i] = this.parameters[i].getValue();
        }
        this.parseOk = true;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte getByte() {
        return this.bucket[this.offset++];
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = (3 - i) * 8;
            n2 += (byArray[i + n] & 0xFF) << n3;
        }
        return n2;
    }

    public static double byteArrayToDouble(byte[] byArray, int n) {
        long l = 0L;
        int n2 = 0;
        for (int i = 56; i >= 0; i -= 8) {
            l |= (long)(byArray[n + n2] & 0xFF) << i;
            ++n2;
        }
        return Double.longBitsToDouble(l);
    }

    public int getInt() {
        int n = MethodCall.byteArrayToInt(this.bucket, this.offset);
        BaanVMProxy.DebugTrace("getInt(): " + n);
        this.offset += 4;
        return n;
    }

    public double getDouble() {
        double d = MethodCall.byteArrayToDouble(this.bucket, this.offset);
        BaanVMProxy.DebugTrace("getDouble(): " + d);
        this.offset += 8;
        return d;
    }

    public String getString() {
        int n = this.getInt();
        int n2 = this.offset;
        this.offset += n;
        BaanVMProxy.DebugTrace("getString(): '" + new String(this.bucket, n2, n) + "'");
        return new String(this.bucket, n2, n);
    }

    public String getString(int n) {
        int n2 = this.offset;
        this.offset += n;
        return new String(this.bucket, n2, n);
    }

    public void sendOk() {
        if (this.encodingVersion == 2) {
            String string = this.baanvmProcess_1 + ":" + this.baanvmProcess_2;
            String string2 = "0";
            Bucket bucket = new Bucket(string2, string);
            Queue.putBucket(this.returnQueue, bucket);
        }
    }

    public void sendNotOk() {
        if (this.encodingVersion == 2) {
            String string = this.baanvmProcess_1 + ":" + this.baanvmProcess_2;
            String string2 = "-1";
            Bucket bucket = new Bucket(string2, string);
            Queue.putBucket(this.returnQueue, bucket);
        }
    }

    public void invokeStaticMethod() {
        boolean bl = false;
        if (!this.parseOk) {
            this.sendNotOk();
            return;
        }
        try {
            Class clazz = ClassHolder.instance().getClass(this.className);
            Method method = clazz.getMethod(this.methodName, this.parameterTypes);
            Queue.LogMessage("InvokeStaticMethod:" + this.className + "." + this.methodName + " (" + this.parameterCount + " parameters, types: " + MethodCall.arrayToString(this.parameterTypes) + ")", 0);
            if (this.syncMode == 0) {
                this.sendOk();
                bl = true;
            }
            method.invoke(null, this.parameterValues);
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Queue.LogMessage("InvokeStaticMethod(" + this.className + "." + this.methodName + ") failed: " + invocationTargetException.getTargetException().getMessage(), 1);
        }
        catch (Exception exception) {
            Queue.LogMessage("InvokeStaticMethod failed: " + exception.getMessage(), 1);
        }
        if (bl) {
            if (this.syncMode == 1) {
                this.sendOk();
            }
        } else {
            this.sendNotOk();
        }
    }

    public String toString() {
        return "parseOk: " + this.parseOk + " baanvmProcess_1: " + this.baanvmProcess_1 + " baanvmProcess_2: " + this.baanvmProcess_2 + " offset: " + this.offset + " returnQueue: " + this.returnQueue + " encodingVersion: " + this.encodingVersion + " parameterCount: " + this.parameterCount + " syncMode: " + this.syncMode + " bucket: " + this.bucket + " className: " + this.className + " methodName: " + this.methodName + " parameterValues: " + MethodCall.arrayToString(this.parameterValues) + " parameterTypes: " + MethodCall.arrayToString(this.parameterTypes) + " parameters: " + MethodCall.arrayToString(this.parameters);
    }

    private static String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString() + ",");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

